/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.List;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.merge.AddColumnToModel;
import org.apache.cayenne.merge.MergeCase;
import org.apache.cayenne.merge.MergerToken;
import org.junit.Assert;
import org.junit.Test;

public class AddColumnToModelIT
extends MergeCase {
    @Test
    public void testAddColumn() throws Exception {
        this.dropTableIfPresent("NEW_TABLE");
        this.assertTokensAndExecute(0, 0);
        DbEntity dbEntity = new DbEntity("NEW_TABLE");
        DbAttribute column1 = new DbAttribute("ID", 4, dbEntity);
        column1.setMandatory(true);
        column1.setPrimaryKey(true);
        dbEntity.addAttribute(column1);
        DbAttribute column2 = new DbAttribute("NAME", 12, dbEntity);
        column2.setMaxLength(10);
        column2.setMandatory(false);
        dbEntity.addAttribute(column2);
        this.map.addDbEntity(dbEntity);
        this.assertTokensAndExecute(1, 0);
        this.assertTokensAndExecute(0, 0);
        ObjEntity objEntity = new ObjEntity("NewTable");
        objEntity.setDbEntity(dbEntity);
        ObjAttribute oatr1 = new ObjAttribute("name");
        oatr1.setDbAttributePath(column2.getName());
        oatr1.setType("java.lang.String");
        objEntity.addAttribute(oatr1);
        this.map.addObjEntity(objEntity);
        objEntity.removeAttribute(oatr1.getName());
        dbEntity.removeAttribute(column2.getName());
        Assert.assertNull((Object)objEntity.getAttribute(oatr1.getName()));
        Assert.assertEquals((long)0L, (long)objEntity.getAttributes().size());
        Assert.assertNull((Object)dbEntity.getAttribute(column2.getName()));
        List<MergerToken> tokens = this.createMergeTokens();
        Assert.assertEquals((long)1L, (long)tokens.size());
        MergerToken token = tokens.get(0);
        if (token.getDirection().isToDb()) {
            token = token.createReverse(this.mergerFactory());
        }
        Assert.assertTrue((boolean)(token instanceof AddColumnToModel));
        this.execute(token);
        Assert.assertEquals((long)1L, (long)objEntity.getAttributes().size());
        Assert.assertEquals((Object)"java.lang.String", (Object)objEntity.getAttributes().iterator().next().getType());
        this.map.removeObjEntity(objEntity.getName(), true);
        this.map.removeDbEntity(dbEntity.getName(), true);
        this.resolver.refreshMappingCache();
        Assert.assertNull((Object)this.map.getObjEntity(objEntity.getName()));
        Assert.assertNull((Object)this.map.getDbEntity(dbEntity.getName()));
        Assert.assertFalse((boolean)this.map.getDbEntities().contains(dbEntity));
        this.assertTokensAndExecute(1, 0);
        this.assertTokensAndExecute(0, 0);
    }
}

