/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.Collection;
import java.util.Iterator;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.MockAttribute;
import org.apache.cayenne.map.MockEntity;
import org.apache.cayenne.map.MockRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.util.Util;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class EntityIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;

    @Test
    public void testSerializability() throws Exception {
        MockEntity entity = new MockEntity("entity");
        Entity d1 = Util.cloneViaSerialization(entity);
        Assert.assertEquals((Object)entity.getName(), (Object)d1.getName());
        entity.addAttribute(new MockAttribute("abc"));
        entity.addRelationship(new MockRelationship("xyz"));
        Entity d2 = Util.cloneViaSerialization(entity);
        Assert.assertNotNull((Object)d2.getAttribute("abc"));
        Assert.assertNotNull(d2.getAttributes());
        Assert.assertEquals((long)entity.getAttributes().size(), (long)d2.getAttributes().size());
        Assert.assertTrue((boolean)d2.getAttributes().contains(d2.getAttribute("abc")));
        Assert.assertNotNull(d2.getRelationships());
        Assert.assertEquals((long)entity.getRelationships().size(), (long)d2.getRelationships().size());
        Assert.assertTrue((boolean)d2.getRelationships().contains(d2.getRelationship("xyz")));
        Assert.assertNotNull(d2.getAttributeMap());
        Assert.assertEquals((long)entity.getAttributes().size(), (long)d2.getAttributeMap().size());
        Assert.assertSame((Object)d2.getAttribute("abc"), d2.getAttributeMap().get("abc"));
        Assert.assertNotNull(d2.getRelationshipMap());
        Assert.assertEquals((long)entity.getRelationships().size(), (long)d2.getRelationshipMap().size());
        Assert.assertSame((Object)d2.getRelationship("xyz"), d2.getRelationshipMap().get("xyz"));
    }

    @Test
    public void testName() {
        MockEntity entity = new MockEntity();
        String tstName = "tst_name";
        entity.setName(tstName);
        Assert.assertEquals((Object)tstName, (Object)entity.getName());
    }

    @Test
    public void testAttribute() {
        MockEntity entity = new MockEntity();
        MockAttribute attribute = new MockAttribute("tst_name");
        entity.addAttribute(attribute);
        Assert.assertSame((Object)attribute, (Object)entity.getAttribute(attribute.getName()));
        Assert.assertSame((Object)entity, (Object)attribute.getEntity());
        entity.removeAttribute(attribute.getName());
        Assert.assertNull((Object)entity.getAttribute(attribute.getName()));
    }

    @Test
    public void testRelationship() {
        MockEntity entity = new MockEntity();
        MockRelationship rel = new MockRelationship("tst_name");
        entity.addRelationship(rel);
        Assert.assertSame((Object)rel, (Object)entity.getRelationship(rel.getName()));
        Assert.assertSame((Object)entity, (Object)rel.getSourceEntity());
        entity.removeRelationship(rel.getName());
        Assert.assertNull((Object)entity.getRelationship(rel.getName()));
    }

    @Test
    public void testAttributeClashWithRelationship() {
        MockEntity entity = new MockEntity();
        MockRelationship rel = new MockRelationship("tst_name");
        entity.addRelationship(rel);
        try {
            MockAttribute attribute = new MockAttribute("tst_name");
            entity.addAttribute(attribute);
            Assert.fail((String)"Exception should have been thrown due to clashing attribute and relationship names.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testRelationshipClashWithAttribute() {
        MockEntity entity = new MockEntity();
        MockAttribute attribute = new MockAttribute("tst_name");
        entity.addAttribute(attribute);
        try {
            MockRelationship rel = new MockRelationship("tst_name");
            entity.addRelationship(rel);
            Assert.fail((String)"Exception should have been thrown due to clashing attribute and relationship names.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testResolveBadObjPath1() {
        Expression pathExpr = ExpressionFactory.expressionOfType(26);
        pathExpr.setOperand(0, "invalid.invalid");
        ObjEntity galleryEnt = this.runtime.getDataDomain().getEntityResolver().getObjEntity("Gallery");
        Iterator<CayenneMapEntry> it = galleryEnt.resolvePathComponents(pathExpr);
        Assert.assertTrue((boolean)it.hasNext());
        try {
            it.next();
            Assert.fail();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    @Test
    public void testResolveBadObjPath2() {
        Expression badPathExpr = ExpressionFactory.expressionOfType(10);
        badPathExpr.setOperand(0, "a.b.c");
        ObjEntity galleryEnt = this.runtime.getDataDomain().getEntityResolver().getObjEntity("Gallery");
        try {
            galleryEnt.resolvePathComponents(badPathExpr);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testResolveObjPath1() {
        Expression pathExpr = ExpressionFactory.expressionOfType(26);
        pathExpr.setOperand(0, "galleryName");
        ObjEntity galleryEnt = this.runtime.getDataDomain().getEntityResolver().getObjEntity("Gallery");
        Iterator<CayenneMapEntry> it = galleryEnt.resolvePathComponents(pathExpr);
        Assert.assertNotNull(it);
        Assert.assertTrue((boolean)it.hasNext());
        ObjAttribute next = (ObjAttribute)it.next();
        Assert.assertNotNull((Object)next);
        Assert.assertFalse((boolean)it.hasNext());
        Assert.assertSame((Object)galleryEnt.getAttribute("galleryName"), (Object)next);
    }

    @Test
    public void testRemoveAttribute() {
        MockEntity entity = new MockEntity();
        entity.setName("test");
        ObjAttribute attribute1 = new ObjAttribute("a1");
        ObjAttribute attribute2 = new ObjAttribute("a2");
        entity.addAttribute(attribute1);
        entity.addAttribute(attribute2);
        Collection<? extends Attribute> attributes = entity.getAttributes();
        Assert.assertEquals((long)2L, (long)attributes.size());
        entity.removeAttribute("a1");
        attributes = entity.getAttributes();
        Assert.assertEquals((long)1L, (long)attributes.size());
    }
}

