/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ejbql;

import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.ejbql.EJBQLParser;
import org.apache.cayenne.ejbql.EJBQLParserFactory;
import org.junit.Assert;
import org.junit.Test;

public class EJBQLExpressionTest {
    @Test
    public void testDbPath() {
        EJBQLParser parser = EJBQLParserFactory.getParser();
        EJBQLExpression select = parser.parse("select p from Painting p WHERE db:p.toArtist.ARTIST_NAME = 'a'");
        Assert.assertNotNull((Object)select);
    }

    @Test
    public void testEnumPath() {
        EJBQLParser parser = EJBQLParserFactory.getParser();
        EJBQLExpression select = parser.parse("select p from Painting p WHERE p.toArtist.ARTIST_NAME = enum:org.apache.cayenne.ejbql.EJBQLEnum1.X");
        Assert.assertNotNull((Object)select);
    }

    @Test
    public void testInWithMultipleStringPositionalParameter_withoutBrackets() {
        EJBQLParser parser = EJBQLParserFactory.getParser();
        try {
            EJBQLExpression select = parser.parse("select p from Painting p WHERE p.toArtist IN ?1, ?2");
            Assert.fail((String)"a test in clause with multiple unbracketed parameters parsed; should not be possible");
        }
        catch (EJBQLException ejbqlE) {
        }
        catch (Throwable th) {
            Assert.fail((String)("expected an instance of " + EJBQLException.class.getSimpleName() + " to be thrown, but; " + th.getClass().getSimpleName() + " was thrown"));
        }
    }
}

