/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.io.IOException;
import java.net.URL;
import javax.sql.DataSource;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.server.DBCPDataSourceFactory;
import org.apache.cayenne.resource.URLResource;
import org.apache.commons.dbcp.BasicDataSource;
import org.junit.Assert;
import org.junit.Test;

public class DBCPDataSourceFactoryTest {
    @Test
    public void testGetDataSource() throws Exception {
        String baseUrl = this.getClass().getPackage().getName().replace('.', '/');
        URL url = this.getClass().getClassLoader().getResource(baseUrl + "/");
        Assert.assertNotNull((Object)url);
        DataNodeDescriptor nodeDescriptor = new DataNodeDescriptor();
        nodeDescriptor.setConfigurationSource(new URLResource(url));
        nodeDescriptor.setParameters("testDBCP.properties");
        DBCPDataSourceFactory factory = new DBCPDataSourceFactory();
        DataSource dataSource = factory.getDataSource(nodeDescriptor);
        Assert.assertNotNull((Object)dataSource);
        Assert.assertTrue((boolean)(dataSource instanceof BasicDataSource));
        BasicDataSource basicDataSource = (BasicDataSource)dataSource;
        Assert.assertEquals((Object)"com.example.jdbc.Driver", (Object)basicDataSource.getDriverClassName());
        Assert.assertEquals((Object)"jdbc:somedb://localhost/cayenne", (Object)basicDataSource.getUrl());
        Assert.assertEquals((Object)"john", (Object)basicDataSource.getUsername());
        Assert.assertEquals((Object)"secret", (Object)basicDataSource.getPassword());
        Assert.assertEquals((long)20L, (long)basicDataSource.getMaxActive());
        Assert.assertEquals((long)5L, (long)basicDataSource.getMinIdle());
        Assert.assertEquals((long)8L, (long)basicDataSource.getMaxIdle());
        Assert.assertEquals((long)10000L, (long)basicDataSource.getMaxWait());
        Assert.assertEquals((Object)"select 1 from xyz;", (Object)basicDataSource.getValidationQuery());
    }

    @Test
    public void testGetDataSource_LegacyConfig() throws Exception {
        String baseUrl = this.getClass().getPackage().getName().replace('.', '/');
        URL url = this.getClass().getClassLoader().getResource(baseUrl + "/");
        Assert.assertNotNull((Object)url);
        DataNodeDescriptor nodeDescriptor = new DataNodeDescriptor();
        nodeDescriptor.setConfigurationSource(new URLResource(url));
        nodeDescriptor.setParameters("testDBCP_legacy.properties");
        DBCPDataSourceFactory factory = new DBCPDataSourceFactory();
        DataSource dataSource = factory.getDataSource(nodeDescriptor);
        Assert.assertNotNull((Object)dataSource);
        Assert.assertTrue((boolean)(dataSource instanceof BasicDataSource));
        BasicDataSource basicDataSource = (BasicDataSource)dataSource;
        Assert.assertEquals((Object)"com.example.jdbc.Driver", (Object)basicDataSource.getDriverClassName());
        Assert.assertEquals((Object)"jdbc:somedb://localhost/cayenne", (Object)basicDataSource.getUrl());
        Assert.assertEquals((Object)"john", (Object)basicDataSource.getUsername());
        Assert.assertEquals((Object)"secret", (Object)basicDataSource.getPassword());
        Assert.assertEquals((long)20L, (long)basicDataSource.getMaxActive());
        Assert.assertEquals((long)5L, (long)basicDataSource.getMinIdle());
        Assert.assertEquals((long)8L, (long)basicDataSource.getMaxIdle());
        Assert.assertEquals((long)10000L, (long)basicDataSource.getMaxWait());
        Assert.assertEquals((Object)"select 1 from xyz;", (Object)basicDataSource.getValidationQuery());
    }

    @Test
    public void testGetDataSource_InvalidLocation() throws Exception {
        String baseUrl = this.getClass().getPackage().getName().replace('.', '/');
        URL url = this.getClass().getClassLoader().getResource(baseUrl + "/");
        Assert.assertNotNull((Object)url);
        DataNodeDescriptor nodeDescriptor = new DataNodeDescriptor();
        nodeDescriptor.setConfigurationSource(new URLResource(url));
        nodeDescriptor.setParameters("testDBCP.properties.nosuchfile");
        DBCPDataSourceFactory factory = new DBCPDataSourceFactory();
        try {
            factory.getDataSource(nodeDescriptor);
            Assert.fail((String)"didn't throw on abscent config file");
        }
        catch (IOException ex) {
            // empty catch block
        }
    }
}

