/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.server.XMLPoolingDataSourceFactory;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class DataNodeDescriptor
implements ConfigurationNode,
XMLSerializable,
Serializable,
Comparable<DataNodeDescriptor> {
    protected String name;
    protected Collection<String> dataMapNames = new ArrayList<String>();
    protected String parameters;
    protected String adapterType;
    protected String dataSourceFactoryType;
    protected String schemaUpdateStrategyType;
    protected DataSourceInfo dataSourceDescriptor;
    protected Resource configurationSource;
    protected DataChannelDescriptor dataChannelDescriptor;

    public DataNodeDescriptor() {
        this(null);
    }

    public DataNodeDescriptor(String name) {
        this.name = name;
    }

    public DataChannelDescriptor getDataChannelDescriptor() {
        return this.dataChannelDescriptor;
    }

    public void setDataChannelDescriptor(DataChannelDescriptor dataChannelDescriptor) {
        this.dataChannelDescriptor = dataChannelDescriptor;
    }

    @Override
    public int compareTo(DataNodeDescriptor o) {
        String o1 = this.getName();
        String o2 = o.getName();
        if (o1 == null) {
            return o2 != null ? -1 : 0;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.compareTo(o2);
    }

    @Override
    public <T> T acceptVisitor(ConfigurationNodeVisitor<T> visitor) {
        return visitor.visitDataNodeDescriptor(this);
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<node");
        encoder.printlnAttribute("name", this.name);
        encoder.indent(1);
        encoder.printlnAttribute("adapter", this.adapterType);
        encoder.printlnAttribute("factory", this.dataSourceFactoryType);
        if (!XMLPoolingDataSourceFactory.class.getName().equals(this.dataSourceFactoryType)) {
            encoder.printlnAttribute("parameters", this.parameters);
        }
        encoder.printlnAttribute("schema-update-strategy", this.schemaUpdateStrategyType);
        encoder.println(">");
        if (!this.dataMapNames.isEmpty()) {
            ArrayList<String> names = new ArrayList<String>(this.dataMapNames);
            Collections.sort(names);
            for (String mapName : names) {
                encoder.print("<map-ref");
                encoder.printAttribute("name", mapName);
                encoder.println("/>");
            }
        }
        if (this.dataSourceDescriptor != null && XMLPoolingDataSourceFactory.class.getName().equals(this.dataSourceFactoryType)) {
            this.dataSourceDescriptor.encodeAsXML(encoder);
        }
        encoder.indent(-1);
        encoder.println("</node>");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<String> getDataMapNames() {
        return this.dataMapNames;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public String getAdapterType() {
        return this.adapterType;
    }

    public void setAdapterType(String adapter) {
        this.adapterType = adapter;
    }

    public String getDataSourceFactoryType() {
        return this.dataSourceFactoryType;
    }

    public void setDataSourceFactoryType(String dataSourceFactory) {
        this.dataSourceFactoryType = dataSourceFactory;
    }

    public String getSchemaUpdateStrategyType() {
        return this.schemaUpdateStrategyType;
    }

    public void setSchemaUpdateStrategyType(String schemaUpdateStrategyClass) {
        this.schemaUpdateStrategyType = schemaUpdateStrategyClass;
    }

    public DataSourceInfo getDataSourceDescriptor() {
        return this.dataSourceDescriptor;
    }

    public void setDataSourceDescriptor(DataSourceInfo dataSourceDescriptor) {
        this.dataSourceDescriptor = dataSourceDescriptor;
    }

    public Resource getConfigurationSource() {
        return this.configurationSource;
    }

    public void setConfigurationSource(Resource configurationResource) {
        this.configurationSource = configurationResource;
    }
}

