/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ashwood.graph;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.ashwood.graph.ArcIterator;
import org.apache.cayenne.ashwood.graph.Digraph;

public class MapDigraph<E, V>
implements Digraph<E, V> {
    private Map<E, Map<E, V>> graph = new HashMap<E, Map<E, V>>();
    private int size;

    @Override
    public boolean addVertex(E vertex) {
        if (this.graph.containsKey(vertex)) {
            return false;
        }
        this.graph.put(vertex, new HashMap());
        return true;
    }

    @Override
    public boolean addAllVertices(Collection<? extends E> vertices) {
        if (this.graph.keySet().containsAll(vertices)) {
            return false;
        }
        for (E vertex : vertices) {
            this.addVertex(vertex);
        }
        return true;
    }

    @Override
    public V putArc(E origin, E destination, V arc) {
        Map<E, V> destinations = this.graph.get(origin);
        if (destinations == null) {
            destinations = new HashMap<E, V>();
            this.graph.put(origin, destinations);
        }
        this.addVertex(destination);
        V oldArc = destinations.put(destination, arc);
        if (oldArc == null) {
            ++this.size;
        }
        return oldArc;
    }

    @Override
    public V getArc(Object origin, Object destination) {
        Map<E, V> destinations = this.graph.get(origin);
        if (destinations == null) {
            return null;
        }
        return destinations.get(destination);
    }

    @Override
    public boolean removeVertex(E vertex) {
        Map<E, V> destination = this.graph.remove(vertex);
        if (destination != null) {
            this.size -= destination.size();
        } else {
            return false;
        }
        this.removeIncoming(vertex);
        return true;
    }

    @Override
    public boolean removeAllVertices(Collection<? extends E> vertices) {
        boolean modified = false;
        for (E vertex : vertices) {
            modified |= this.removeVertex(vertex);
        }
        return modified;
    }

    @Override
    public Object removeArc(E origin, E destination) {
        Map<E, V> destinations = this.graph.get(origin);
        if (destinations == null) {
            return null;
        }
        V arc = destinations.remove(destination);
        if (arc != null) {
            --this.size;
        }
        return arc;
    }

    @Override
    public boolean removeIncoming(E vertex) {
        boolean modified = false;
        for (Map<E, V> destinations : this.graph.values()) {
            V arc = destinations.remove(vertex);
            if (arc != null) {
                --this.size;
            }
            modified |= arc != null;
        }
        return modified;
    }

    @Override
    public boolean removeOutgoing(E vertex) {
        Map<E, V> destinations = this.graph.remove(vertex);
        if (destinations != null) {
            this.size -= destinations.size();
        } else {
            return false;
        }
        boolean modified = !destinations.isEmpty();
        destinations.clear();
        return modified;
    }

    @Override
    public Iterator<E> vertexIterator() {
        return this.graph.keySet().iterator();
    }

    @Override
    public ArcIterator<E, V> arcIterator() {
        return new AllArcIterator();
    }

    @Override
    public ArcIterator<E, V> outgoingIterator(E vertex) {
        if (!this.containsVertex(vertex)) {
            return ArcIterator.EMPTY_ITERATOR;
        }
        return new OutgoingArcIterator(vertex);
    }

    @Override
    public ArcIterator<E, V> incomingIterator(E vertex) {
        if (!this.containsVertex(vertex)) {
            return ArcIterator.EMPTY_ITERATOR;
        }
        return new IncomingArcIterator(vertex);
    }

    @Override
    public int order() {
        return this.graph.size();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int outgoingSize(E vertex) {
        Map<E, V> destinations = this.graph.get(vertex);
        if (destinations == null) {
            return 0;
        }
        return destinations.size();
    }

    @Override
    public int incomingSize(E vertex) {
        int count = 0;
        if (!this.graph.containsKey(vertex)) {
            return 0;
        }
        for (Map<E, V> destinations : this.graph.values()) {
            count += destinations.containsKey(vertex) ? 1 : 0;
        }
        return count;
    }

    @Override
    public boolean containsVertex(E vertex) {
        return this.graph.containsKey(vertex);
    }

    @Override
    public boolean containsAllVertices(Collection<? extends E> vertices) {
        return this.graph.keySet().containsAll(vertices);
    }

    @Override
    public boolean hasArc(E origin, E destination) {
        Map<E, V> destinations = this.graph.get(origin);
        if (destinations == null) {
            return false;
        }
        return destinations.containsKey(destination);
    }

    @Override
    public boolean isEmpty() {
        return this.graph.isEmpty();
    }

    @Override
    public boolean isOutgoingEmpty(E vertex) {
        return this.outgoingSize(vertex) == 0;
    }

    @Override
    public boolean isIncomingEmpty(E vertex) {
        return this.incomingSize(vertex) == 0;
    }

    private class IncomingArcIterator
    implements ArcIterator<E, V> {
        private E dst;
        private E origin;
        private E nextOrigin;
        private V arc;
        private V nextArc;
        private Iterator<Map.Entry<E, Map<E, V>>> graphIt;

        private IncomingArcIterator(E vertex) {
            this.dst = vertex;
            this.graphIt = MapDigraph.this.graph.entrySet().iterator();
            this.next();
        }

        @Override
        public E getOrigin() {
            return this.origin;
        }

        @Override
        public E getDestination() {
            return this.dst;
        }

        @Override
        public boolean hasNext() {
            return this.nextArc != null;
        }

        @Override
        public V next() {
            this.origin = this.nextOrigin;
            this.arc = this.nextArc;
            this.nextArc = null;
            this.nextOrigin = null;
            while (this.graphIt.hasNext()) {
                Map.Entry entry = this.graphIt.next();
                Map destinations = entry.getValue();
                this.nextArc = destinations.get(this.dst);
                if (this.nextArc == null) continue;
                this.nextOrigin = entry.getKey();
                break;
            }
            return this.arc;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Method remove() not yet implemented.");
        }
    }

    private class OutgoingArcIterator
    implements ArcIterator<E, V> {
        private E origin;
        private Iterator<Map.Entry<E, V>> dstIt;
        private Map.Entry<E, V> entry;

        private OutgoingArcIterator(E vertex) {
            this.origin = vertex;
            this.dstIt = ((Map)MapDigraph.this.graph.get(vertex)).entrySet().iterator();
        }

        @Override
        public E getOrigin() {
            return this.origin;
        }

        @Override
        public E getDestination() {
            if (this.entry == null) {
                return null;
            }
            return this.entry.getKey();
        }

        @Override
        public boolean hasNext() {
            return this.dstIt.hasNext();
        }

        @Override
        public V next() {
            this.entry = this.dstIt.next();
            return this.entry.getValue();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Method remove() not yet implemented.");
        }
    }

    private class AllArcIterator
    implements ArcIterator<E, V> {
        private Iterator<Map.Entry<E, Map<E, V>>> originIterator;
        private Iterator<Map.Entry<E, V>> destinationIterator;
        private E origin;
        private E nextOrigin;
        private E destination;
        private E nextDst;
        private V arc;
        private V nextArc;

        private AllArcIterator() {
            this.originIterator = MapDigraph.this.graph.entrySet().iterator();
            this.next();
        }

        @Override
        public E getOrigin() {
            return this.origin;
        }

        @Override
        public E getDestination() {
            return this.destination;
        }

        @Override
        public boolean hasNext() {
            return this.nextArc != null;
        }

        @Override
        public V next() {
            this.origin = this.nextOrigin;
            this.destination = this.nextDst;
            this.arc = this.nextArc;
            if (this.destinationIterator == null || !this.destinationIterator.hasNext()) {
                this.nextOrigin = null;
                this.nextDst = null;
                this.nextArc = null;
                while (this.originIterator.hasNext()) {
                    Map.Entry entry = this.originIterator.next();
                    this.destinationIterator = entry.getValue().entrySet().iterator();
                    if (!this.destinationIterator.hasNext()) continue;
                    this.nextOrigin = entry.getKey();
                    Map.Entry entry1 = this.destinationIterator.next();
                    this.nextDst = entry1.getKey();
                    this.nextArc = entry1.getValue();
                    break;
                }
            } else {
                Map.Entry entry1 = this.destinationIterator.next();
                this.nextDst = entry1.getKey();
                this.nextArc = entry1.getValue();
            }
            return this.arc;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Method remove() not yet implemented.");
        }
    }
}

