/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.JoinType;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;

public abstract class QueryAssembler {
    protected Query query;
    protected QueryMetadata queryMetadata;
    protected String cachedSqlString;
    protected Connection connection;
    protected DbAdapter adapter;
    protected EntityResolver entityResolver;
    protected JdbcEventLogger logger;
    protected List<Object> values = new ArrayList<Object>();
    protected List<DbAttribute> attributes = new ArrayList<DbAttribute>();
    protected int parameterIndex;

    public QueryAssembler(Query query, DataNode dataNode, Connection connection) {
        this.logger = dataNode.getJdbcEventLogger();
        this.entityResolver = dataNode.getEntityResolver();
        this.adapter = dataNode.getAdapter();
        this.query = query;
        this.connection = connection;
        this.queryMetadata = query.getMetaData(this.entityResolver);
    }

    protected Map<String, String> getPathAliases() {
        return this.query.getMetaData(this.entityResolver).getPathSplitAliases();
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public DbAdapter getAdapter() {
        return this.adapter;
    }

    public Query getQuery() {
        return this.query;
    }

    public QueryMetadata getQueryMetadata() {
        return this.queryMetadata;
    }

    public JdbcEventLogger getJdbcEventLogger() {
        return this.logger;
    }

    public DbEntity getRootDbEntity() {
        return this.queryMetadata.getDbEntity();
    }

    public ObjEntity getRootEntity() {
        return this.queryMetadata.getObjEntity();
    }

    public abstract void resetJoinStack();

    public abstract String getCurrentAlias();

    public abstract void dbRelationshipAdded(DbRelationship var1, JoinType var2, String var3);

    public abstract String createSqlString() throws Exception;

    public boolean supportsTableAliases() {
        return false;
    }

    public void addToParamList(DbAttribute dbAttr, Object anObject) {
        this.attributes.add(this.parameterIndex, dbAttr);
        this.values.add(this.parameterIndex++, anObject);
    }

    public PreparedStatement createStatement() throws Exception {
        long t1 = System.currentTimeMillis();
        String sqlStr = this.createSqlString();
        this.logger.logQuery(sqlStr, this.attributes, this.values, System.currentTimeMillis() - t1);
        PreparedStatement stmt = this.connection.prepareStatement(sqlStr);
        this.initStatement(stmt);
        return stmt;
    }

    protected void initStatement(PreparedStatement stmt) throws Exception {
        if (this.values != null && this.values.size() > 0) {
            int len = this.values.size();
            for (int i = 0; i < len; ++i) {
                Object val = this.values.get(i);
                DbAttribute attr = this.attributes.get(i);
                if (attr == null) {
                    stmt.setObject(i + 1, val);
                    continue;
                }
                this.adapter.bindParameter(stmt, val, i + 1, attr.getType(), attr.getScale());
            }
        }
        if (this.queryMetadata.getStatementFetchSize() != 0) {
            stmt.setFetchSize(this.queryMetadata.getStatementFetchSize());
        }
    }
}

