/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.sql.Connection;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.translator.select.QualifierTranslator;
import org.apache.cayenne.access.translator.select.TstQueryAssembler;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.TstBinaryExpSuite;
import org.apache.cayenne.exp.TstExpressionCase;
import org.apache.cayenne.exp.TstExpressionSuite;
import org.apache.cayenne.exp.TstTernaryExpSuite;
import org.apache.cayenne.exp.TstUnaryExpSuite;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.MockQuery;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.ServerCaseDataSourceFactory;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class QualifierTranslatorIT
extends ServerCase {
    @Inject
    private DataNode node;
    @Inject
    private ServerCaseDataSourceFactory dataSourceFactory;
    private Connection connection;

    @Before
    public void setUp() throws Exception {
        this.connection = this.dataSourceFactory.getSharedDataSource().getConnection();
    }

    @After
    public void tearDown() throws Exception {
        this.connection.close();
    }

    @Test
    public void testNonQualifiedQuery() throws Exception {
        TstQueryAssembler qa = new TstQueryAssembler(new MockQuery(), this.node, this.connection);
        try {
            new QualifierTranslator(qa).appendPart(new StringBuilder());
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    public void testNullQualifier() throws Exception {
        TstQueryAssembler qa = new TstQueryAssembler(new SelectQuery(), this.node, this.connection);
        StringBuilder out = new StringBuilder();
        new QualifierTranslator(qa).appendPart(out);
        Assert.assertEquals((long)0L, (long)out.length());
    }

    @Test
    public void testUnary() throws Exception {
        this.doExpressionTest(new TstUnaryExpSuite());
    }

    @Test
    public void testBinary() throws Exception {
        this.doExpressionTest(new TstBinaryExpSuite());
    }

    @Test
    public void testTernary() throws Exception {
        this.doExpressionTest(new TstTernaryExpSuite());
    }

    @Test
    public void testExtras() throws Exception {
        ObjectId oid1 = new ObjectId("Gallery", "GALLERY_ID", 1);
        ObjectId oid2 = new ObjectId("Gallery", "GALLERY_ID", 2);
        Gallery g1 = new Gallery();
        Gallery g2 = new Gallery();
        g1.setObjectId(oid1);
        g2.setObjectId(oid2);
        Expression e1 = ExpressionFactory.matchExp("toGallery", g1);
        Expression e2 = e1.orExp(ExpressionFactory.matchExp("toGallery", g2));
        TstExpressionCase extraCase = new TstExpressionCase("Exhibit", e2, "(ta.GALLERY_ID = ?) OR (ta.GALLERY_ID = ?)", 4, 4);
        TstExpressionSuite suite = new TstExpressionSuite(){};
        suite.addCase(extraCase);
        this.doExpressionTest(suite);
    }

    private void doExpressionTest(TstExpressionSuite suite) throws Exception {
        TstExpressionCase[] cases = suite.cases();
        int len = cases.length;
        for (int i = 0; i < len; ++i) {
            try {
                ObjEntity entity = this.node.getEntityResolver().getObjEntity(cases[i].getRootEntity());
                Assert.assertNotNull((Object)entity);
                SelectQuery q = new SelectQuery(entity);
                q.setQualifier(cases[i].getCayenneExp());
                TstQueryAssembler qa = new TstQueryAssembler(q, this.node, this.connection);
                StringBuilder out = new StringBuilder();
                new QualifierTranslator(qa).appendPart(out);
                cases[i].assertTranslatedWell(out.toString());
                continue;
            }
            catch (Exception ex) {
                throw new CayenneRuntimeException("Failed case: [" + i + "]: " + cases[i], (Throwable)ex, new Object[0]);
            }
        }
    }
}

