/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.ejbql;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.access.translator.ejbql.EJBQLSelectTranslator;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslationContext;
import org.apache.cayenne.access.translator.ejbql.JdbcEJBQLTranslatorFactory;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.ejbql.EJBQLCompiledExpression;
import org.apache.cayenne.ejbql.EJBQLParser;
import org.apache.cayenne.ejbql.EJBQLParserFactory;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class EJBQLSelectTranslatorIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    @Inject
    private DbAdapter adapter;

    private SQLTemplate translateSelect(String ejbql) {
        return this.translateSelect(ejbql, Collections.EMPTY_MAP);
    }

    private SQLTemplate translateSelect(String ejbql, final Map<Integer, Object> queryParameters) {
        EJBQLParser parser = EJBQLParserFactory.getParser();
        EJBQLCompiledExpression select = parser.compile(ejbql, this.runtime.getDataDomain().getEntityResolver());
        EJBQLQuery query = new EJBQLQuery(ejbql){

            @Override
            public Map<Integer, Object> getPositionalParameters() {
                return queryParameters;
            }
        };
        EJBQLTranslationContext tr = new EJBQLTranslationContext(this.runtime.getDataDomain().getEntityResolver(), query, select, new JdbcEJBQLTranslatorFactory(), this.adapter.getQuotingStrategy());
        select.getExpression().visit(new EJBQLSelectTranslator(tr));
        return tr.getQuery();
    }

    @Test
    public void testSelectFrom() {
        SQLTemplate query = this.translateSelect("select a from Artist a");
        String sql = query.getDefaultTemplate();
        Assert.assertTrue((String)sql, (boolean)sql.startsWith("SELECT"));
        Assert.assertTrue((String)sql, (sql.indexOf("t0.ARTIST_ID") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)sql, (sql.indexOf("t0.ARTIST_NAME") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)sql, (sql.indexOf("t0.DATE_OF_BIRTH") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)sql, (boolean)sql.endsWith(" FROM ARTIST t0"));
    }

    @Test
    public void testSelectMultipleJoinsToTheSameTable() throws Exception {
        SQLTemplate query = this.translateSelect("SELECT a FROM Artist a JOIN a.paintingArray b JOIN a.paintingArray c WHERE b.paintingTitle = 'P1' AND c.paintingTitle = 'P2'");
        String sql = query.getDefaultTemplate();
        Assert.assertTrue((String)sql, (boolean)sql.startsWith("SELECT"));
        Assert.assertTrue((String)sql, (sql.indexOf("INNER JOIN PAINTING t1 ON (t0.ARTIST_ID = t1.ARTIST_ID)") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)sql, (sql.indexOf("INNER JOIN PAINTING t2 ON (t0.ARTIST_ID = t2.ARTIST_ID)") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSelectImplicitColumnJoins() throws Exception {
        SQLTemplate query = this.translateSelect("SELECT a.paintingArray.toGallery.galleryName FROM Artist a JOIN a.paintingArray b");
        String sql = query.getDefaultTemplate();
        Assert.assertTrue((String)sql, (boolean)sql.startsWith("SELECT"));
        Assert.assertTrue((String)sql, (boolean)sql.contains("INNER JOIN GALLERY"));
        Assert.assertTrue((String)sql, (boolean)sql.contains("INNER JOIN PAINTING"));
        int i1 = sql.indexOf("INNER JOIN PAINTING");
        Assert.assertTrue((String)sql, (i1 >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSelectDistinct() {
        SQLTemplate query = this.translateSelect("select distinct a from Artist a");
        String sql = query.getDefaultTemplate();
        Assert.assertTrue((String)sql, (boolean)sql.startsWith("SELECT DISTINCT "));
    }

    @Test
    public void testSelectFromWhereEqual() {
        SQLTemplate query = this.translateSelect("select a from Artist a where a.artistName = 'Dali'");
        String sql = query.getDefaultTemplate();
        Assert.assertTrue((String)sql, (boolean)sql.startsWith("SELECT"));
        Assert.assertTrue((String)sql, (boolean)sql.endsWith(" FROM ARTIST t0 WHERE t0.ARTIST_NAME = #bind('Dali' 'VARCHAR')"));
    }

    @Test
    public void testSelectFromWhereOrEqual() {
        SQLTemplate query = this.translateSelect("select a from Artist a where a.artistName = 'Dali' or a.artistName = 'Malevich'");
        String sql = query.getDefaultTemplate();
        SQLTemplate query1 = this.translateSelect("select a from Artist a where a.artistName = 'Picasso' or a.artistName = 'Malevich' or a.artistName = 'Dali'");
        String sql1 = query1.getDefaultTemplate();
        Assert.assertTrue((String)sql, (boolean)sql.startsWith("SELECT"));
        Assert.assertTrue((String)sql, (sql.indexOf(" FROM ARTIST t0 WHERE ") > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)this.countDelimiters(sql, " OR ", sql.indexOf("WHERE ")));
        Assert.assertTrue((String)sql1, (boolean)sql1.startsWith("SELECT"));
        Assert.assertTrue((String)sql1, (sql.indexOf(" FROM ARTIST t0 WHERE ") > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)this.countDelimiters(sql1, " OR ", sql.indexOf("WHERE ")));
    }

    @Test
    public void testSelectFromWhereAndEqual() {
        SQLTemplate query = this.translateSelect("select a from Artist a where a.artistName = 'Dali' and a.artistName = 'Malevich'");
        String sql = query.getDefaultTemplate();
        SQLTemplate query1 = this.translateSelect("select a from Artist a where a.artistName = 'Picasso' and a.artistName = 'Malevich' and a.artistName = 'Dali'");
        String sql1 = query1.getDefaultTemplate();
        Assert.assertTrue((String)sql, (boolean)sql.startsWith("SELECT"));
        Assert.assertTrue((String)sql, (sql.indexOf("WHERE ") > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)this.countDelimiters(sql, " AND ", sql.indexOf("WHERE ")));
        Assert.assertTrue((String)sql1, (boolean)sql1.startsWith("SELECT"));
        Assert.assertTrue((String)sql1, (sql1.indexOf("WHERE ") > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)this.countDelimiters(sql1, " AND ", sql1.indexOf("WHERE ")));
    }

    @Test
    public void testSelectFromWhereNot() {
        SQLTemplate query = this.translateSelect("select a from Artist a where not (a.artistName = 'Dali')");
        String sql = query.getDefaultTemplate();
        Assert.assertTrue((String)sql, (boolean)sql.startsWith("SELECT"));
        Assert.assertTrue((String)sql, (boolean)sql.endsWith("WHERE NOT t0.ARTIST_NAME = #bind('Dali' 'VARCHAR')"));
    }

    @Test
    public void testSelectFromWhereGreater() {
        SQLTemplate query = this.translateSelect("select p from Painting p where p.estimatedPrice > 1.0");
        String sql = query.getDefaultTemplate();
        Assert.assertTrue((String)sql, (boolean)sql.startsWith("SELECT"));
        Assert.assertTrue((String)sql, (boolean)sql.endsWith("WHERE t0.ESTIMATED_PRICE > #bind($id0 'DECIMAL')"));
    }

    @Test
    public void testSelectFromWhereGreaterOrEqual() {
        SQLTemplate query = this.translateSelect("select p from Painting p where p.estimatedPrice >= 2");
        String sql = query.getDefaultTemplate();
        Assert.assertTrue((String)sql, (boolean)sql.endsWith("WHERE t0.ESTIMATED_PRICE >= #bind($id0 'INTEGER')"));
    }

    @Test
    public void testSelectFromWhereLess() {
        SQLTemplate query = this.translateSelect("select p from Painting p where p.estimatedPrice < 1.0");
        String sql = query.getDefaultTemplate();
        Assert.assertTrue((String)sql, (boolean)sql.endsWith("WHERE t0.ESTIMATED_PRICE < #bind($id0 'DECIMAL')"));
    }

    @Test
    public void testSelectFromWhereLessOrEqual() {
        SQLTemplate query = this.translateSelect("select p from Painting p where p.estimatedPrice <= 1.0");
        String sql = query.getDefaultTemplate();
        Assert.assertTrue((String)sql, (boolean)sql.endsWith("WHERE t0.ESTIMATED_PRICE <= #bind($id0 'DECIMAL')"));
    }

    @Test
    public void testSelectFromWhereNotEqual() {
        SQLTemplate query = this.translateSelect("select a from Artist a where a.artistName <> 'Dali'");
        String sql = query.getDefaultTemplate();
        Assert.assertTrue((String)sql, (boolean)sql.endsWith("WHERE t0.ARTIST_NAME <> #bind('Dali' 'VARCHAR')"));
    }

    @Test
    public void testSelectFromWhereBetween() {
        SQLTemplate query = this.translateSelect("select p from Painting p where p.estimatedPrice between 3 and 5");
        String sql = query.getDefaultTemplate();
        Assert.assertTrue((String)sql, (boolean)sql.endsWith("WHERE t0.ESTIMATED_PRICE BETWEEN #bind($id0 'INTEGER') AND #bind($id1 'INTEGER')"));
    }

    @Test
    public void testSelectFromWhereNotBetween() {
        SQLTemplate query = this.translateSelect("select p from Painting p where p.estimatedPrice not between 3 and 5");
        String sql = query.getDefaultTemplate();
        Assert.assertTrue((String)sql, (boolean)sql.endsWith("WHERE t0.ESTIMATED_PRICE NOT BETWEEN #bind($id0 'INTEGER') AND #bind($id1 'INTEGER')"));
    }

    @Test
    public void testSelectFromWhereLike() {
        SQLTemplate query = this.translateSelect("select p from Painting p where p.paintingTitle like 'Stuff'");
        String sql = query.getDefaultTemplate();
        Assert.assertTrue((String)sql, (boolean)sql.endsWith("WHERE t0.PAINTING_TITLE LIKE #bind('Stuff' 'VARCHAR')"));
    }

    @Test
    public void testSelectFromWhereNotLike() {
        SQLTemplate query = this.translateSelect("select p from Painting p where p.paintingTitle NOT like 'Stuff'");
        String sql = query.getDefaultTemplate();
        Assert.assertTrue((String)sql, (boolean)sql.endsWith("WHERE t0.PAINTING_TITLE NOT LIKE #bind('Stuff' 'VARCHAR')"));
    }

    @Test
    public void testSelectPositionalParameters() {
        HashMap<Integer, Object> params = new HashMap<Integer, Object>();
        params.put(new Integer(1), "X");
        params.put(new Integer(2), "Y");
        SQLTemplate query = this.translateSelect("select a from Artist a where a.artistName = ?1 or a.artistName = ?2", params);
        String sql = query.getDefaultTemplate();
        Assert.assertTrue((String)sql, (boolean)sql.endsWith("t0.ARTIST_NAME = #bind($id0) OR t0.ARTIST_NAME = #bind($id1)"));
    }

    @Test
    public void testMax() {
        SQLTemplate query = this.translateSelect("select max(p.estimatedPrice) from Painting p");
        String sql = query.getDefaultTemplate();
        Assert.assertTrue((String)sql, (boolean)sql.startsWith("SELECT #result('MAX(t0.ESTIMATED_PRICE)' 'java.math.BigDecimal' 'sc0') FROM PAINTING t0"));
    }

    @Test
    public void testDistinctSum() {
        SQLTemplate query = this.translateSelect("select sum( distinct p.estimatedPrice) from Painting p");
        String sql = query.getDefaultTemplate();
        Assert.assertTrue((String)sql, (boolean)sql.startsWith("SELECT #result('SUM(DISTINCT t0.ESTIMATED_PRICE)' 'java.math.BigDecimal' 'sc0') FROM PAINTING t0"));
    }

    @Test
    public void testColumnPaths() {
        SQLTemplate query = this.translateSelect("select p.estimatedPrice, p.toArtist.artistName from Painting p");
        String sql = query.getDefaultTemplate();
        Assert.assertTrue((String)sql, (boolean)sql.startsWith("SELECT #result('t0.ESTIMATED_PRICE' 'java.math.BigDecimal' 'sc0' 'sc0' 3), #result('t1.ARTIST_NAME' 'java.lang.String' 'sc1' 'sc1' 1) FROM"));
    }

    private int countDelimiters(String string, String delim, int fromIndex) {
        int i = 0;
        while ((fromIndex = string.indexOf(delim, fromIndex)) >= 0) {
            fromIndex += delim.length();
            ++i;
        }
        return i;
    }

    @Test
    public void testEqualsNullParameter() {
        String ejbql = "select p from Painting p WHERE p.toArtist=:x";
        EJBQLParser parser = EJBQLParserFactory.getParser();
        EJBQLCompiledExpression select = parser.compile(ejbql, this.runtime.getDataDomain().getEntityResolver());
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter("x", null);
        EJBQLTranslationContext tr = new EJBQLTranslationContext(this.runtime.getDataDomain().getEntityResolver(), query, select, new JdbcEJBQLTranslatorFactory(), this.adapter.getQuotingStrategy());
        select.getExpression().visit(new EJBQLSelectTranslator(tr));
        String sql = tr.getQuery().getDefaultTemplate();
        Assert.assertTrue((String)sql, (boolean)sql.endsWith("t0.ARTIST_ID IS NULL"));
    }

    @Test
    public void testEqualsNullAndNotNullParameter() {
        String ejbql = "select p from Painting p WHERE p.toArtist=:x OR p.toArtist.artistName=:b";
        EJBQLParser parser = EJBQLParserFactory.getParser();
        EJBQLCompiledExpression select = parser.compile(ejbql, this.runtime.getDataDomain().getEntityResolver());
        EJBQLQuery query = new EJBQLQuery(ejbql);
        query.setParameter("x", null);
        query.setParameter("b", (Object)"Y");
        EJBQLTranslationContext tr = new EJBQLTranslationContext(this.runtime.getDataDomain().getEntityResolver(), query, select, new JdbcEJBQLTranslatorFactory(), this.adapter.getQuotingStrategy());
        select.getExpression().visit(new EJBQLSelectTranslator(tr));
        String sql = tr.getQuery().getDefaultTemplate();
        Assert.assertTrue((String)sql, (boolean)sql.endsWith("t0.ARTIST_ID IS NULL OR t1.ARTIST_NAME = #bind($id0)"));
    }
}

