/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.loader.filters;

import java.util.TreeSet;
import org.apache.cayenne.access.loader.filters.DbPath;
import org.apache.cayenne.access.loader.filters.FiltersFactory;
import org.junit.Assert;
import org.junit.Test;

public class DbPathTest {
    @Test
    public void testIsCover() throws Exception {
        Assert.assertTrue((boolean)FiltersFactory.path(null, null).isCover(FiltersFactory.path("Hello", "World")));
        Assert.assertTrue((boolean)FiltersFactory.path(null, null).isCover(FiltersFactory.path("Hello", null)));
        Assert.assertTrue((boolean)FiltersFactory.path(null, null).isCover(FiltersFactory.path(null, null)));
        Assert.assertTrue((boolean)FiltersFactory.path(null, "Yo").isCover(FiltersFactory.path("Yo!", "Yo")));
        Assert.assertTrue((boolean)FiltersFactory.path(null, "Yo").isCover(FiltersFactory.path(null, "Yo")));
        Assert.assertFalse((boolean)FiltersFactory.path(null, "Yo!").isCover(FiltersFactory.path(null, "Yo!!")));
        Assert.assertFalse((boolean)FiltersFactory.path("aa", "Yo!").isCover(FiltersFactory.path(null, "Yo!!")));
        Assert.assertFalse((boolean)FiltersFactory.path("aaa", "Yo!").isCover(FiltersFactory.path("aa", "Yo!!")));
        Assert.assertTrue((boolean)FiltersFactory.path("aa", null).isCover(FiltersFactory.path("aa", null)));
        Assert.assertTrue((boolean)FiltersFactory.path("aa", null).isCover(FiltersFactory.path("aa", "bb")));
        Assert.assertTrue((boolean)FiltersFactory.path("aa", "Yo!").isCover(FiltersFactory.path("aa", "Yo!")));
        Assert.assertFalse((boolean)FiltersFactory.path("aa", "Yo!").isCover(FiltersFactory.path("aa", "Yo!!")));
        Assert.assertFalse((boolean)FiltersFactory.path("", "APP").isCover(FiltersFactory.path(null, null)));
        Assert.assertTrue((boolean)FiltersFactory.path(null, "schema_01").isCover(FiltersFactory.path("", "schema_01")));
        Assert.assertTrue((boolean)FiltersFactory.path(null, "schema_01").isCover(FiltersFactory.path(null, "schema_01")));
        Assert.assertFalse((boolean)FiltersFactory.path(null, "schema_01").isCover(FiltersFactory.path("", "schema_02")));
        Assert.assertFalse((boolean)FiltersFactory.path(null, "schema_02").isCover(FiltersFactory.path("", "schema_01")));
    }

    @Test
    public void testToString() throws Exception {
        Assert.assertEquals((Object)"%", (Object)FiltersFactory.path(null, null).toString());
        Assert.assertEquals((Object)"/schema", (Object)FiltersFactory.path("", "schema").toString());
        Assert.assertEquals((Object)"%/schema", (Object)FiltersFactory.path(null, "schema").toString());
        Assert.assertEquals((Object)"catalog/schema", (Object)FiltersFactory.path("catalog", "schema").toString());
        Assert.assertEquals((Object)"catalog//table", (Object)FiltersFactory.path("catalog", "", "table").toString());
        Assert.assertEquals((Object)"catalog/%/table", (Object)FiltersFactory.path("catalog", null, "table").toString());
        Assert.assertEquals((Object)"//table", (Object)FiltersFactory.path("", "", "table").toString());
        Assert.assertEquals((Object)"%/%/table", (Object)FiltersFactory.path(null, null, "table").toString());
        Assert.assertEquals((Object)"%", (Object)FiltersFactory.path(null, null, null).toString());
        Assert.assertEquals((Object)"c/%/", (Object)FiltersFactory.path("c", null, "").toString());
    }

    @Test
    public void testMerge() throws Exception {
        DbPath path1 = FiltersFactory.path(null, null);
        DbPath path2 = FiltersFactory.path("", "APP");
        Assert.assertEquals((Object)path1, (Object)path1.merge(path2));
        Assert.assertEquals((Object)path1, (Object)path2.merge(path1));
    }

    @Test
    public void testEquals() throws Exception {
        TreeSet<DbPath> pathes = new TreeSet<DbPath>();
        pathes.add(FiltersFactory.path("q", "w"));
        pathes.add(FiltersFactory.path("q", null));
        pathes.add(FiltersFactory.path("q", ""));
        pathes.add(FiltersFactory.path("", ""));
        pathes.add(FiltersFactory.path("q", "w"));
        pathes.add(FiltersFactory.path("q", "w"));
        pathes.add(FiltersFactory.path("q", "w"));
        pathes.add(FiltersFactory.path("q", "w"));
        Assert.assertEquals((long)4L, (long)pathes.size());
    }
}

