/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.jdbc.BaseSQLAction;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.RowDescriptorBuilder;
import org.apache.cayenne.access.translator.procedure.ProcedureTranslator;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.Query;

public class ProcedureAction
extends BaseSQLAction {
    protected ProcedureQuery query;
    protected int processedResultSets;

    public ProcedureAction(ProcedureQuery query, DataNode dataNode) {
        super(dataNode);
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performAction(Connection connection, OperationObserver observer) throws SQLException, Exception {
        this.processedResultSets = 0;
        ProcedureTranslator transl = this.createTranslator(connection);
        CallableStatement statement = (CallableStatement)transl.createStatement();
        try {
            this.initStatement(statement);
            statement.execute();
            this.readProcedureOutParameters(statement, observer);
            while (true) {
                if (statement.getMoreResults()) {
                    ResultSet rs = statement.getResultSet();
                    try {
                        RowDescriptor descriptor = this.describeResultSet(rs, this.processedResultSets++);
                        this.readResultSet(rs, descriptor, this.query, observer);
                    }
                    finally {
                        try {
                            rs.close();
                        }
                        catch (SQLException ex) {}
                    }
                    continue;
                }
                int updateCount = statement.getUpdateCount();
                if (updateCount == -1) {
                    break;
                }
                this.dataNode.getJdbcEventLogger().logUpdateCount(updateCount);
                observer.nextCount(this.query, updateCount);
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException ex) {}
        }
    }

    protected ProcedureTranslator createTranslator(Connection connection) {
        ProcedureTranslator translator = new ProcedureTranslator();
        translator.setAdapter(this.dataNode.getAdapter());
        translator.setQuery(this.query);
        translator.setEntityResolver(this.dataNode.getEntityResolver());
        translator.setConnection(connection);
        translator.setJdbcEventLogger(this.dataNode.getJdbcEventLogger());
        return translator;
    }

    protected RowDescriptor describeResultSet(ResultSet resultSet, int setIndex) throws SQLException {
        if (setIndex < 0) {
            throw new IllegalArgumentException("Expected a non-negative result set index. Got: " + setIndex);
        }
        RowDescriptorBuilder builder = new RowDescriptorBuilder();
        List<ColumnDescriptor[]> descriptors = this.query.getResultDescriptors();
        if (descriptors.isEmpty()) {
            builder.setResultSet(resultSet);
        } else {
            if (setIndex >= descriptors.size() || descriptors.get(setIndex) == null) {
                throw new CayenneRuntimeException("No descriptor for result set at index '" + setIndex + "' configured.", new Object[0]);
            }
            ColumnDescriptor[] columns = descriptors.get(setIndex);
            builder.setColumns(columns);
        }
        switch (this.query.getColumnNamesCapitalization()) {
            case LOWER: {
                builder.useLowercaseColumnNames();
                break;
            }
            case UPPER: {
                builder.useUppercaseColumnNames();
            }
        }
        return builder.getDescriptor(this.dataNode.getAdapter().getExtendedTypes());
    }

    protected Procedure getProcedure() {
        return this.query.getMetaData(this.dataNode.getEntityResolver()).getProcedure();
    }

    protected void readProcedureOutParameters(CallableStatement statement, OperationObserver delegate) throws SQLException, Exception {
        long t1 = System.currentTimeMillis();
        HashMap result = null;
        List<ProcedureParameter> parameters = this.getProcedure().getCallParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            ProcedureParameter parameter = parameters.get(i);
            if (!parameter.isOutParam()) continue;
            if (result == null) {
                result = new DataRow(2);
            }
            ColumnDescriptor descriptor = new ColumnDescriptor(parameter);
            ExtendedType type = this.dataNode.getAdapter().getExtendedTypes().getRegisteredType(descriptor.getJavaClass());
            Object val = type.materializeObject(statement, i + 1, descriptor.getJdbcType());
            result.put(descriptor.getDataRowKey(), val);
        }
        if (result != null && !result.isEmpty()) {
            this.dataNode.getJdbcEventLogger().logSelectCount(1, System.currentTimeMillis() - t1);
            delegate.nextRows((Query)this.query, Collections.singletonList(result));
        }
    }

    protected void initStatement(CallableStatement statement) throws Exception {
        int statementFetchSize = this.query.getMetaData(this.dataNode.getEntityResolver()).getStatementFetchSize();
        if (statementFetchSize != 0) {
            statement.setFetchSize(statementFetchSize);
        }
    }
}

