/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collection;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.UnitTestDomainQueryAction;
import org.apache.cayenne.query.Query;

public class UnitTestDomain
extends DataDomain {
    protected boolean blockingQueries;
    protected int queryCount;

    public UnitTestDomain(String name) {
        super(name);
    }

    public UnitTestDomain(String name, Map properties) {
        super(name, properties);
    }

    public void restartQueryCounter() {
        this.queryCount = 0;
    }

    public int getQueryCount() {
        return this.queryCount;
    }

    public boolean isBlockingQueries() {
        return this.blockingQueries;
    }

    public void setBlockingQueries(boolean blockingQueries) {
        this.blockingQueries = blockingQueries;
    }

    @Override
    QueryResponse onQueryNoFilters(ObjectContext originatingContext, Query query) {
        return new UnitTestDomainQueryAction(originatingContext, this, query).execute();
    }

    @Override
    public void performQueries(Collection<? extends Query> queries, OperationObserver callback) {
        this.checkQueryAllowed(queries);
        super.performQueries(queries, callback);
    }

    public void checkQueryAllowed(Collection<? extends Query> queries) throws AssertionFailedError {
        if (this.blockingQueries) {
            Assert.fail((String)("Query is unexpected: " + queries));
        }
        ++this.queryCount;
    }
}

