/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.access.IncrementalFaultList;
import org.apache.cayenne.access.SimpleIdIncrementalFaultList;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.UnitTestClosure;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class SimpleIdIncrementalFaultListPrefetchIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    @Inject
    protected DataChannelInterceptor queryInterceptor;
    protected TableHelper tArtist;
    protected TableHelper tPaining;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPaining = new TableHelper(this.dbHelper, "PAINTING");
        this.tPaining.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "ESTIMATED_PRICE"});
    }

    protected void createArtistsDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist11"});
        this.tArtist.insert(new Object[]{33002, "artist12"});
        this.tArtist.insert(new Object[]{33003, "artist13"});
        this.tArtist.insert(new Object[]{33004, "artist14"});
        this.tArtist.insert(new Object[]{33005, "artist15"});
        this.tArtist.insert(new Object[]{33006, "artist16"});
        this.tArtist.insert(new Object[]{33007, "artist21"});
    }

    protected void createArtistsAndPaintingsDataSet() throws Exception {
        this.createArtistsDataSet();
        this.tPaining.insert(new Object[]{33001, "P_artist11", 33001, 1000});
        this.tPaining.insert(new Object[]{33002, "P_artist12", 33002, 2000});
        this.tPaining.insert(new Object[]{33003, "P_artist13", 33003, 3000});
        this.tPaining.insert(new Object[]{33004, "P_artist14", 33004, 4000});
        this.tPaining.insert(new Object[]{33005, "P_artist15", 33005, 5000});
        this.tPaining.insert(new Object[]{33006, "P_artist16", 33006, 11000});
        this.tPaining.insert(new Object[]{33007, "P_artist21", 33007, 21000});
    }

    @Test
    public void testListType() throws Exception {
        this.createArtistsDataSet();
        Expression e = ExpressionFactory.likeExp("artistName", "artist1%");
        SelectQuery q = new SelectQuery("Artist", e);
        q.setPageSize(4);
        List result = this.context.performQuery(q);
        Assert.assertTrue((boolean)(result instanceof SimpleIdIncrementalFaultList));
    }

    @Test
    public void testPrefetch1() throws Exception {
        this.createArtistsAndPaintingsDataSet();
        Expression e = ExpressionFactory.likeExp("artistName", "artist1%");
        SelectQuery q = new SelectQuery("Artist", e);
        q.addPrefetch("paintingArray");
        q.setPageSize(3);
        final IncrementalFaultList result = (IncrementalFaultList)this.context.performQuery(q);
        Assert.assertEquals((long)6L, (long)result.size());
        Assert.assertEquals((long)result.size(), (long)result.getUnfetchedObjects());
        int count = this.queryInterceptor.runWithQueryCounter(new UnitTestClosure(){

            @Override
            public void execute() {
                for (int i = 3; i < 6; ++i) {
                    result.get(i);
                }
            }
        });
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testPrefetch3() throws Exception {
        this.createArtistsAndPaintingsDataSet();
        Expression e = ExpressionFactory.likeExp("artistName", "artist1%");
        SelectQuery q = new SelectQuery("Artist", e);
        q.addPrefetch("paintingArray");
        q.setPageSize(3);
        IncrementalFaultList result = (IncrementalFaultList)this.context.performQuery(q);
        Assert.assertEquals((long)6L, (long)result.size());
        Assert.assertEquals((long)result.size(), (long)result.getUnfetchedObjects());
        for (int i = 3; i < 6; ++i) {
            Artist a = (Artist)result.get(i);
            List<Painting> paintings = a.getPaintingArray();
            Assert.assertFalse((boolean)((ValueHolder)((Object)paintings)).isFault());
            Assert.assertEquals((long)1L, (long)paintings.size());
        }
    }

    @Test
    public void testPrefetch4() throws Exception {
        this.createArtistsAndPaintingsDataSet();
        SelectQuery<Painting> q = new SelectQuery<Painting>(Painting.class);
        q.setPageSize(3);
        q.addPrefetch("toArtist");
        IncrementalFaultList result = (IncrementalFaultList)this.context.performQuery(q);
        final DataObject p1 = (DataObject)result.get(q.getPageSize());
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Object toOnePrefetch = p1.readNestedProperty("toArtist");
                Assert.assertNotNull((Object)toOnePrefetch);
                Assert.assertTrue((String)("Expected DataObject, got: " + toOnePrefetch.getClass().getName()), (boolean)(toOnePrefetch instanceof DataObject));
                DataObject a1 = (DataObject)toOnePrefetch;
                Assert.assertEquals((long)3L, (long)a1.getPersistenceState());
            }
        });
    }
}

