/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.SimpleIdIncrementalFaultList;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.auto._Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class SimpleIdIncrementalFaultListIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;
    private TableHelper tArtist;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
    }

    protected void createArtistsDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
        this.tArtist.insert(new Object[]{33002, "artist2"});
        this.tArtist.insert(new Object[]{33003, "artist3"});
        this.tArtist.insert(new Object[]{33004, "artist4"});
        this.tArtist.insert(new Object[]{33005, "artist5"});
        this.tArtist.insert(new Object[]{33006, "artist6"});
        this.tArtist.insert(new Object[]{33007, "artist7"});
        this.tArtist.insert(new Object[]{33008, "artist8"});
        this.tArtist.insert(new Object[]{33009, "artist9"});
        this.tArtist.insert(new Object[]{33010, "artist10"});
        this.tArtist.insert(new Object[]{33011, "artist11"});
        this.tArtist.insert(new Object[]{33012, "artist12"});
        this.tArtist.insert(new Object[]{33013, "artist13"});
        this.tArtist.insert(new Object[]{33014, "artist14"});
        this.tArtist.insert(new Object[]{33015, "artist15"});
        this.tArtist.insert(new Object[]{33016, "artist16"});
        this.tArtist.insert(new Object[]{33017, "artist17"});
        this.tArtist.insert(new Object[]{33018, "artist18"});
        this.tArtist.insert(new Object[]{33019, "artist19"});
        this.tArtist.insert(new Object[]{33020, "artist20"});
        this.tArtist.insert(new Object[]{33021, "artist21"});
        this.tArtist.insert(new Object[]{33022, "artist22"});
        this.tArtist.insert(new Object[]{33023, "artist23"});
        this.tArtist.insert(new Object[]{33024, "artist24"});
        this.tArtist.insert(new Object[]{33025, "artist25"});
    }

    @Test
    public void testRemoveDeleted() throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.setPageSize(10);
        SimpleIdIncrementalFaultList list = new SimpleIdIncrementalFaultList(this.context, query, 10000);
        Assert.assertEquals((long)25L, (long)list.size());
        Artist a1 = (Artist)list.get(0);
        this.context.deleteObjects(a1);
        this.context.commitChanges();
        list.remove(0);
        Assert.assertEquals((long)24L, (long)list.size());
    }

    private SimpleIdIncrementalFaultList<?> prepareList(int pageSize) throws Exception {
        this.createArtistsDataSet();
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.setPageSize(pageSize);
        query.addOrdering("db:ARTIST_ID", SortOrder.ASCENDING);
        return new SimpleIdIncrementalFaultList(this.context, query, 10000);
    }

    @Test
    public void testSize() throws Exception {
        SimpleIdIncrementalFaultList<?> list = this.prepareList(6);
        Assert.assertEquals((long)25L, (long)list.size());
    }

    @Test
    public void testSmallList() throws Exception {
        SimpleIdIncrementalFaultList<?> list = this.prepareList(49);
        Assert.assertEquals((long)25L, (long)list.size());
    }

    @Test
    public void testOnePageList() throws Exception {
        SimpleIdIncrementalFaultList<?> list = this.prepareList(25);
        Assert.assertEquals((long)25L, (long)list.size());
    }

    @Test
    public void testIterator() throws Exception {
        SimpleIdIncrementalFaultList<?> list = this.prepareList(6);
        Iterator it = list.iterator();
        int counter = 0;
        while (it.hasNext()) {
            Object obj = it.next();
            Assert.assertNotNull(obj);
            Assert.assertTrue((boolean)(obj instanceof DataObject));
            int expectedResolved = list.pageIndex(counter) * list.getPageSize() + list.getPageSize();
            if (expectedResolved > list.size()) {
                expectedResolved = list.size();
            }
            Assert.assertEquals((long)(list.size() - expectedResolved), (long)list.getUnfetchedObjects());
            ++counter;
        }
    }

    @Test
    public void testNewObject() throws Exception {
        this.createArtistsDataSet();
        Artist newArtist = this.context.newObject(Artist.class);
        newArtist.setArtistName("x");
        this.context.commitChanges();
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class);
        q.setPageSize(6);
        q.addOrdering(Artist.ARTIST_NAME.asc());
        SimpleIdIncrementalFaultList list = new SimpleIdIncrementalFaultList(this.context, q, 10000);
        Assert.assertSame((Object)newArtist, list.get(25));
    }

    @Test
    public void testListIterator() throws Exception {
        SimpleIdIncrementalFaultList<?> list = this.prepareList(6);
        ListIterator it = list.listIterator();
        int counter = 0;
        while (it.hasNext()) {
            Object obj = it.next();
            Assert.assertNotNull(obj);
            Assert.assertTrue((boolean)(obj instanceof DataObject));
            int expectedResolved = list.pageIndex(counter) * list.getPageSize() + list.getPageSize();
            if (expectedResolved > list.size()) {
                expectedResolved = list.size();
            }
            Assert.assertEquals((long)(list.size() - expectedResolved), (long)list.getUnfetchedObjects());
            ++counter;
        }
    }

    @Test
    public void testSort() throws Exception {
        SimpleIdIncrementalFaultList<?> list = this.prepareList(6);
        new Ordering("artistName", SortOrder.DESCENDING).orderList(list);
        Iterator it = list.iterator();
        _Artist previousArtist = null;
        while (it.hasNext()) {
            Artist artist = (Artist)it.next();
            if (previousArtist == null) continue;
            Assert.assertTrue((previousArtist.getArtistName().compareTo(artist.getArtistName()) > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testUnfetchedObjects() throws Exception {
        SimpleIdIncrementalFaultList<?> list = this.prepareList(6);
        Assert.assertEquals((long)25L, (long)list.getUnfetchedObjects());
        list.get(7);
        Assert.assertEquals((long)19L, (long)list.getUnfetchedObjects());
        list.resolveAll();
        Assert.assertEquals((long)0L, (long)list.getUnfetchedObjects());
    }

    @Test
    public void testPageIndex() throws Exception {
        SimpleIdIncrementalFaultList<?> list = this.prepareList(6);
        Assert.assertEquals((long)0L, (long)list.pageIndex(0));
        Assert.assertEquals((long)0L, (long)list.pageIndex(1));
        Assert.assertEquals((long)1L, (long)list.pageIndex(6));
        try {
            Assert.assertEquals((long)13L, (long)list.pageIndex(82));
            Assert.fail((String)"Element index beyound array size must throw an IndexOutOfBoundsException.");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testPagesRead1() throws Exception {
        SimpleIdIncrementalFaultList<?> list = this.prepareList(6);
        Assert.assertTrue((boolean)(list.elements.get(0) instanceof Long));
        Assert.assertTrue((boolean)(list.elements.get(8) instanceof Long));
        list.resolveInterval(5, 10);
        Assert.assertTrue((boolean)(list.elements.get(7) instanceof Artist));
        list.resolveAll();
        Assert.assertTrue((boolean)(list.elements.get(list.size() - 1) instanceof Artist));
    }

    @Test
    public void testGet1() throws Exception {
        SimpleIdIncrementalFaultList<?> list = this.prepareList(6);
        Assert.assertTrue((boolean)(list.elements.get(0) instanceof Long));
        Assert.assertTrue((boolean)(list.elements.get(8) instanceof Long));
        Object a = list.get(8);
        Assert.assertNotNull(a);
        Assert.assertTrue((boolean)(a instanceof Artist));
        Assert.assertTrue((boolean)(list.elements.get(8) instanceof Artist));
    }

    @Test
    public void testIndexOf() throws Exception {
        SimpleIdIncrementalFaultList<?> list = this.prepareList(6);
        Expression qual = ExpressionFactory.matchExp("artistName", "artist20");
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class, qual);
        List artists = list.dataContext.performQuery(query);
        Assert.assertEquals((long)1L, (long)artists.size());
        Artist row = (Artist)artists.get(0);
        Assert.assertEquals((long)19L, (long)list.indexOf(row));
        Assert.assertEquals((long)-1L, (long)list.indexOf(list.dataContext.newObject("Artist")));
    }

    @Test
    public void testLastIndexOf() throws Exception {
        SimpleIdIncrementalFaultList<?> list = this.prepareList(6);
        Expression qual = ExpressionFactory.matchExp("artistName", "artist20");
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class, qual);
        List artists = list.dataContext.performQuery(query);
        Assert.assertEquals((long)1L, (long)artists.size());
        Artist row = (Artist)artists.get(0);
        Assert.assertEquals((long)19L, (long)list.lastIndexOf(row));
        Assert.assertEquals((long)-1L, (long)list.lastIndexOf(list.dataContext.newObject("Artist")));
    }
}

