/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.OptimisticLockException;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.locking.RelLockingTestEntity;
import org.apache.cayenne.testdo.locking.SimpleLockingTestEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-locking.xml")
public class OptimisticLockingIT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tSimpleLockingTest;
    protected TableHelper tRelLockingTest;
    protected TableHelper tLockingHelper;

    @Before
    public void setUp() throws Exception {
        this.tSimpleLockingTest = new TableHelper(this.dbHelper, "SIMPLE_LOCKING_TEST");
        this.tSimpleLockingTest.setColumns(new String[]{"LOCKING_TEST_ID", "NAME", "DESCRIPTION"}).setColumnTypes(new int[]{4, 12, 12});
        this.tRelLockingTest = new TableHelper(this.dbHelper, "REL_LOCKING_TEST");
        this.tRelLockingTest.setColumns(new String[]{"REL_LOCKING_TEST_ID", "SIMPLE_LOCKING_TEST_ID", "NAME"});
        this.tLockingHelper = new TableHelper(this.dbHelper, "LOCKING_HELPER");
        this.tLockingHelper.setColumns(new String[]{"LOCKING_HELPER_ID", "REL_LOCKING_TEST_ID", "NAME"});
    }

    protected void createSimpleLockingDataSet() throws Exception {
        this.tLockingHelper.delete().execute();
        this.tRelLockingTest.delete().execute();
        this.tSimpleLockingTest.delete().execute();
        this.tSimpleLockingTest.insert(new Object[]{1, "LockTest1", null});
    }

    protected void createLockingOnNullDataSet() throws Exception {
        this.tLockingHelper.delete().execute();
        this.tRelLockingTest.delete().execute();
        this.tSimpleLockingTest.delete().execute();
        this.tSimpleLockingTest.insert(new Object[]{1, null, null});
    }

    protected void createLockingOnMixedDataSet() throws Exception {
        this.tLockingHelper.delete().execute();
        this.tRelLockingTest.delete().execute();
        this.tSimpleLockingTest.delete().execute();
        this.tSimpleLockingTest.insert(new Object[]{1, null, null});
        this.tSimpleLockingTest.insert(new Object[]{2, "LockTest2", null});
        this.tSimpleLockingTest.insert(new Object[]{3, "LockTest3", "Another Lock Test"});
    }

    protected void createLockingOnToOneDataSet() throws Exception {
        this.tLockingHelper.delete().execute();
        this.tRelLockingTest.delete().execute();
        this.tSimpleLockingTest.delete().execute();
        this.tSimpleLockingTest.insert(new Object[]{1, "LockTest1", null});
        this.tRelLockingTest.insert(new Object[]{5, 1, "Rel Test 1"});
        this.tLockingHelper.insert(new Object[]{1, 5, "Locking Helper 1"});
    }

    protected void createSimpleLockUpdate() throws Exception {
        Assert.assertEquals((long)1L, (long)this.tSimpleLockingTest.update().set("NAME", (Object)"LockTest1Updated").where("LOCKING_TEST_ID", (Object)1).execute());
    }

    protected void createRelLockUpdate() throws Exception {
        this.tRelLockingTest.update().set("SIMPLE_LOCKING_TEST_ID", (Object)1).where("REL_LOCKING_TEST_ID", (Object)5).execute();
    }

    protected void createSimpleLockDelete() throws Exception {
        this.tSimpleLockingTest.delete().execute();
    }

    @Test
    public void testSuccessSimpleLockingOnDelete() throws Exception {
        this.createSimpleLockingDataSet();
        List allObjects = this.context.performQuery(new SelectQuery<SimpleLockingTestEntity>(SimpleLockingTestEntity.class));
        Assert.assertEquals((long)1L, (long)allObjects.size());
        SimpleLockingTestEntity object = (SimpleLockingTestEntity)allObjects.get(0);
        object.setDescription("first update");
        this.context.commitChanges();
        this.context.deleteObjects(object);
        this.context.commitChanges();
    }

    @Test
    public void testSuccessSimpleLockingOnDeleteFollowedByInvalidate() throws Exception {
        this.createSimpleLockingDataSet();
        List allObjects = this.context.performQuery(new SelectQuery<SimpleLockingTestEntity>(SimpleLockingTestEntity.class));
        Assert.assertEquals((long)1L, (long)allObjects.size());
        SimpleLockingTestEntity object = (SimpleLockingTestEntity)allObjects.get(0);
        object.setDescription("first update");
        this.context.commitChanges();
        this.context.deleteObjects(object);
        this.context.invalidateObjects(object);
        this.context.commitChanges();
    }

    @Test
    public void testSuccessSimpleLockingOnDeleteFollowedByForgetSnapshot() throws Exception {
        this.createSimpleLockingDataSet();
        List allObjects = this.context.performQuery(new SelectQuery<SimpleLockingTestEntity>(SimpleLockingTestEntity.class));
        Assert.assertEquals((long)1L, (long)allObjects.size());
        SimpleLockingTestEntity object = (SimpleLockingTestEntity)allObjects.get(0);
        object.setDescription("first update");
        this.context.commitChanges();
        this.context.deleteObjects(object);
        this.context.getObjectStore().getDataRowCache().forgetSnapshot(object.getObjectId());
        this.context.commitChanges();
    }

    @Test
    public void testSuccessSimpleLockingOnDeletePrecededByInvalidate() throws Exception {
        this.createSimpleLockingDataSet();
        List allObjects = this.context.performQuery(new SelectQuery<SimpleLockingTestEntity>(SimpleLockingTestEntity.class));
        Assert.assertEquals((long)1L, (long)allObjects.size());
        SimpleLockingTestEntity object = (SimpleLockingTestEntity)allObjects.get(0);
        object.setDescription("first update");
        this.context.commitChanges();
        this.context.invalidateObjects(object);
        this.context.deleteObjects(object);
        this.context.commitChanges();
    }

    @Test
    public void testSuccessSimpleLockingOnDeletePrecededByForgetSnapshot() throws Exception {
        this.createSimpleLockingDataSet();
        List allObjects = this.context.performQuery(new SelectQuery<SimpleLockingTestEntity>(SimpleLockingTestEntity.class));
        Assert.assertEquals((long)1L, (long)allObjects.size());
        SimpleLockingTestEntity object = (SimpleLockingTestEntity)allObjects.get(0);
        object.setDescription("first update");
        this.context.commitChanges();
        this.context.getObjectStore().getDataRowCache().forgetSnapshot(object.getObjectId());
        this.context.deleteObjects(object);
        this.context.commitChanges();
    }

    @Test
    public void testFailSimpleLockingOnDelete() throws Exception {
        this.createSimpleLockingDataSet();
        List allObjects = this.context.performQuery(new SelectQuery<SimpleLockingTestEntity>(SimpleLockingTestEntity.class));
        Assert.assertEquals((long)1L, (long)allObjects.size());
        SimpleLockingTestEntity object = (SimpleLockingTestEntity)allObjects.get(0);
        object.setDescription("second update");
        this.context.commitChanges();
        this.createSimpleLockUpdate();
        this.context.deleteObjects(object);
        try {
            this.context.commitChanges();
            Assert.fail((String)"Optimistic lock failure expected.");
        }
        catch (OptimisticLockException optimisticLockException) {
            // empty catch block
        }
    }

    @Test
    public void testSuccessSimpleLockingOnUpdate() throws Exception {
        this.createSimpleLockingDataSet();
        List allObjects = this.context.performQuery(new SelectQuery<SimpleLockingTestEntity>(SimpleLockingTestEntity.class));
        Assert.assertEquals((long)1L, (long)allObjects.size());
        SimpleLockingTestEntity object = (SimpleLockingTestEntity)allObjects.get(0);
        object.setDescription("first update");
        this.context.commitChanges();
        object.setDescription("second update");
        this.context.commitChanges();
    }

    @Test
    public void testSuccessSimpleLockingOnUpdateFollowedByInvalidate() throws Exception {
        this.createSimpleLockingDataSet();
        List allObjects = this.context.performQuery(new SelectQuery<SimpleLockingTestEntity>(SimpleLockingTestEntity.class));
        Assert.assertEquals((long)1L, (long)allObjects.size());
        SimpleLockingTestEntity object = (SimpleLockingTestEntity)allObjects.get(0);
        object.setDescription("first update");
        this.context.commitChanges();
        object.setDescription("second update");
        this.context.invalidateObjects(object);
        this.context.commitChanges();
    }

    @Test
    public void testSuccessSimpleLockingOnUpdatePrecededByInvalidate() throws Exception {
        this.createSimpleLockingDataSet();
        List allObjects = this.context.performQuery(new SelectQuery<SimpleLockingTestEntity>(SimpleLockingTestEntity.class));
        Assert.assertEquals((long)1L, (long)allObjects.size());
        SimpleLockingTestEntity object = (SimpleLockingTestEntity)allObjects.get(0);
        object.setDescription("first update");
        this.context.commitChanges();
        this.context.invalidateObjects(object);
        object.setDescription("second update");
        this.context.commitChanges();
    }

    @Test
    public void testSuccessSimpleLockingOnUpdateFollowedByForgetSnapshot() throws Exception {
        this.createSimpleLockingDataSet();
        List allObjects = this.context.performQuery(new SelectQuery<SimpleLockingTestEntity>(SimpleLockingTestEntity.class));
        Assert.assertEquals((long)1L, (long)allObjects.size());
        SimpleLockingTestEntity object = (SimpleLockingTestEntity)allObjects.get(0);
        object.setDescription("first update");
        this.context.commitChanges();
        object.setDescription("second update");
        this.context.getObjectStore().getDataRowCache().forgetSnapshot(object.getObjectId());
        this.context.commitChanges();
    }

    @Test
    public void testSuccessSimpleLockingOnUpdatePrecededByForgetSnapshot() throws Exception {
        this.createSimpleLockingDataSet();
        List allObjects = this.context.performQuery(new SelectQuery<SimpleLockingTestEntity>(SimpleLockingTestEntity.class));
        Assert.assertEquals((long)1L, (long)allObjects.size());
        SimpleLockingTestEntity object = (SimpleLockingTestEntity)allObjects.get(0);
        object.setDescription("first update");
        this.context.commitChanges();
        this.context.getObjectStore().getDataRowCache().forgetSnapshot(object.getObjectId());
        object.setDescription("second update");
        this.context.commitChanges();
    }

    @Test
    public void testFailSimpleLocking() throws Exception {
        this.createSimpleLockingDataSet();
        List allObjects = this.context.performQuery(new SelectQuery<SimpleLockingTestEntity>(SimpleLockingTestEntity.class));
        Assert.assertEquals((long)1L, (long)allObjects.size());
        SimpleLockingTestEntity object = (SimpleLockingTestEntity)allObjects.get(0);
        object.setDescription("first update");
        this.context.commitChanges();
        this.createSimpleLockUpdate();
        object.setDescription("second update");
        try {
            this.context.commitChanges();
            Assert.fail((String)"Optimistic lock failure expected.");
        }
        catch (OptimisticLockException optimisticLockException) {
            // empty catch block
        }
    }

    @Test
    public void testFailLockingOnNull() throws Exception {
        this.createLockingOnNullDataSet();
        List allObjects = this.context.performQuery(new SelectQuery<SimpleLockingTestEntity>(SimpleLockingTestEntity.class));
        Assert.assertEquals((long)1L, (long)allObjects.size());
        SimpleLockingTestEntity object = (SimpleLockingTestEntity)allObjects.get(0);
        object.setDescription("first update");
        this.context.commitChanges();
        this.createSimpleLockUpdate();
        object.setDescription("second update");
        try {
            this.context.commitChanges();
            Assert.fail((String)"Optimistic lock failure expected.");
        }
        catch (OptimisticLockException ex) {
            Assert.assertEquals((Object)object.getObjectId(), (Object)ex.getFailedObjectId());
        }
    }

    @Test
    public void testSuccessLockingOnMixed() throws Exception {
        this.createLockingOnMixedDataSet();
        SelectQuery<SimpleLockingTestEntity> query = new SelectQuery<SimpleLockingTestEntity>(SimpleLockingTestEntity.class);
        query.addOrdering(new Ordering("db:LOCKING_TEST_ID", SortOrder.ASCENDING));
        List allObjects = this.context.performQuery(query);
        Assert.assertEquals((long)3L, (long)allObjects.size());
        SimpleLockingTestEntity object1 = (SimpleLockingTestEntity)allObjects.get(0);
        SimpleLockingTestEntity object2 = (SimpleLockingTestEntity)allObjects.get(1);
        SimpleLockingTestEntity object3 = (SimpleLockingTestEntity)allObjects.get(2);
        object1.setDescription("first update for object1");
        object2.setDescription("first update for object2");
        object3.setName("object3 - new name");
        this.context.commitChanges();
    }

    @Test
    public void testFailLockingOnToOne() throws Exception {
        this.createLockingOnToOneDataSet();
        List allObjects = this.context.performQuery(new SelectQuery<RelLockingTestEntity>(RelLockingTestEntity.class));
        Assert.assertEquals((long)1L, (long)allObjects.size());
        RelLockingTestEntity object = (RelLockingTestEntity)allObjects.get(0);
        object.setName("first update");
        this.context.commitChanges();
        SimpleLockingTestEntity object1 = this.context.newObject(SimpleLockingTestEntity.class);
        object.setToSimpleLockingTest(object1);
        this.context.commitChanges();
        this.createRelLockUpdate();
        object.setName("third update");
        try {
            this.context.commitChanges();
            Assert.fail((String)"Optimistic lock failure expected.");
        }
        catch (OptimisticLockException ex) {
            // empty catch block
        }
    }

    @Test
    public void testFailRetrieveRow() throws Exception {
        this.createSimpleLockingDataSet();
        List allObjects = this.context.performQuery(new SelectQuery<SimpleLockingTestEntity>(SimpleLockingTestEntity.class));
        Assert.assertEquals((long)1L, (long)allObjects.size());
        SimpleLockingTestEntity object = (SimpleLockingTestEntity)allObjects.get(0);
        object.setDescription("first update");
        this.createSimpleLockUpdate();
        try {
            this.context.commitChanges();
            Assert.fail((String)"Optimistic lock failure expected.");
        }
        catch (OptimisticLockException ex) {
            Map<?, ?> freshFailedRow = ex.getFreshSnapshot(this.context);
            Assert.assertNotNull(freshFailedRow);
            Assert.assertEquals((Object)"LockTest1Updated", freshFailedRow.get("NAME"));
        }
    }

    @Test
    public void testFailRetrieveDeletedRow() throws Exception {
        this.createSimpleLockingDataSet();
        List allObjects = this.context.performQuery(new SelectQuery<SimpleLockingTestEntity>(SimpleLockingTestEntity.class));
        Assert.assertEquals((long)1L, (long)allObjects.size());
        SimpleLockingTestEntity object = (SimpleLockingTestEntity)allObjects.get(0);
        object.setDescription("first update");
        this.createSimpleLockDelete();
        try {
            this.context.commitChanges();
            Assert.fail((String)"Optimistic lock failure expected.");
        }
        catch (OptimisticLockException ex) {
            Map<?, ?> freshFailedRow = ex.getFreshSnapshot(this.context);
            Assert.assertNull((String)("" + freshFailedRow), freshFailedRow);
        }
    }
}

