/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.MockGraphChangeHandler;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.NullTestEntity;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextCommitIT
extends ServerCase {
    @Inject
    private DataContext context;

    @Test
    public void testFlushToParent_Commit() {
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("Test");
        Assert.assertTrue((boolean)this.context.hasChanges());
        GraphDiff diff = this.context.flushToParent(true);
        Assert.assertNotNull((Object)diff);
        Assert.assertFalse((boolean)this.context.hasChanges());
        final Object[] newIds = new Object[1];
        MockGraphChangeHandler diffChecker = new MockGraphChangeHandler(){

            @Override
            public void nodeIdChanged(Object nodeId, Object newId) {
                super.nodeIdChanged(nodeId, newId);
                newIds[0] = newId;
            }
        };
        diff.apply(diffChecker);
        Assert.assertEquals((long)1L, (long)diffChecker.getCallbackCount());
        Assert.assertSame((Object)a.getObjectId(), (Object)newIds[0]);
        Painting p = this.context.newObject(Painting.class);
        p.setPaintingTitle("PT");
        p.setToArtist(a);
        a.setArtistName(a.getArtistName() + "_");
        GraphDiff diff2 = this.context.flushToParent(true);
        Assert.assertNotNull((Object)diff2);
        Assert.assertFalse((boolean)this.context.hasChanges());
        final Object[] newIds2 = new Object[1];
        MockGraphChangeHandler diffChecker2 = new MockGraphChangeHandler(){

            @Override
            public void nodeIdChanged(Object nodeId, Object newId) {
                super.nodeIdChanged(nodeId, newId);
                newIds2[0] = newId;
            }
        };
        diff2.apply(diffChecker2);
        Assert.assertEquals((long)1L, (long)diffChecker2.getCallbackCount());
        Assert.assertSame((Object)p.getObjectId(), (Object)newIds2[0]);
        this.context.newObject(NullTestEntity.class);
        Assert.assertTrue((boolean)this.context.hasChanges());
        GraphDiff diff3 = this.context.flushToParent(true);
        Assert.assertNotNull((Object)diff3);
        Assert.assertFalse((boolean)this.context.hasChanges());
    }
}

