/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.MockPersistentObject;
import org.apache.cayenne.ObjectContextStateLog;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.graph.MockGraphManager;
import org.junit.Assert;
import org.junit.Test;

public class ContextStateRecorderTest {
    @Test
    public void testDirtyNodesInState() {
        MockGraphManager map = new MockGraphManager();
        ObjectContextStateLog recorder = new ObjectContextStateLog(map);
        Assert.assertNotNull(recorder.dirtyNodes(4));
        Assert.assertNotNull(recorder.dirtyNodes(3));
        Assert.assertNotNull(recorder.dirtyNodes(6));
        Assert.assertNotNull(recorder.dirtyNodes(2));
        Assert.assertNotNull(recorder.dirtyNodes(1));
        Assert.assertNotNull(recorder.dirtyNodes(5));
        Assert.assertTrue((boolean)recorder.dirtyNodes(4).isEmpty());
        Assert.assertTrue((boolean)recorder.dirtyNodes(3).isEmpty());
        Assert.assertTrue((boolean)recorder.dirtyNodes(6).isEmpty());
        Assert.assertTrue((boolean)recorder.dirtyNodes(2).isEmpty());
        Assert.assertTrue((boolean)recorder.dirtyNodes(1).isEmpty());
        Assert.assertTrue((boolean)recorder.dirtyNodes(5).isEmpty());
        MockPersistentObject modified = new MockPersistentObject();
        modified.setObjectId(new ObjectId("MockPersistentObject", "key", "value1"));
        modified.setPersistenceState(4);
        map.registerNode(modified.getObjectId(), modified);
        recorder.nodePropertyChanged(modified.getObjectId(), "a", "b", "c");
        Assert.assertTrue((boolean)recorder.dirtyNodes(4).contains(modified));
        Assert.assertTrue((boolean)recorder.dirtyNodes(3).isEmpty());
        Assert.assertTrue((boolean)recorder.dirtyNodes(6).isEmpty());
        Assert.assertTrue((boolean)recorder.dirtyNodes(2).isEmpty());
        Assert.assertTrue((boolean)recorder.dirtyNodes(1).isEmpty());
        Assert.assertTrue((boolean)recorder.dirtyNodes(5).isEmpty());
        MockPersistentObject deleted = new MockPersistentObject();
        deleted.setObjectId(new ObjectId("MockPersistentObject", "key", "value2"));
        deleted.setPersistenceState(6);
        map.registerNode(deleted.getObjectId(), deleted);
        recorder.nodeRemoved(deleted.getObjectId());
        Assert.assertTrue((boolean)recorder.dirtyNodes(4).contains(modified));
        Assert.assertTrue((boolean)recorder.dirtyNodes(3).isEmpty());
        Assert.assertTrue((boolean)recorder.dirtyNodes(6).contains(deleted));
        Assert.assertTrue((boolean)recorder.dirtyNodes(2).isEmpty());
        Assert.assertTrue((boolean)recorder.dirtyNodes(1).isEmpty());
        Assert.assertTrue((boolean)recorder.dirtyNodes(5).isEmpty());
    }

    @Test
    public void testDirtyNodes() {
        MockGraphManager map = new MockGraphManager();
        ObjectContextStateLog recorder = new ObjectContextStateLog(map);
        Assert.assertNotNull(recorder.dirtyNodes());
        Assert.assertTrue((boolean)recorder.dirtyNodes().isEmpty());
        MockPersistentObject object = new MockPersistentObject();
        object.setObjectId(new ObjectId("MockPersistentObject", "key", "value"));
        object.setPersistenceState(4);
        map.registerNode(object.getObjectId(), object);
        recorder.nodePropertyChanged(object.getObjectId(), "a", "b", "c");
        Assert.assertTrue((boolean)recorder.dirtyNodes().contains(object));
        recorder.clear();
        Assert.assertNotNull(recorder.dirtyNodes());
        Assert.assertTrue((boolean)recorder.dirtyNodes().isEmpty());
    }

    @Test
    public void testHasChanges() {
        ObjectContextStateLog recorder = new ObjectContextStateLog(new MockGraphManager());
        Assert.assertFalse((boolean)recorder.hasChanges());
        MockPersistentObject object = new MockPersistentObject();
        object.setObjectId(new ObjectId("MockPersistentObject", "key", "value"));
        object.setPersistenceState(4);
        recorder.nodePropertyChanged(object.getObjectId(), "xyz", "a", "b");
        Assert.assertTrue((boolean)recorder.hasChanges());
        recorder.clear();
        Assert.assertFalse((boolean)recorder.hasChanges());
    }
}

