/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.MockDataNode;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.ArtGroup;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.UnitTestClosure;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class CayenneDataObjectFlattenedRelIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    @Inject
    private ObjectContext context;
    @Inject
    private DBHelper dbHelper;
    @Inject
    private DataChannelInterceptor queryInterceptor;
    private TableHelper tArtist;
    private TableHelper tArtGroup;
    private TableHelper tArtistGroup;

    @Override
    public void cleanUpDB() throws Exception {
        this.dbHelper.update("ARTGROUP").set("PARENT_GROUP_ID", null, 4).execute();
        super.cleanUpDB();
    }

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tArtGroup = new TableHelper(this.dbHelper, "ARTGROUP");
        this.tArtGroup.setColumns(new String[]{"GROUP_ID", "NAME"});
        this.tArtistGroup = new TableHelper(this.dbHelper, "ARTIST_GROUP");
        this.tArtistGroup.setColumns(new String[]{"ARTIST_ID", "GROUP_ID"});
    }

    private void create1Artist1ArtGroupDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "artist1"});
        this.tArtGroup.insert(new Object[]{1, "g1"});
    }

    private void create1Artist2ArtGroupDataSet() throws Exception {
        this.create1Artist1ArtGroupDataSet();
        this.tArtGroup.insert(new Object[]{2, "g2"});
    }

    private void create1Artist1ArtGroup1ArtistGroupDataSet() throws Exception {
        this.create1Artist1ArtGroupDataSet();
        this.tArtistGroup.insert(new Object[]{33001, 1});
    }

    @Test
    public void testReadFlattenedRelationship() throws Exception {
        this.create1Artist1ArtGroupDataSet();
        Artist a1 = Cayenne.objectForPK(this.context, Artist.class, 33001);
        List<ArtGroup> groupList = a1.getGroupArray();
        Assert.assertNotNull(groupList);
        Assert.assertEquals((long)0L, (long)groupList.size());
    }

    @Test
    public void testReadFlattenedRelationship2() throws Exception {
        this.create1Artist1ArtGroup1ArtistGroupDataSet();
        Artist a1 = Cayenne.objectForPK(this.context, Artist.class, 33001);
        List<ArtGroup> groupList = a1.getGroupArray();
        Assert.assertNotNull(groupList);
        Assert.assertEquals((long)1L, (long)groupList.size());
        Assert.assertEquals((long)3L, (long)groupList.get(0).getPersistenceState());
        Assert.assertEquals((Object)"g1", (Object)groupList.get(0).getName());
    }

    @Test
    public void testAddToFlattenedRelationship() throws Exception {
        this.create1Artist1ArtGroupDataSet();
        Artist a1 = Cayenne.objectForPK(this.context, Artist.class, 33001);
        Assert.assertEquals((long)0L, (long)a1.getGroupArray().size());
        SelectQuery<ArtGroup> q = new SelectQuery<ArtGroup>(ArtGroup.class, ExpressionFactory.matchExp("name", "g1"));
        List results = this.context.performQuery(q);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertFalse((boolean)this.context.hasChanges());
        ArtGroup group = (ArtGroup)results.get(0);
        a1.addToGroupArray(group);
        Assert.assertTrue((boolean)this.context.hasChanges());
        List<ArtGroup> groupList = a1.getGroupArray();
        Assert.assertEquals((long)1L, (long)groupList.size());
        Assert.assertEquals((Object)"g1", (Object)groupList.get(0).getName());
        a1.getObjectContext().commitChanges();
        Assert.assertFalse((boolean)this.context.hasChanges());
        ObjectContext context2 = this.runtime.newContext();
        a1 = Cayenne.objectForPK(context2, Artist.class, 33001);
        groupList = a1.getGroupArray();
        Assert.assertEquals((long)1L, (long)groupList.size());
        Assert.assertEquals((Object)"g1", (Object)groupList.get(0).getName());
    }

    @Test
    public void testDoubleCommitAddToFlattenedRelationship() throws Exception {
        this.create1Artist1ArtGroupDataSet();
        Artist a1 = Cayenne.objectForPK(this.context, Artist.class, 33001);
        SelectQuery<ArtGroup> q = new SelectQuery<ArtGroup>(ArtGroup.class, ExpressionFactory.matchExp("name", "g1"));
        List results = this.context.performQuery(q);
        Assert.assertEquals((long)1L, (long)results.size());
        ArtGroup group = (ArtGroup)results.get(0);
        a1.addToGroupArray(group);
        List<ArtGroup> groupList = a1.getGroupArray();
        Assert.assertEquals((long)1L, (long)groupList.size());
        Assert.assertEquals((Object)"g1", (Object)groupList.get(0).getName());
        a1.getObjectContext().commitChanges();
        try {
            a1.getObjectContext().commitChanges();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Should not have thrown an exception");
        }
    }

    @Test
    public void testRemoveFromFlattenedRelationship() throws Exception {
        this.create1Artist1ArtGroup1ArtistGroupDataSet();
        Artist a1 = Cayenne.objectForPK(this.context, Artist.class, 33001);
        ArtGroup group = a1.getGroupArray().get(0);
        a1.removeFromGroupArray(group);
        List<ArtGroup> groupList = a1.getGroupArray();
        Assert.assertEquals((long)0L, (long)groupList.size());
        a1.getObjectContext().commitChanges();
        groupList = a1.getGroupArray();
        Assert.assertEquals((long)0L, (long)groupList.size());
    }

    @Test
    public void testRemoveFlattenedRelationshipAndRootRecord() throws Exception {
        this.create1Artist1ArtGroup1ArtistGroupDataSet();
        Artist a1 = Cayenne.objectForPK(this.context, Artist.class, 33001);
        ArtGroup group = a1.getGroupArray().get(0);
        a1.removeFromGroupArray(group);
        this.context.deleteObjects(a1);
        try {
            this.context.commitChanges();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Should not have thrown the exception :" + e.getMessage()));
        }
    }

    @Test
    public void testAddRemoveFlattenedRelationship1() throws Exception {
        this.create1Artist1ArtGroupDataSet();
        Artist a1 = Cayenne.objectForPK(this.context, Artist.class, 33001);
        SelectQuery<ArtGroup> q = new SelectQuery<ArtGroup>(ArtGroup.class, ExpressionFactory.matchExp("name", "g1"));
        List results = this.context.performQuery(q);
        Assert.assertEquals((long)1L, (long)results.size());
        ArtGroup group = (ArtGroup)results.get(0);
        a1.addToGroupArray(group);
        group.removeFromArtistArray(a1);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                CayenneDataObjectFlattenedRelIT.this.context.commitChanges();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddRemoveFlattenedRelationship2() throws Exception {
        this.create1Artist2ArtGroupDataSet();
        Artist a1 = Cayenne.objectForPK(this.context, Artist.class, 33001);
        SelectQuery<ArtGroup> q = new SelectQuery<ArtGroup>(ArtGroup.class);
        List results = this.context.performQuery(q);
        Assert.assertEquals((long)2L, (long)results.size());
        ArtGroup g1 = (ArtGroup)results.get(0);
        ArtGroup g2 = (ArtGroup)results.get(1);
        a1.addToGroupArray(g1);
        a1.addToGroupArray(g2);
        a1.removeFromGroupArray(g1);
        MockDataNode nodeWrapper = MockDataNode.interceptNode(this.runtime.getDataDomain(), this.runtime.getDataDomain().getDataNodes().iterator().next());
        try {
            this.context.commitChanges();
        }
        finally {
            nodeWrapper.stopInterceptNode();
        }
        Assert.assertEquals((long)1L, (long)nodeWrapper.getRunCount());
    }
}

