/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class SQLTemplateCacheKeyIT
extends ServerCase {
    @Inject
    private EntityResolver resolver;

    @Test
    public void testNoCache() {
        SQLTemplate query = new SQLTemplate(Artist.class, "SELECT ME");
        QueryMetadata md1 = query.getMetaData(this.resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.NO_CACHE), (Object)((Object)md1.getCacheStrategy()));
        Assert.assertNull((Object)md1.getCacheKey());
        query.setName("XYZ");
        QueryMetadata md2 = query.getMetaData(this.resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.NO_CACHE), (Object)((Object)md2.getCacheStrategy()));
        Assert.assertNull((Object)md2.getCacheKey());
    }

    @Test
    public void testLocalCache() {
        SQLTemplate query = new SQLTemplate(Artist.class, "SELECT ME");
        query.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        QueryMetadata md1 = query.getMetaData(this.resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.LOCAL_CACHE), (Object)((Object)md1.getCacheStrategy()));
        Assert.assertNotNull((Object)md1.getCacheKey());
    }

    @Test
    public void testSharedCache() {
        SQLTemplate query = new SQLTemplate(Artist.class, "SELECT ME");
        query.setCacheStrategy(QueryCacheStrategy.SHARED_CACHE);
        QueryMetadata md1 = query.getMetaData(this.resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.SHARED_CACHE), (Object)((Object)md1.getCacheStrategy()));
        Assert.assertNotNull((Object)md1.getCacheKey());
    }

    @Test
    public void testNamedQuery() {
        SQLTemplate query = new SQLTemplate(Artist.class, "SELECT ME");
        query.setCacheStrategy(QueryCacheStrategy.SHARED_CACHE);
        query.setName("XYZ");
        QueryMetadata md1 = query.getMetaData(this.resolver);
        Assert.assertEquals((Object)((Object)QueryCacheStrategy.SHARED_CACHE), (Object)((Object)md1.getCacheStrategy()));
        Assert.assertFalse((boolean)"XYZ".equals(md1.getCacheKey()));
    }

    @Test
    public void testCacheFetchLimitAndOffset() {
        SQLTemplate q1 = new SQLTemplate(Artist.class, "SELECT ME");
        q1.setFetchOffset(5);
        q1.setFetchLimit(10);
        q1.setCacheStrategy(QueryCacheStrategy.SHARED_CACHE);
        SQLTemplate q2 = new SQLTemplate(Artist.class, "SELECT ME");
        q2.setFetchOffset(5);
        q2.setFetchLimit(10);
        q2.setCacheStrategy(QueryCacheStrategy.SHARED_CACHE);
        Assert.assertEquals((Object)q1.getMetaData(this.resolver).getCacheKey(), (Object)q2.getMetaData(this.resolver).getCacheKey());
    }
}

