/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.cayenne.access.QueryEngine;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.SQLResult;
import org.apache.cayenne.query.AbstractQuery;
import org.apache.cayenne.query.BaseQueryMetadata;
import org.apache.cayenne.query.CapsStrategy;
import org.apache.cayenne.query.ParameterizedQuery;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.QueryRouter;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLActionVisitor;
import org.apache.cayenne.query.SQLTemplateMetadata;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Transformer;

public class SQLTemplate
extends AbstractQuery
implements ParameterizedQuery,
XMLSerializable {
    private static final long serialVersionUID = -3073521388289663641L;
    public static final String COLUMN_NAME_CAPITALIZATION_PROPERTY = "cayenne.SQLTemplate.columnNameCapitalization";
    private static final Transformer nullMapTransformer = new Transformer(){

        public Object transform(Object input) {
            return input != null ? input : Collections.EMPTY_MAP;
        }
    };
    protected String defaultTemplate;
    protected Map<String, String> templates;
    protected Map<String, ?>[] parameters;
    protected List<Object> positionalParams;
    protected CapsStrategy columnNamesCapitalization;
    protected SQLResult result;
    private String dataNodeName;
    SQLTemplateMetadata metaData = new SQLTemplateMetadata();

    public SQLTemplate() {
    }

    public SQLTemplate(String defaultTemplate, boolean isFetchingDataRows) {
        this.setDefaultTemplate(defaultTemplate);
        this.setRoot(null);
        this.setFetchingDataRows(isFetchingDataRows);
    }

    @Override
    public void setRoot(Object value) {
        if (value == null) {
            this.root = value;
        } else {
            super.setRoot(value);
        }
    }

    @Override
    public void route(QueryRouter router, EntityResolver resolver, Query substitutedQuery) {
        DataMap map = this.getMetaData(resolver).getDataMap();
        QueryEngine engine = map != null ? router.engineForDataMap(map) : router.engineForName(this.getDataNodeName());
        router.route(engine, this, substitutedQuery);
    }

    public SQLTemplate(DataMap rootMap, String defaultTemplate, boolean isFetchingDataRows) {
        this.setDefaultTemplate(defaultTemplate);
        this.setRoot(rootMap);
        this.setFetchingDataRows(isFetchingDataRows);
    }

    public SQLTemplate(ObjEntity rootEntity, String defaultTemplate) {
        this.setDefaultTemplate(defaultTemplate);
        this.setRoot(rootEntity);
    }

    public SQLTemplate(Class<?> rootClass, String defaultTemplate) {
        this.setDefaultTemplate(defaultTemplate);
        this.setRoot(rootClass);
    }

    public SQLTemplate(DbEntity rootEntity, String defaultTemplate) {
        this.setDefaultTemplate(defaultTemplate);
        this.setRoot(rootEntity);
    }

    public SQLTemplate(String objEntityName, String defaultTemplate) {
        this.setRoot(objEntityName);
        this.setDefaultTemplate(defaultTemplate);
    }

    @Override
    public QueryMetadata getMetaData(EntityResolver resolver) {
        this.metaData.resolve(this.root, resolver, this);
        return this.metaData;
    }

    @Override
    public SQLAction createSQLAction(SQLActionVisitor visitor) {
        return visitor.sqlAction(this);
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<query name=\"");
        encoder.print(this.getName());
        encoder.print("\" factory=\"");
        encoder.print("org.apache.cayenne.map.SQLTemplateBuilder");
        String rootString = null;
        String rootType = null;
        if (this.root instanceof String) {
            rootType = "obj-entity";
            rootString = this.root.toString();
        } else if (this.root instanceof ObjEntity) {
            rootType = "obj-entity";
            rootString = ((ObjEntity)this.root).getName();
        } else if (this.root instanceof DbEntity) {
            rootType = "db-entity";
            rootString = ((DbEntity)this.root).getName();
        } else if (this.root instanceof Procedure) {
            rootType = "procedure";
            rootString = ((Procedure)this.root).getName();
        } else if (this.root instanceof Class) {
            rootType = "java-class";
            rootString = ((Class)this.root).getName();
        } else if (this.root instanceof DataMap) {
            rootType = "data-map";
            rootString = ((DataMap)this.root).getName();
        }
        if (rootType != null) {
            encoder.print("\" root=\"");
            encoder.print(rootType);
            encoder.print("\" root-name=\"");
            encoder.print(rootString);
        }
        encoder.println("\">");
        encoder.indent(1);
        this.metaData.encodeAsXML(encoder);
        if (this.getColumnNamesCapitalization() != CapsStrategy.DEFAULT) {
            encoder.printProperty(COLUMN_NAME_CAPITALIZATION_PROPERTY, this.getColumnNamesCapitalization().name());
        }
        if (this.defaultTemplate != null) {
            encoder.print("<sql><![CDATA[");
            encoder.print(this.defaultTemplate);
            encoder.println("]]></sql>");
        }
        if (this.templates != null && !this.templates.isEmpty()) {
            TreeSet<String> keys = new TreeSet<String>(this.templates.keySet());
            for (String key : keys) {
                String sql;
                String value = this.templates.get(key);
                if (key == null || value == null || (sql = value.trim()).length() <= 0) continue;
                encoder.print("<sql adapter-class=\"");
                encoder.print(key);
                encoder.print("\"><![CDATA[");
                encoder.print(sql);
                encoder.println("]]></sql>");
            }
        }
        encoder.indent(-1);
        encoder.println("</query>");
    }

    public void initWithProperties(Map<String, ?> properties) {
        Object columnNamesCapitalization;
        this.metaData.initWithProperties(properties);
        if (properties == null) {
            properties = Collections.emptyMap();
        }
        this.columnNamesCapitalization = (columnNamesCapitalization = properties.get(COLUMN_NAME_CAPITALIZATION_PROPERTY)) != null ? CapsStrategy.valueOf(columnNamesCapitalization.toString().toUpperCase()) : null;
    }

    public Iterator<Map<String, ?>> parametersIterator() {
        return this.parameters == null || this.parameters.length == 0 ? IteratorUtils.emptyIterator() : IteratorUtils.transformedIterator((Iterator)IteratorUtils.arrayIterator((Object[])this.parameters), (Transformer)nullMapTransformer);
    }

    public int parametersSize() {
        return this.parameters != null ? this.parameters.length : 0;
    }

    public void setParams(Map<String, ?> params) {
        this.positionalParams = null;
        this.setParameters(params);
    }

    public void setParamsArray(Object ... params) {
        this.setParamsList(params != null ? Arrays.asList(params) : null);
    }

    public void setParamsList(List<Object> params) {
        this.parameters = null;
        this.positionalParams = params != null ? new ArrayList<Object>(params) : null;
    }

    public SQLTemplate queryWithParameters(Map<String, ?> ... parameters) {
        SQLTemplate query = new SQLTemplate();
        query.setRoot(this.root);
        query.setDefaultTemplate(this.getDefaultTemplate());
        if (this.templates != null) {
            query.templates = new HashMap<String, String>(this.templates);
        }
        query.metaData.copyFromInfo(this.metaData);
        query.setParameters(parameters);
        query.setColumnNamesCapitalization(this.getColumnNamesCapitalization());
        return query;
    }

    @Override
    public Query createQuery(Map<String, ?> parameters) {
        SQLTemplate query = new SQLTemplate();
        query.setRoot(this.root);
        query.setDefaultTemplate(this.getDefaultTemplate());
        if (this.templates != null) {
            query.templates = new HashMap<String, String>(this.templates);
        }
        query.metaData.copyFromInfo(this.metaData);
        query.setParams(parameters);
        query.setColumnNamesCapitalization(this.getColumnNamesCapitalization());
        return query;
    }

    @Override
    protected BaseQueryMetadata getBaseMetaData() {
        return this.metaData;
    }

    public int getFetchLimit() {
        return this.metaData.getFetchLimit();
    }

    public void setFetchLimit(int fetchLimit) {
        this.metaData.setFetchLimit(fetchLimit);
    }

    public int getFetchOffset() {
        return this.metaData.getFetchOffset();
    }

    public void setFetchOffset(int fetchOffset) {
        this.metaData.setFetchOffset(fetchOffset);
    }

    public int getPageSize() {
        return this.metaData.getPageSize();
    }

    public void setPageSize(int pageSize) {
        this.metaData.setPageSize(pageSize);
    }

    public void setFetchingDataRows(boolean flag) {
        this.metaData.setFetchingDataRows(flag);
    }

    public boolean isFetchingDataRows() {
        return this.metaData.isFetchingDataRows();
    }

    public String getDefaultTemplate() {
        return this.defaultTemplate;
    }

    public void setDefaultTemplate(String string) {
        this.defaultTemplate = string;
    }

    public synchronized String getTemplate(String key) {
        if (this.templates == null) {
            return this.defaultTemplate;
        }
        String template = this.templates.get(key);
        return template != null ? template : this.defaultTemplate;
    }

    public synchronized String getCustomTemplate(String key) {
        return this.templates != null ? this.templates.get(key) : null;
    }

    public synchronized void setTemplate(String key, String template) {
        if (this.templates == null) {
            this.templates = new HashMap<String, String>();
        }
        this.templates.put(key, template);
    }

    public synchronized void removeTemplate(String key) {
        if (this.templates != null) {
            this.templates.remove(key);
        }
    }

    public synchronized Collection<String> getTemplateKeys() {
        return this.templates != null ? this.templates.keySet() : Collections.emptyList();
    }

    public Map<String, ?> getParams() {
        Map map = this.parameters != null && this.parameters.length > 0 ? this.parameters[0] : null;
        return map != null ? map : Collections.emptyMap();
    }

    public List<Object> getPositionalParams() {
        return this.positionalParams != null ? this.positionalParams : Collections.emptyList();
    }

    public Map<String, ?> getParameters() {
        return this.getParams();
    }

    public void setParameters(Map<String, ?> ... parameters) {
        if (parameters == null) {
            this.parameters = null;
        } else {
            this.parameters = new Map[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                this.parameters[i] = parameters[i] != null ? new HashMap(parameters[i]) : new HashMap();
            }
        }
    }

    public PrefetchTreeNode getPrefetchTree() {
        return this.metaData.getPrefetchTree();
    }

    public PrefetchTreeNode addPrefetch(String prefetchPath) {
        return this.metaData.addPrefetch(prefetchPath, 1);
    }

    public void addPrefetch(PrefetchTreeNode prefetchElement) {
        this.metaData.mergePrefetch(prefetchElement);
    }

    public void removePrefetch(String prefetch) {
        this.metaData.removePrefetch(prefetch);
    }

    public void addPrefetches(Collection<String> prefetches) {
        this.metaData.addPrefetches(prefetches, 1);
    }

    public void clearPrefetches() {
        this.metaData.clearPrefetches();
    }

    public CapsStrategy getColumnNamesCapitalization() {
        return this.columnNamesCapitalization != null ? this.columnNamesCapitalization : CapsStrategy.DEFAULT;
    }

    public void setColumnNamesCapitalization(CapsStrategy columnNameCapitalization) {
        this.columnNamesCapitalization = columnNameCapitalization;
    }

    public void setResult(SQLResult resultSet) {
        this.result = resultSet;
    }

    public SQLResult getResult() {
        return this.result;
    }

    public void setStatementFetchSize(int size) {
        this.metaData.setStatementFetchSize(size);
    }

    public int getStatementFetchSize() {
        return this.metaData.getStatementFetchSize();
    }

    public String getDataNodeName() {
        return this.dataNodeName;
    }

    public void setDataNodeName(String dataNodeName) {
        this.dataNodeName = dataNodeName;
    }
}

