/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.text.DateFormat;
import java.util.List;
import java.util.Locale;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.Fault;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ResultBatchIterator;
import org.apache.cayenne.ResultIteratorCallback;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.FunctionExpressionFactory;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.query.ColumnSelect;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.PostgresUnitDbAdapter;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ColumnSelectIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private ServerRuntime runtime;
    @Inject
    private DBHelper dbHelper;
    @Inject
    private UnitDbAdapter unitDbAdapter;
    private static final DateFormat dateFormat = DateFormat.getDateInstance(3, Locale.US);
    private TableHelper tArtist;
    private TableHelper tPaintings;

    @Before
    public void createArtistsDataSet() throws Exception {
        int i;
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME", "DATE_OF_BIRTH"});
        this.tArtist.setColumnTypes(new int[]{4, 12, 91});
        Date[] dates = new Date[5];
        for (i = 1; i <= 5; ++i) {
            dates[i - 1] = new Date(dateFormat.parse("1/" + i + "/17").getTime());
        }
        for (i = 1; i <= 20; ++i) {
            this.tArtist.insert(new Object[]{i, "artist" + i, dates[i % 5]});
        }
        TableHelper tGallery = new TableHelper(this.dbHelper, "GALLERY");
        tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
        tGallery.insert(new Object[]{1, "tate modern"});
        this.tPaintings = new TableHelper(this.dbHelper, "PAINTING");
        this.tPaintings.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "GALLERY_ID", "ESTIMATED_PRICE"});
        for (int i2 = 1; i2 <= 20; ++i2) {
            this.tPaintings.insert(new Object[]{i2, "painting" + i2, i2 % 5 + 1, 1, 22 - i2});
        }
        this.tPaintings.insert(new Object[]{21, "painting21", 2, 1, 30});
    }

    @Test
    public void testSelectGroupBy() throws Exception {
        Object[] result = ObjectSelect.query(Artist.class).columns(Artist.DATE_OF_BIRTH, Property.COUNT).orderBy(Artist.DATE_OF_BIRTH.asc()).selectFirst(this.context);
        Assert.assertEquals((Object)dateFormat.parse("1/1/17"), (Object)result[0]);
        Assert.assertEquals((Object)4L, (Object)result[1]);
    }

    @Test
    public void testSelectSimpleHaving() throws Exception {
        Object[] result = (Object[])ObjectSelect.query(Artist.class).columns(Artist.DATE_OF_BIRTH, Property.COUNT).orderBy(Artist.DATE_OF_BIRTH.asc()).having(Artist.DATE_OF_BIRTH.eq(dateFormat.parse("1/2/17"))).selectOne(this.context);
        Assert.assertEquals((Object)dateFormat.parse("1/2/17"), (Object)result[0]);
        Assert.assertEquals((Object)4L, (Object)result[1]);
    }

    @Test(expected=Exception.class)
    public void testHavingOnNonGroupByColumn() throws Exception {
        Property<String> nameSubstr = Artist.ARTIST_NAME.substring(1, 6);
        Object[] q = (Object[])ObjectSelect.columnQuery(Artist.class, nameSubstr, Property.COUNT).having(Artist.ARTIST_NAME.like("artist%")).selectOne(this.context);
        Assert.assertEquals((Object)"artist", (Object)q[0]);
        Assert.assertEquals((Object)20L, (Object)q[1]);
    }

    @Test
    public void testSelectRelationshipCount() throws Exception {
        Object[] result = ObjectSelect.query(Artist.class).columns(Artist.DATE_OF_BIRTH, Artist.PAINTING_ARRAY.count()).orderBy(Artist.DATE_OF_BIRTH.asc()).selectFirst(this.context);
        Assert.assertEquals((Object)dateFormat.parse("1/1/17"), (Object)result[0]);
        Assert.assertEquals((Object)4L, (Object)result[1]);
    }

    @Test
    public void testSelectHavingWithExpressionAlias() throws Exception {
        Object[] q = null;
        try {
            q = (Object[])ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME.substring(1, 6).alias("name_substr"), Property.COUNT).having(Property.COUNT.gt(10L)).selectOne(this.context);
        }
        catch (CayenneRuntimeException ex) {
            if (this.unitDbAdapter.supportsExpressionInHaving()) {
                Assert.fail();
            }
            return;
        }
        Assert.assertEquals((Object)"artist", (Object)q[0]);
        Assert.assertEquals((Object)20L, (Object)q[1]);
    }

    @Ignore(value="Need to figure out a better way to handle alias / no alias case for expression in having")
    @Test
    public void testSelectHavingWithExpressionNoAlias() throws Exception {
        Object[] q = null;
        try {
            q = (Object[])ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME.substring(1, 6), Property.COUNT).having(Property.COUNT.gt(10L)).selectOne(this.context);
        }
        catch (CayenneRuntimeException ex) {
            if (this.unitDbAdapter.supportsExpressionInHaving()) {
                Assert.fail();
            }
            return;
        }
        Assert.assertEquals((Object)"artist", (Object)q[0]);
        Assert.assertEquals((Object)20L, (Object)q[1]);
    }

    @Test
    public void testSelectWhereAndHaving() throws Exception {
        Object[] q = null;
        try {
            q = (Object[])ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME.substring(1, 6).alias("name_substr"), Property.COUNT).where(Artist.ARTIST_NAME.substring(1, 1).eq("a")).having(Property.COUNT.gt(10L)).selectOne(this.context);
        }
        catch (CayenneRuntimeException ex) {
            if (this.unitDbAdapter.supportsExpressionInHaving()) {
                Assert.fail();
            }
            return;
        }
        Assert.assertEquals((Object)"artist", (Object)q[0]);
        Assert.assertEquals((Object)20L, (Object)q[1]);
    }

    @Test
    public void testHavingWithoutAggregate() throws Exception {
        Object[] date = ObjectSelect.columnQuery(Artist.class, Artist.DATE_OF_BIRTH, Artist.ARTIST_NAME).having(Artist.ARTIST_NAME.like("a%")).selectFirst(this.context);
        Assert.assertNotNull((Object)date);
    }

    @Ignore
    @Test
    public void testHavingWithoutSelect() throws Exception {
        Object date = ObjectSelect.columnQuery(Artist.class, Artist.DATE_OF_BIRTH).having(Artist.ARTIST_NAME.like("a%")).selectFirst(this.context);
        Assert.assertNotNull(date);
    }

    @Test
    public void testSelectRelationshipCountHavingWithoutFieldSelect() throws Exception {
        Object[] result = null;
        try {
            result = (Object[])ObjectSelect.query(Artist.class).columns(Artist.ARTIST_NAME, new Property[0]).having(Artist.PAINTING_ARRAY.count().gt(4L)).selectOne(this.context);
        }
        catch (CayenneRuntimeException ex) {
            if (this.unitDbAdapter.supportsExpressionInHaving()) {
                Assert.fail();
            }
            return;
        }
        Assert.assertEquals((Object)"artist2", (Object)result[0]);
    }

    @Test
    public void testSelectRelationshipCountHaving() throws Exception {
        Property<Long> paintingCount = Artist.PAINTING_ARRAY.count();
        Object[] result = null;
        try {
            result = (Object[])ObjectSelect.query(Artist.class).columns(Artist.ARTIST_NAME, paintingCount).having(paintingCount.gt(4L)).selectOne(this.context);
        }
        catch (CayenneRuntimeException ex) {
            if (this.unitDbAdapter.supportsExpressionInHaving()) {
                Assert.fail();
            }
            return;
        }
        Assert.assertEquals((Object)"artist2", (Object)result[0]);
        Assert.assertEquals((Object)5L, (Object)result[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectWithQuoting() throws Exception {
        Object[] result;
        block7: {
            if (this.unitDbAdapter instanceof PostgresUnitDbAdapter) {
                return;
            }
            Property<Long> paintingCount = Artist.PAINTING_ARRAY.count();
            this.context.getEntityResolver().getDataMap("testmap").setQuotingSQLIdentifiers(true);
            result = null;
            try {
                result = (Object[])ObjectSelect.query(Artist.class).columns(Artist.ARTIST_NAME, Artist.DATE_OF_BIRTH, paintingCount).having(paintingCount.gt(4L)).selectOne(this.context);
            }
            catch (CayenneRuntimeException ex) {
                if (this.unitDbAdapter.supportsExpressionInHaving()) {
                    Assert.fail();
                    break block7;
                }
                return;
            }
            finally {
                this.context.getEntityResolver().getDataMap("testmap").setQuotingSQLIdentifiers(false);
            }
        }
        Assert.assertEquals((Object)"artist2", (Object)result[0]);
        Assert.assertEquals((Object)5L, (Object)result[2]);
    }

    @Test
    public void testSelectGroupByWithQuoting() throws Exception {
        if (this.unitDbAdapter instanceof PostgresUnitDbAdapter) {
            return;
        }
        this.context.getEntityResolver().getDataMap("testmap").setQuotingSQLIdentifiers(true);
        try {
            Object[] result = ObjectSelect.query(Artist.class).columns(Artist.DATE_OF_BIRTH, Property.COUNT).orderBy(Artist.DATE_OF_BIRTH.asc()).selectFirst(this.context);
            Assert.assertEquals((Object)dateFormat.parse("1/1/17"), (Object)result[0]);
            Assert.assertEquals((Object)4L, (Object)result[1]);
        }
        finally {
            this.context.getEntityResolver().getDataMap("testmap").setQuotingSQLIdentifiers(false);
        }
    }

    @Test
    public void testAgregateOnRelation() throws Exception {
        BigDecimal min = new BigDecimal(3);
        BigDecimal max = new BigDecimal(30);
        BigDecimal avg = new BigDecimal(BigInteger.valueOf(1290L), 2);
        BigDecimal sum = new BigDecimal(258);
        Property estimatedPrice = Artist.PAINTING_ARRAY.dot(Painting.ESTIMATED_PRICE);
        Object[] minMaxAvgPrice = (Object[])ObjectSelect.query(Artist.class).where(estimatedPrice.gte(min)).min(estimatedPrice).max(estimatedPrice).avg(estimatedPrice).sum(estimatedPrice).count().selectOne(this.context);
        Assert.assertEquals((long)0L, (long)min.compareTo((BigDecimal)minMaxAvgPrice[0]));
        Assert.assertEquals((long)0L, (long)max.compareTo((BigDecimal)minMaxAvgPrice[1]));
        Assert.assertEquals((long)0L, (long)avg.compareTo((BigDecimal)minMaxAvgPrice[2]));
        Assert.assertEquals((long)0L, (long)sum.compareTo((BigDecimal)minMaxAvgPrice[3]));
        Assert.assertEquals((Object)20L, (Object)minMaxAvgPrice[4]);
    }

    @Test
    public void testQueryCount() throws Exception {
        long count = (Long)ObjectSelect.columnQuery(Artist.class, Property.COUNT).selectOne(this.context);
        Assert.assertEquals((long)20L, (long)count);
        long count2 = (Long)ObjectSelect.query(Artist.class).count().selectOne(this.context);
        Assert.assertEquals((long)count, (long)count2);
        long count3 = ObjectSelect.query(Artist.class).selectCount(this.context);
        Assert.assertEquals((long)count, (long)count3);
    }

    @Test
    public void testQueryCountWithProperty() throws Exception {
        this.tArtist.insert(new Object[]{21, "artist_21", null});
        this.tArtist.insert(new Object[]{22, "artist_21", null});
        long count = (Long)ObjectSelect.columnQuery(Artist.class, Property.COUNT).selectOne(this.context);
        Assert.assertEquals((long)22L, (long)count);
        long count2 = (Long)ObjectSelect.columnQuery(Artist.class, Artist.DATE_OF_BIRTH.count()).selectOne(this.context);
        Assert.assertEquals((long)20L, (long)count2);
        long count3 = (Long)ObjectSelect.query(Artist.class).count(Artist.DATE_OF_BIRTH).selectOne(this.context);
        Assert.assertEquals((long)count2, (long)count3);
    }

    @Test
    public void testSelectFirst_MultiColumns() throws Exception {
        Object[] a = ObjectSelect.query(Artist.class).columns(Artist.ARTIST_NAME, Artist.DATE_OF_BIRTH).columns(Artist.ARTIST_NAME, Artist.DATE_OF_BIRTH).columns(Artist.ARTIST_NAME.alias("newName"), new Property[0]).where(Artist.ARTIST_NAME.like("artist%")).orderBy("db:ARTIST_ID").selectFirst(this.context);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"artist1", (Object)a[0]);
        Assert.assertEquals((Object)"artist1", (Object)a[4]);
    }

    @Test
    public void testSelectFirst_SingleValueInColumns() throws Exception {
        Object[] a = ObjectSelect.query(Artist.class).columns(Artist.ARTIST_NAME, new Property[0]).where(Artist.ARTIST_NAME.like("artist%")).orderBy("db:ARTIST_ID").selectFirst(this.context);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"artist1", (Object)a[0]);
    }

    @Test
    public void testSelectFirst_SubstringName() throws Exception {
        Expression exp = FunctionExpressionFactory.substringExp(Artist.ARTIST_NAME.path(), 5, 3);
        Property<String> substrName = Property.create("substrName", exp, String.class);
        Object[] a = ObjectSelect.query(Artist.class).columns(Artist.ARTIST_NAME, substrName).where(substrName.eq("st3")).selectFirst(this.context);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"artist3", (Object)a[0]);
        Assert.assertEquals((Object)"st3", (Object)a[1]);
    }

    @Test
    public void testSelectFirst_RelColumns() throws Exception {
        Property paintingTitle = Artist.PAINTING_ARRAY.dot(Painting.PAINTING_TITLE).alias("paintingTitle");
        Object[] a = ObjectSelect.query(Artist.class).columns(Artist.ARTIST_NAME, paintingTitle).orderBy(paintingTitle.asc()).selectFirst(this.context);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"painting1", (Object)a[1]);
    }

    @Test
    public void testSelectFirst_RelColumn() throws Exception {
        Property paintingTitle = Artist.PAINTING_ARRAY.dot(Painting.PAINTING_TITLE).alias("paintingTitle");
        String a = (String)ObjectSelect.query(Artist.class).column(paintingTitle).orderBy(paintingTitle.asc()).selectFirst(this.context);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"painting1", (Object)a);
    }

    @Test
    public void testSelectFirst_RelColumnWithFunction() throws Exception {
        Property<String> altTitle = Artist.PAINTING_ARRAY.dot(Painting.PAINTING_TITLE).substring(7, 3).concat(" ", Artist.ARTIST_NAME).alias("altTitle");
        String a = ObjectSelect.query(Artist.class).column(altTitle).where(altTitle.like("ng1%")).and(Artist.ARTIST_NAME.like("%ist1")).selectFirst(this.context);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"ng1 artist1", (Object)a);
    }

    @Test
    public void testIterationSingleColumn() throws Exception {
        ColumnSelect columnSelect = ObjectSelect.query(Artist.class).column(Artist.ARTIST_NAME);
        final int[] count = new int[1];
        columnSelect.iterate(this.context, new ResultIteratorCallback<String>(){

            @Override
            public void next(String object) {
                count[0] = count[0] + 1;
                Assert.assertTrue((boolean)object.startsWith("artist"));
            }
        });
        Assert.assertEquals((long)20L, (long)count[0]);
    }

    @Test
    public void testBatchIterationSingleColumn() throws Exception {
        ColumnSelect columnSelect = ObjectSelect.query(Artist.class).column(Artist.ARTIST_NAME);
        try (ResultBatchIterator it = columnSelect.batchIterator(this.context, 10);){
            Object next = it.next();
            Assert.assertEquals((long)10L, (long)next.size());
            Assert.assertTrue((boolean)((String)next.get(0)).startsWith("artist"));
        }
    }

    @Test
    public void testIterationMultiColumns() throws Exception {
        ColumnSelect<Object[]> columnSelect = ObjectSelect.query(Artist.class).columns(Artist.ARTIST_NAME, Artist.DATE_OF_BIRTH);
        final int[] count = new int[1];
        columnSelect.iterate(this.context, new ResultIteratorCallback<Object[]>(){

            @Override
            public void next(Object[] object) {
                count[0] = count[0] + 1;
                Assert.assertTrue((boolean)(object[0] instanceof String));
                Assert.assertTrue((boolean)(object[1] instanceof java.util.Date));
            }
        });
        Assert.assertEquals((long)20L, (long)count[0]);
    }

    @Test
    public void testBatchIterationMultiColumns() throws Exception {
        ColumnSelect<Object[]> columnSelect = ObjectSelect.query(Artist.class).columns(Artist.ARTIST_NAME, Artist.DATE_OF_BIRTH);
        try (ResultBatchIterator it = columnSelect.batchIterator(this.context, 10);){
            Object next = it.next();
            Assert.assertEquals((long)10L, (long)next.size());
            Assert.assertTrue((boolean)(((Object[])next.get(0))[0] instanceof String));
            Assert.assertTrue((boolean)(((Object[])next.get(0))[1] instanceof java.util.Date));
        }
    }

    @Test
    public void testPageSizeOneScalar() {
        List a = ObjectSelect.query(Artist.class).column(Artist.ARTIST_NAME.trim()).pageSize(10).select(this.context);
        Assert.assertNotNull(a);
        Assert.assertEquals((long)20L, (long)a.size());
        int idx = 0;
        for (String next : a) {
            Assert.assertNotNull((String)("" + idx), (Object)next);
            ++idx;
        }
    }

    @Test
    public void testPageSizeOneScalarAsArray() {
        List a = ObjectSelect.query(Artist.class).columns(Artist.ARTIST_NAME.trim(), new Property[0]).pageSize(10).select(this.context);
        Assert.assertNotNull(a);
        Assert.assertEquals((long)20L, (long)a.size());
        int idx = 0;
        for (Object[] next : a) {
            Assert.assertNotNull((String)("" + idx), (Object)next[0]);
            Assert.assertTrue((boolean)(next[0] instanceof String));
            ++idx;
        }
    }

    @Test
    public void testPageSizeScalars() {
        List a = ObjectSelect.query(Artist.class).columns(Artist.ARTIST_NAME.trim(), Artist.DATE_OF_BIRTH, Artist.PAINTING_ARRAY.count()).pageSize(10).select(this.context);
        Assert.assertNotNull(a);
        Assert.assertEquals((long)5L, (long)a.size());
        int idx = 0;
        for (Object[] next : a) {
            Assert.assertNotNull((Object)next);
            Assert.assertTrue((String)("" + idx), (boolean)(next[0] instanceof String));
            Assert.assertTrue((String)("" + idx), (boolean)(next[1] instanceof java.util.Date));
            Assert.assertTrue((String)("" + idx), (boolean)(next[2] instanceof Long));
            ++idx;
        }
    }

    @Test
    public void testPageSizeOneObject() {
        Property<Artist> artistFull = Property.createSelf(Artist.class);
        List a = ObjectSelect.query(Artist.class).column(artistFull).pageSize(10).select(this.context);
        Assert.assertNotNull(a);
        Assert.assertEquals((long)20L, (long)a.size());
        for (Artist next : a) {
            Assert.assertNotNull((Object)next);
        }
    }

    @Test
    public void testPageSizeOneObjectAsArray() {
        Property<Artist> artistFull = Property.createSelf(Artist.class);
        List a = ObjectSelect.query(Artist.class).columns(artistFull, new Property[0]).pageSize(10).select(this.context);
        Assert.assertNotNull(a);
        Assert.assertEquals((long)20L, (long)a.size());
        for (Object[] next : a) {
            Assert.assertNotNull((Object)next[0]);
            Assert.assertTrue((boolean)(next[0] instanceof Artist));
        }
    }

    @Test
    public void testPageSizeObjectAndScalars() {
        Property<Artist> artistFull = Property.createSelf(Artist.class);
        List a = ObjectSelect.query(Artist.class).columns(Artist.ARTIST_NAME, artistFull, Artist.PAINTING_ARRAY.count()).pageSize(10).select(this.context);
        Assert.assertNotNull(a);
        Assert.assertEquals((long)5L, (long)a.size());
        int idx = 0;
        for (Object[] next : a) {
            Assert.assertNotNull((Object)next);
            Assert.assertEquals((String)("" + idx), String.class, next[0].getClass());
            Assert.assertEquals((String)("" + idx), Artist.class, next[1].getClass());
            Assert.assertEquals((String)("" + idx), Long.class, next[2].getClass());
            ++idx;
        }
    }

    @Test
    public void testPageSizeObjects() {
        Property<Artist> artistFull = Property.createSelf(Artist.class);
        List a = ObjectSelect.query(Artist.class).columns(Artist.ARTIST_NAME, artistFull, Artist.PAINTING_ARRAY.flat(Painting.class)).pageSize(10).select(this.context);
        Assert.assertNotNull(a);
        Assert.assertEquals((long)21L, (long)a.size());
        int idx = 0;
        for (Object[] next : a) {
            Assert.assertNotNull((Object)next);
            Assert.assertEquals((String)("" + idx), String.class, next[0].getClass());
            Assert.assertEquals((String)("" + idx), Artist.class, next[1].getClass());
            Assert.assertEquals((String)("" + idx), Painting.class, next[2].getClass());
            ++idx;
        }
    }

    @Test
    public void testObjectColumnWithJointPrefetch() {
        Property<Artist> artistFull = Property.createSelf(Artist.class);
        List<Object[]> result = ObjectSelect.query(Artist.class).columns(artistFull, Artist.DATE_OF_BIRTH, Artist.PAINTING_ARRAY.dot(Painting.PAINTING_TITLE)).prefetch(Artist.PAINTING_ARRAY.joint()).select(this.context);
        this.checkPrefetchResults(result);
    }

    @Test
    public void testObjectColumnWithDisjointPrefetch() {
        Property<Artist> artistFull = Property.createSelf(Artist.class);
        List<Object[]> result = ObjectSelect.query(Artist.class).columns(artistFull, Artist.DATE_OF_BIRTH, Artist.PAINTING_ARRAY.dot(Painting.PAINTING_TITLE)).prefetch(Artist.PAINTING_ARRAY.disjoint()).select(this.context);
        this.checkPrefetchResults(result);
    }

    @Test
    public void testObjectColumnWithDisjointByIdPrefetch() {
        Property<Artist> artistFull = Property.createSelf(Artist.class);
        List<Object[]> result = ObjectSelect.query(Artist.class).columns(artistFull, Artist.DATE_OF_BIRTH, Artist.PAINTING_ARRAY.dot(Painting.PAINTING_TITLE)).prefetch(Artist.PAINTING_ARRAY.disjointById()).select(this.context);
        this.checkPrefetchResults(result);
    }

    private void checkPrefetchResults(List<Object[]> result) {
        Assert.assertEquals((long)21L, (long)result.size());
        for (Object[] next : result) {
            Assert.assertTrue((boolean)(next[0] instanceof Artist));
            Assert.assertTrue((boolean)(next[1] instanceof java.util.Date));
            Assert.assertTrue((boolean)(next[2] instanceof String));
            Artist artist = (Artist)next[0];
            Assert.assertEquals((long)3L, (long)artist.getPersistenceState());
            Object paintingsArr = artist.readPropertyDirectly(Artist.PAINTING_ARRAY.getName());
            Assert.assertFalse((boolean)(paintingsArr instanceof Fault));
            Assert.assertTrue((((List)paintingsArr).size() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testAggregateColumnWithJointPrefetch() {
        Property<Artist> artistFull = Property.createSelf(Artist.class);
        List<Object[]> result = ObjectSelect.query(Artist.class).columns(artistFull, Artist.PAINTING_ARRAY.count()).prefetch(Artist.PAINTING_ARRAY.joint()).select(this.context);
        this.checkAggregatePrefetchResults(result);
    }

    @Test
    public void testAggregateColumnWithDisjointPrefetch() {
        Property<Artist> artistFull = Property.createSelf(Artist.class);
        List<Object[]> result = ObjectSelect.query(Artist.class).columns(artistFull, Artist.PAINTING_ARRAY.count()).prefetch(Artist.PAINTING_ARRAY.disjoint()).select(this.context);
        this.checkAggregatePrefetchResults(result);
    }

    @Test
    public void testAggregateColumnWithDisjointByIdPrefetch() {
        Property<Artist> artistFull = Property.createSelf(Artist.class);
        List<Object[]> result = ObjectSelect.query(Artist.class).columns(artistFull, Artist.PAINTING_ARRAY.count()).prefetch(Artist.PAINTING_ARRAY.disjointById()).select(this.context);
        this.checkAggregatePrefetchResults(result);
    }

    private void checkAggregatePrefetchResults(List<Object[]> result) {
        Assert.assertEquals((long)5L, (long)result.size());
        for (Object[] next : result) {
            Assert.assertTrue((boolean)(next[0] instanceof Artist));
            Assert.assertTrue((boolean)(next[1] instanceof Long));
            Artist artist = (Artist)next[0];
            Assert.assertEquals((long)3L, (long)artist.getPersistenceState());
            Object paintingsArr = artist.readPropertyDirectly(Artist.PAINTING_ARRAY.getName());
            Assert.assertFalse((boolean)(paintingsArr instanceof Fault));
            Assert.assertTrue(((long)((List)paintingsArr).size() == (Long)next[1] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testObjectSelectWithJointPrefetch() {
        List result = ObjectSelect.query(Artist.class).column(Property.createSelf(Artist.class)).prefetch(Artist.PAINTING_ARRAY.joint()).select(this.context);
        Assert.assertEquals((long)20L, (long)result.size());
        for (Artist artist : result) {
            Assert.assertEquals((long)3L, (long)artist.getPersistenceState());
            Object paintingsArr = artist.readPropertyDirectly(Artist.PAINTING_ARRAY.getName());
            Assert.assertFalse((boolean)(paintingsArr instanceof Fault));
        }
    }

    @Test
    public void testObjectWithDisjointPrefetch() {
        List result = ObjectSelect.query(Artist.class).column(Property.createSelf(Artist.class)).prefetch(Artist.PAINTING_ARRAY.disjoint()).select(this.context);
        Assert.assertEquals((long)20L, (long)result.size());
        for (Artist artist : result) {
            Assert.assertEquals((long)3L, (long)artist.getPersistenceState());
            Object paintingsArr = artist.readPropertyDirectly(Artist.PAINTING_ARRAY.getName());
            Assert.assertFalse((boolean)(paintingsArr instanceof Fault));
        }
    }

    @Test
    public void testObjectWithDisjointByIdPrefetch() {
        List result = ObjectSelect.query(Artist.class).column(Property.createSelf(Artist.class)).prefetch(Artist.PAINTING_ARRAY.disjointById()).select(this.context);
        Assert.assertEquals((long)20L, (long)result.size());
        for (Artist artist : result) {
            Assert.assertEquals((long)3L, (long)artist.getPersistenceState());
            Object paintingsArr = artist.readPropertyDirectly(Artist.PAINTING_ARRAY.getName());
            Assert.assertFalse((boolean)(paintingsArr instanceof Fault));
        }
    }

    @Test
    public void testObjectColumn() {
        Property<Artist> artistFull = Property.createSelf(Artist.class);
        List result = ObjectSelect.query(Artist.class).columns(artistFull, Artist.ARTIST_NAME, Artist.PAINTING_ARRAY.count()).select(this.context);
        Assert.assertEquals((long)5L, (long)result.size());
        for (Object[] next : result) {
            Assert.assertTrue((boolean)(next[0] instanceof Artist));
            Assert.assertTrue((boolean)(next[1] instanceof String));
            Assert.assertTrue((boolean)(next[2] instanceof Long));
            Assert.assertEquals((long)3L, (long)((Artist)next[0]).getPersistenceState());
        }
    }

    @Test
    public void testObjectColumnToOne() {
        Property<Artist> artistFull = Property.create(ExpressionFactory.fullObjectExp(Painting.TO_ARTIST.getExpression()), Artist.class);
        Property<Gallery> galleryFull = Property.create(ExpressionFactory.fullObjectExp(Painting.TO_GALLERY.getExpression()), Gallery.class);
        List result = ObjectSelect.query(Painting.class).columns(Painting.PAINTING_TITLE, artistFull, galleryFull).select(this.context);
        Assert.assertEquals((long)21L, (long)result.size());
        for (Object[] next : result) {
            Assert.assertTrue((boolean)(next[0] instanceof String));
            Assert.assertTrue((boolean)(next[1] instanceof Artist));
            Assert.assertTrue((boolean)(next[2] instanceof Gallery));
            Assert.assertEquals((long)3L, (long)((Artist)next[1]).getPersistenceState());
        }
    }

    @Test
    public void testObjectColumnToOneAsObjPath() {
        List result = ObjectSelect.query(Painting.class).columns(Painting.PAINTING_TITLE, Painting.TO_ARTIST, Painting.TO_GALLERY).select(this.context);
        Assert.assertEquals((long)21L, (long)result.size());
        for (Object[] next : result) {
            Assert.assertTrue((boolean)(next[0] instanceof String));
            Assert.assertTrue((boolean)(next[1] instanceof Artist));
            Assert.assertTrue((boolean)(next[2] instanceof Gallery));
            Assert.assertEquals((long)3L, (long)((Artist)next[1]).getPersistenceState());
        }
    }

    @Test
    public void testObjectColumnToMany() throws Exception {
        Property<Artist> artist = Property.createSelf(Artist.class);
        List result = ObjectSelect.query(Artist.class).columns(artist, Artist.PAINTING_ARRAY.flat(Painting.class), Artist.PAINTING_ARRAY.dot(Painting.TO_GALLERY)).select(this.context);
        Assert.assertEquals((long)21L, (long)result.size());
        for (Object[] next : result) {
            Assert.assertTrue((boolean)(next[0] instanceof Artist));
            Assert.assertTrue((boolean)(next[1] instanceof Painting));
            Assert.assertTrue((boolean)(next[2] instanceof Gallery));
            Assert.assertEquals((long)3L, (long)((Artist)next[0]).getPersistenceState());
            Assert.assertEquals((long)3L, (long)((Painting)next[1]).getPersistenceState());
            Assert.assertEquals((long)3L, (long)((Gallery)next[2]).getPersistenceState());
        }
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testDirectRelationshipSelect() {
        List result = ObjectSelect.query(Artist.class).column(Artist.PAINTING_ARRAY).select(this.context);
        Assert.assertEquals((long)21L, (long)result.size());
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testSelfPropertyInOrderBy() {
        Property<Artist> artistProperty = Property.createSelf(Artist.class);
        ObjectSelect.query(Artist.class).column(artistProperty).orderBy(artistProperty.desc()).select(this.context);
    }

    @Test(expected=CayenneRuntimeException.class)
    public void testSelfPropertyInWhere() {
        Artist artist = ObjectSelect.query(Artist.class).selectFirst(this.context);
        Property<Artist> artistProperty = Property.createSelf(Artist.class);
        List result = ObjectSelect.query(Artist.class).column(artistProperty).where(artistProperty.eq(artist)).select(this.context);
    }

    @Test
    public void testObjPropertyInWhere() {
        Artist artist = ObjectSelect.query(Artist.class, Artist.ARTIST_NAME.eq("artist1")).selectFirst(this.context);
        Property<Painting> paintingProperty = Property.createSelf(Painting.class);
        List result = ObjectSelect.query(Painting.class).column(paintingProperty).where(Painting.TO_ARTIST.eq(artist)).select(this.context);
        Assert.assertEquals((long)4L, (long)result.size());
    }

    @Test
    public void testExplicitDistinct() throws Exception {
        this.tArtist.insert(new Object[]{21, "artist1", null});
        List result = ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME).select(this.context);
        Assert.assertEquals((long)21L, (long)result.size());
        List result2 = ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME).suppressDistinct().select(this.context);
        Assert.assertEquals(result, result2);
        result = ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME).distinct().select(this.context);
        Assert.assertEquals((long)20L, (long)result.size());
    }

    @Test
    public void testSuppressDistinct() throws Exception {
        this.tArtist.insert(new Object[]{21, "artist1", null});
        this.tPaintings.insert(new Object[]{22, "painting10", 21, 1, 23});
        List result = ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME, Artist.PAINTING_ARRAY.dot(Painting.PAINTING_TITLE)).select(this.context);
        Assert.assertEquals((long)21L, (long)result.size());
        List result2 = ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME, Artist.PAINTING_ARRAY.dot(Painting.PAINTING_TITLE)).distinct().select(this.context);
        Assert.assertEquals((long)result.size(), (long)result2.size());
        for (int i = 0; i < result.size(); ++i) {
            Assert.assertArrayEquals((Object[])((Object[])result.get(i)), (Object[])((Object[])result2.get(i)));
        }
        result = ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME, Artist.PAINTING_ARRAY.dot(Painting.PAINTING_TITLE)).suppressDistinct().select(this.context);
        Assert.assertEquals((long)22L, (long)result.size());
    }

    @Test
    public void testDeprecateConstructor() {
        Property property = new Property("artistName");
        List names = ObjectSelect.columnQuery(Artist.class, property).select(this.context);
        Assert.assertEquals((long)20L, (long)names.size());
    }

    @Test
    public void testNestedContextScalarResult() {
        ObjectContext childContext = this.runtime.newContext(this.context);
        List names = ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME).select(childContext);
        Assert.assertEquals((long)20L, (long)names.size());
        for (String name : names) {
            Assert.assertNotNull((Object)name);
        }
    }

    @Test
    public void testNestedContextObjectResult() {
        ObjectContext childContext = this.runtime.newContext(this.context);
        Property<Artist> artistProperty = Property.createSelf(Artist.class);
        List artists = ObjectSelect.columnQuery(Artist.class, artistProperty).select(childContext);
        Assert.assertEquals((long)20L, (long)artists.size());
        for (Artist artist : artists) {
            Assert.assertNotNull((Object)artist);
        }
    }

    @Test
    public void testNestedContextScalarArrayResult() {
        ObjectContext childContext = this.runtime.newContext(this.context);
        List data = ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME, Artist.DATE_OF_BIRTH).select(childContext);
        Assert.assertEquals((long)20L, (long)data.size());
        for (Object[] next : data) {
            Assert.assertTrue((boolean)(next[0] instanceof String));
            Assert.assertTrue((boolean)(next[1] instanceof java.util.Date));
        }
    }

    @Test
    public void testNestedContextMixedResult() {
        ObjectContext childContext = this.runtime.newContext(this.context);
        Property<Artist> artistProperty = Property.createSelf(Artist.class);
        List data = ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME, artistProperty).select(childContext);
        Assert.assertEquals((long)20L, (long)data.size());
        for (Object[] next : data) {
            Assert.assertTrue((boolean)(next[0] instanceof String));
            Assert.assertTrue((boolean)(next[1] instanceof Artist));
        }
    }
}

