/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ejbql;

import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.ejbql.EJBQLCompiledExpression;
import org.apache.cayenne.ejbql.EJBQLParser;
import org.apache.cayenne.ejbql.EJBQLParserFactory;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class EJBQLParser_CompileIT
extends ServerCase {
    @Inject
    protected ServerRuntime runtime;
    private EJBQLParser parser;
    private EntityResolver resolver;

    @Before
    public void before() {
        this.resolver = this.runtime.getDataDomain().getEntityResolver();
        this.parser = EJBQLParserFactory.getParser();
    }

    @Test
    public void testGetSource() {
        String source = "select a from Artist a";
        EJBQLCompiledExpression select = this.parser.compile(source, this.resolver);
        Assert.assertEquals((Object)source, (Object)select.getSource());
    }

    @Test
    public void testGetExpression() {
        String source = "select a from Artist a";
        EJBQLCompiledExpression select = this.parser.compile(source, this.resolver);
        Assert.assertNotNull((Object)select.getExpression());
    }

    @Test
    public void testGetEntityDescriptor() {
        EJBQLCompiledExpression select = this.parser.compile("select a from Artist a", this.resolver);
        Assert.assertNotNull((Object)select.getEntityDescriptor("a"));
        Assert.assertSame((Object)this.resolver.getClassDescriptor("Artist"), (Object)select.getEntityDescriptor("a"));
        EJBQLCompiledExpression select1 = this.parser.compile("select p from Painting p WHERE p.toArtist.artistName = 'a'", this.resolver);
        Assert.assertNotNull((Object)select1.getEntityDescriptor("p"));
        Assert.assertSame((Object)this.resolver.getClassDescriptor("Painting"), (Object)select1.getEntityDescriptor("p"));
        Assert.assertNotNull((Object)select1.getEntityDescriptor("p.toArtist"));
        Assert.assertSame((Object)this.resolver.getClassDescriptor("Artist"), (Object)select1.getEntityDescriptor("p.toArtist"));
    }

    @Test
    public void testGetRootDescriptor() {
        EJBQLCompiledExpression select = this.parser.compile("select a from Artist a", this.resolver);
        Assert.assertSame((String)("Root is not detected: " + select.getExpression()), (Object)this.resolver.getClassDescriptor("Artist"), (Object)select.getRootDescriptor());
    }

    @Test
    public void testGetEntityDescriptorCaseSensitivity() {
        EJBQLCompiledExpression select1 = this.parser.compile("select a from Artist a", this.resolver);
        Assert.assertNotNull((Object)select1.getEntityDescriptor("a"));
        Assert.assertNotNull((Object)select1.getEntityDescriptor("A"));
        EJBQLCompiledExpression select2 = this.parser.compile("select A from Artist A", this.resolver);
        Assert.assertNotNull((Object)select2.getEntityDescriptor("a"));
        Assert.assertNotNull((Object)select2.getEntityDescriptor("A"));
        EJBQLCompiledExpression select3 = this.parser.compile("select a from Artist A", this.resolver);
        Assert.assertNotNull((Object)select3.getEntityDescriptor("a"));
        Assert.assertNotNull((Object)select3.getEntityDescriptor("A"));
    }

    @Test
    public void testGetEntityDescriptorCaseSensitivityInJoin() {
        EJBQLCompiledExpression select1 = this.parser.compile("SELECT artistAlias FROM Artist artistAlias WHERE artistAlias.artistName = 'Abcd'", this.resolver);
        Assert.assertNotNull((Object)select1.getEntityDescriptor("artistalias"));
        Assert.assertNotNull((Object)select1.getEntityDescriptor("artistAlias"));
        Assert.assertNotNull((Object)select1.getEntityDescriptor("ArTiStAlIaS"));
        EJBQLCompiledExpression select2 = this.parser.compile("SELECT artistalias from Artist AS ArtistAlias JOIN artistalias.paintingArray as PaintingAlias where aRtistALiaS.artistName = 'Abcd'", this.resolver);
        Assert.assertNotNull((Object)select2.getEntityDescriptor("artistalias"));
        Assert.assertNotNull((Object)select2.getEntityDescriptor("artistAlias"));
        Assert.assertNotNull((Object)select2.getEntityDescriptor("ArTiStAlIaS"));
        Assert.assertNotNull((Object)select2.getEntityDescriptor("PaintingAlias"));
        Assert.assertNotNull((Object)select2.getEntityDescriptor("paintingalias"));
        Assert.assertNotNull((Object)select2.getEntityDescriptor("PaInTinGAlIaS"));
    }
}

