/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.qualified.Qualified1;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-qualified.xml")
public class ConcurrentPkGeneratorIT
extends ServerCase {
    @Inject
    private ServerRuntime runtime;
    @Inject
    private UnitDbAdapter unitDbAdapter;

    @Test
    public void testConcurrentInserts() throws Exception {
        if (!this.unitDbAdapter.supportsPKGeneratorConcurrency()) {
            return;
        }
        final DataMap dataMap = this.runtime.getDataDomain().getDataMap("qualified");
        ObjectContext context = this.runtime.newContext();
        List<Qualified1> qualified1s = context.select(SelectQuery.query(Qualified1.class, null));
        context.deleteObjects((Collection<?>)qualified1s);
        context.commitChanges();
        int numThreads = 2;
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    ObjectContext context = ConcurrentPkGeneratorIT.this.runtime.newContext();
                    for (ObjEntity entity : dataMap.getObjEntities()) {
                        context.newObject(entity.getJavaClass());
                    }
                    context.commitChanges();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        for (int j = 0; j < 100; ++j) {
            for (int i = 0; i < numThreads; ++i) {
                executor.submit(task);
            }
        }
        executor.shutdown();
        try {
            boolean didFinish = executor.awaitTermination(30L, TimeUnit.SECONDS);
            if (!didFinish) {
                Assert.fail((String)"Concurrent inserts either deadlocked or contended over the lock too long.");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        qualified1s = context.select(SelectQuery.query(Qualified1.class, null));
        Assert.assertEquals((long)(100 * numThreads), (long)qualified1s.size());
        Collections.sort(qualified1s, new Comparator<Qualified1>(){

            @Override
            public int compare(Qualified1 left, Qualified1 right) {
                Integer leftPk = Cayenne.intPKForObject(left);
                Integer rightPk = Cayenne.intPKForObject(right);
                return leftPk.compareTo(rightPk);
            }
        });
    }
}

