/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.configuration.server.ServerModule;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.configuration.server.ServerRuntimeBuilder;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.Module;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ServerRuntimeBuilderTest {
    private ServerRuntime runtime;

    @After
    public void stopRuntime() {
        if (this.runtime != null) {
            this.runtime.shutdown();
        }
    }

    @Test
    public void test_NoLocation() {
        this.runtime = new ServerRuntimeBuilder().build();
        List locations = (List)this.runtime.getInjector().getInstance(Key.getListOf(String.class, (String)"cayenne.server.project_locations"));
        Assert.assertEquals(Arrays.asList(new Object[0]), (Object)locations);
        Collection<Module> modules = this.runtime.getModules();
        Assert.assertEquals((long)2L, (long)modules.size());
        Assert.assertThat((Object)modules.iterator().next(), (Matcher)CoreMatchers.instanceOf(ServerModule.class));
    }

    @Test
    public void test_SingleLocation() {
        this.runtime = new ServerRuntimeBuilder().addConfig("xxxx").build();
        List locations = (List)this.runtime.getInjector().getInstance(Key.getListOf(String.class, (String)"cayenne.server.project_locations"));
        Assert.assertEquals(Arrays.asList("xxxx"), (Object)locations);
        Collection<Module> modules = this.runtime.getModules();
        Assert.assertEquals((long)2L, (long)modules.size());
        Assert.assertThat((Object)modules.iterator().next(), (Matcher)CoreMatchers.instanceOf(ServerModule.class));
    }

    @Test
    public void test_MultipleLocations() {
        this.runtime = new ServerRuntimeBuilder().addConfigs("xxxx", "yyyy").build();
        List locations = (List)this.runtime.getInjector().getInstance(Key.getListOf(String.class, (String)"cayenne.server.project_locations"));
        Assert.assertEquals(Arrays.asList("xxxx", "yyyy"), (Object)locations);
        Collection<Module> modules = this.runtime.getModules();
        Assert.assertEquals((long)3L, (long)modules.size());
        Assert.assertThat((Object)modules.iterator().next(), (Matcher)CoreMatchers.instanceOf(ServerModule.class));
    }

    @Test
    public void test_ExtraModules() {
        Module m = (Module)Mockito.mock(Module.class);
        this.runtime = new ServerRuntimeBuilder().addModule(m).build();
        Collection<Module> modules = this.runtime.getModules();
        Assert.assertEquals((long)3L, (long)modules.size());
        Module[] array = modules.toArray(new Module[3]);
        Assert.assertThat((Object)array[0], (Matcher)CoreMatchers.instanceOf(ServerModule.class));
        Assert.assertSame((Object)m, (Object)array[1]);
    }

    @Test
    public void test_UnnamedDomain_NoLocation() {
        this.runtime = new ServerRuntimeBuilder().build();
        Assert.assertEquals((Object)"cayenne", (Object)this.runtime.getDataDomain().getName());
    }

    @Test
    public void test_NamedDomain_NoLocation() {
        this.runtime = new ServerRuntimeBuilder("myd").build();
        Assert.assertEquals((Object)"myd", (Object)this.runtime.getDataDomain().getName());
    }
}

