/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.rop.server;

import com.mockrunner.mock.web.MockServletConfig;
import com.mockrunner.mock.web.MockServletContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.cayenne.configuration.CayenneRuntime;
import org.apache.cayenne.configuration.rop.server.ROPHessianServlet_ConfigModule;
import org.apache.cayenne.configuration.rop.server.ROPServerModule;
import org.apache.cayenne.configuration.server.ServerModule;
import org.apache.cayenne.configuration.web.MockModule1;
import org.apache.cayenne.configuration.web.MockModule2;
import org.apache.cayenne.configuration.web.MockRequestHandler;
import org.apache.cayenne.configuration.web.RequestHandler;
import org.apache.cayenne.configuration.web.WebUtil;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.rop.ROPServlet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ROPServletTest {
    private CayenneRuntime runtime;

    @After
    public void shutdownRuntime() {
        if (this.runtime != null) {
            this.runtime.shutdown();
        }
    }

    @Test
    public void testInitWithServletName() throws Exception {
        MockServletConfig config = new MockServletConfig();
        config.setServletName("cayenne-org.apache.cayenne.configuration.rop.server.test-config");
        MockServletContext context = new MockServletContext();
        config.setServletContext((ServletContext)context);
        ROPServlet servlet = new ROPServlet();
        Assert.assertNull((Object)WebUtil.getCayenneRuntime((ServletContext)context));
        servlet.init((ServletConfig)config);
        this.runtime = WebUtil.getCayenneRuntime((ServletContext)context);
        Assert.assertNotNull((Object)this.runtime);
        List locations = (List)this.runtime.getInjector().getInstance(Key.getListOf(String.class, (String)"cayenne.server.project_locations"));
        Assert.assertEquals(Arrays.asList("cayenne-org.apache.cayenne.configuration.rop.server.test-config.xml"), (Object)locations);
    }

    @Test
    public void testInitWithLocation() throws Exception {
        String location = "cayenne-org.apache.cayenne.configuration.rop.server.test-config.xml";
        MockServletConfig config = new MockServletConfig();
        config.setServletName("abc");
        config.setInitParameter("configuration-location", location);
        MockServletContext context = new MockServletContext();
        config.setServletContext((ServletContext)context);
        ROPServlet servlet = new ROPServlet();
        servlet.init((ServletConfig)config);
        this.runtime = WebUtil.getCayenneRuntime((ServletContext)context);
        Assert.assertNotNull((Object)this.runtime);
        List locations = (List)this.runtime.getInjector().getInstance(Key.getListOf(String.class, (String)"cayenne.server.project_locations"));
        Assert.assertEquals(Arrays.asList(location), (Object)locations);
    }

    @Test
    public void testInitWithStandardModules() throws Exception {
        String name = "cayenne-org.apache.cayenne.configuration.rop.server.test-config";
        MockServletConfig config = new MockServletConfig();
        config.setServletName(name);
        MockServletContext context = new MockServletContext();
        config.setServletContext((ServletContext)context);
        ROPServlet servlet = new ROPServlet();
        servlet.init((ServletConfig)config);
        this.runtime = WebUtil.getCayenneRuntime((ServletContext)context);
        Assert.assertNotNull((Object)this.runtime);
        List locations = (List)this.runtime.getInjector().getInstance(Key.getListOf(String.class, (String)"cayenne.server.project_locations"));
        Assert.assertEquals(Arrays.asList(name + ".xml"), (Object)locations);
        Collection<Module> modules = this.runtime.getModules();
        Assert.assertEquals((long)3L, (long)modules.size());
        Object[] marray = modules.toArray();
        Assert.assertTrue((boolean)(marray[0] instanceof ServerModule));
        Assert.assertTrue((boolean)(marray[1] instanceof ROPServerModule));
    }

    @Test
    public void testInitWithExtraModules() throws Exception {
        String name = "cayenne-org.apache.cayenne.configuration.rop.server.test-config";
        MockServletConfig config = new MockServletConfig();
        config.setServletName(name);
        config.setInitParameter("extra-modules", MockModule1.class.getName() + "," + MockModule2.class.getName());
        MockServletContext context = new MockServletContext();
        config.setServletContext((ServletContext)context);
        ROPServlet servlet = new ROPServlet();
        servlet.init((ServletConfig)config);
        this.runtime = WebUtil.getCayenneRuntime((ServletContext)context);
        Assert.assertNotNull((Object)this.runtime);
        Collection<Module> modules = this.runtime.getModules();
        Assert.assertEquals((long)5L, (long)modules.size());
        Object[] marray = modules.toArray();
        Assert.assertTrue((boolean)(marray[0] instanceof ServerModule));
        Assert.assertTrue((boolean)(marray[1] instanceof ROPServerModule));
        Assert.assertTrue((boolean)(marray[2] instanceof MockModule1));
        Assert.assertTrue((boolean)(marray[3] instanceof MockModule2));
        RequestHandler handler = (RequestHandler)this.runtime.getInjector().getInstance(RequestHandler.class);
        Assert.assertTrue((boolean)(handler instanceof MockRequestHandler));
    }

    @Test
    public void testInitHessianService() throws Exception {
        MockServletConfig config = new MockServletConfig();
        config.setServletName("abc");
        MockServletContext context = new MockServletContext();
        config.setServletContext((ServletContext)context);
        config.setInitParameter("extra-modules", ROPHessianServlet_ConfigModule.class.getName());
        ROPServlet servlet = new ROPServlet();
        servlet.init((ServletConfig)config);
        this.runtime = WebUtil.getCayenneRuntime((ServletContext)context);
        Collection<Module> modules = this.runtime.getModules();
        Assert.assertEquals((long)4L, (long)modules.size());
        Object[] marray = modules.toArray();
        Assert.assertTrue((boolean)(marray[2] instanceof ROPHessianServlet_ConfigModule));
    }
}

