/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.osgi;

import java.util.Collections;
import org.apache.cayenne.configuration.osgi.OsgiClassLoaderManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class OsgiClassLoaderManagerTest {
    @Test
    public void testGetClassLoader() {
        ClassLoader appCl = (ClassLoader)Mockito.mock(ClassLoader.class);
        final ClassLoader diCl = (ClassLoader)Mockito.mock(ClassLoader.class);
        final ClassLoader serverCl = (ClassLoader)Mockito.mock(ClassLoader.class);
        OsgiClassLoaderManager manager = new OsgiClassLoaderManager(appCl, Collections.emptyMap()){

            @Override
            protected ClassLoader cayenneDiClassLoader() {
                return diCl;
            }

            @Override
            protected ClassLoader cayenneServerClassLoader() {
                return serverCl;
            }
        };
        Assert.assertSame((Object)appCl, (Object)manager.getClassLoader(null));
        Assert.assertSame((Object)appCl, (Object)manager.getClassLoader(""));
        Assert.assertSame((Object)appCl, (Object)manager.getClassLoader("org/example/test"));
        Assert.assertSame((Object)appCl, (Object)manager.getClassLoader("/org/example/test"));
        Assert.assertSame((Object)serverCl, (Object)manager.getClassLoader("/org/apache/cayenne/access/DataContext.class"));
        Assert.assertSame((Object)diCl, (Object)manager.getClassLoader("/org/apache/cayenne/di/Injector.class"));
        Assert.assertSame((Object)diCl, (Object)manager.getClassLoader("org/apache/cayenne/di/Injector.class"));
    }
}

