/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.util.ArrayList;
import org.apache.cayenne.access.types.DefaultValueObjectTypeRegistry;
import org.apache.cayenne.access.types.ValueObjectType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class DefaultValueObjectTypeRegistryTest {
    DefaultValueObjectTypeRegistry registry;
    ValueObjectType valueObjectType1;
    ValueObjectType valueObjectType2;

    @Before
    public void setUpRegistry() {
        this.valueObjectType1 = (ValueObjectType)Mockito.mock(ValueObjectType.class);
        Mockito.when(this.valueObjectType1.getValueType()).thenReturn(Integer.class);
        Mockito.when(this.valueObjectType1.getTargetType()).thenReturn(Integer.class);
        this.valueObjectType2 = (ValueObjectType)Mockito.mock(ValueObjectType.class);
        Mockito.when(this.valueObjectType2.getValueType()).thenReturn(Number.class);
        Mockito.when(this.valueObjectType2.getTargetType()).thenReturn(Integer.class);
        ArrayList list = new ArrayList();
        list.add(this.valueObjectType1);
        list.add(this.valueObjectType2);
        this.registry = new DefaultValueObjectTypeRegistry(list);
    }

    @Test
    public void testInitialState() {
        Assert.assertEquals((long)2L, (long)this.registry.typeCache.size());
        Assert.assertTrue((boolean)this.registry.typeCache.containsKey(Integer.class.getName()));
        Assert.assertTrue((boolean)this.registry.typeCache.containsKey(Number.class.getName()));
        Assert.assertFalse((boolean)this.registry.typeCache.containsKey(String.class.getName()));
        Assert.assertFalse((boolean)this.registry.typeCache.containsKey(Float.class.getName()));
    }

    @Test
    public void getValueType() throws Exception {
        ValueObjectType<Object, ?> valueObjectType = this.registry.getValueType(Integer.class);
        Assert.assertSame((Object)this.valueObjectType1, valueObjectType);
        valueObjectType = this.registry.getValueType(Float.class);
        Assert.assertSame((Object)this.valueObjectType2, valueObjectType);
        valueObjectType = this.registry.getValueType(String.class);
        Assert.assertNull(valueObjectType);
        Assert.assertEquals((long)4L, (long)this.registry.typeCache.size());
        Assert.assertTrue((boolean)this.registry.typeCache.containsKey(String.class.getName()));
        Assert.assertTrue((boolean)this.registry.typeCache.containsKey(Float.class.getName()));
    }
}

