/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.dbsync;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.dbsync.BaseSchemaUpdateStrategy;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseSchemaUpdateStrategy_ConcurrencyTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseSchemaUpdateStrategy_ConcurrencyTest.class);
    private ExecutorService threadPool;
    private DataNode dataNode;

    @Before
    public void before() {
        this.threadPool = Executors.newFixedThreadPool(2);
        this.dataNode = (DataNode)Mockito.mock(DataNode.class);
    }

    @After
    public void after() {
        this.threadPool.shutdownNow();
    }

    @Test
    public void testUpdateSchema_Concurrency() throws InterruptedException, ExecutionException, TimeoutException {
        final AtomicInteger counter = new AtomicInteger();
        final AtomicBoolean errors = new AtomicBoolean(false);
        final BaseSchemaUpdateStrategy strategy = new BaseSchemaUpdateStrategy(){

            @Override
            protected void processSchemaUpdate(DataNode dataNode) throws SQLException {
                counter.incrementAndGet();
            }
        };
        ArrayList tasks = new ArrayList();
        for (int i = 0; i < 20; ++i) {
            tasks.add(this.threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        strategy.updateSchema(BaseSchemaUpdateStrategy_ConcurrencyTest.this.dataNode);
                    }
                    catch (Throwable e) {
                        LOGGER.error("error in test", e);
                        errors.set(true);
                    }
                }
            }));
        }
        for (Future future : tasks) {
            future.get(1L, TimeUnit.SECONDS);
        }
        Assert.assertFalse((boolean)errors.get());
        Assert.assertEquals((long)1L, (long)counter.get());
    }
}

