/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.FluentSelect;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.SortOrder;

public class ColumnSelect<T>
extends FluentSelect<T> {
    private Collection<Property<?>> columns;
    private boolean havingExpressionIsActive = false;
    boolean singleColumn = true;
    private Expression having;
    boolean distinct;
    boolean suppressDistinct;

    protected ColumnSelect() {
    }

    protected ColumnSelect(ObjectSelect<T> select) {
        this.name = select.name;
        this.entityType = select.entityType;
        this.entityName = select.entityName;
        this.dbEntityName = select.dbEntityName;
        this.where = select.where;
        this.orderings = select.orderings;
        this.prefetches = select.prefetches;
        this.limit = select.limit;
        this.offset = select.offset;
        this.pageSize = select.pageSize;
        this.statementFetchSize = select.statementFetchSize;
        this.cacheStrategy = select.cacheStrategy;
        this.cacheGroup = select.cacheGroup;
    }

    @Override
    protected Query createReplacementQuery(EntityResolver resolver) {
        SelectQuery replacement = (SelectQuery)super.createReplacementQuery(resolver);
        replacement.setColumns(this.columns);
        replacement.setHavingQualifier(this.having);
        replacement.setCanReturnScalarValue(this.singleColumn);
        replacement.setDistinct(this.distinct);
        replacement.setSuppressDistinct(this.suppressDistinct);
        return replacement;
    }

    public ColumnSelect<T> entityType(Class<?> entityType) {
        return this.resetEntity(entityType, null, null);
    }

    public ColumnSelect<T> entityName(String entityName) {
        return this.resetEntity(null, entityName, null);
    }

    public ColumnSelect<T> dbEntityName(String dbEntityName) {
        return this.resetEntity(null, null, dbEntityName);
    }

    private ColumnSelect<T> resetEntity(Class<?> entityType, String entityName, String dbEntityName) {
        this.entityType = entityType;
        this.entityName = entityName;
        this.dbEntityName = dbEntityName;
        return this;
    }

    public ColumnSelect<T> where(Expression expression) {
        return this.and(expression);
    }

    public ColumnSelect<T> where(String expressionString, Object ... parameters) {
        return this.and(ExpressionFactory.exp(expressionString, parameters));
    }

    public ColumnSelect<T> and(Expression ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this;
        }
        return this.and(Arrays.asList(expressions));
    }

    public ColumnSelect<T> or(Expression ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this;
        }
        return this.or(Arrays.asList(expressions));
    }

    public ColumnSelect<T> orderBy(String property) {
        return this.orderBy(new Ordering(property));
    }

    public ColumnSelect<T> orderBy(String property, SortOrder sortOrder) {
        return this.orderBy(new Ordering(property, sortOrder));
    }

    public ColumnSelect<T> orderBy(Ordering ... orderings) {
        if (orderings == null) {
            return this;
        }
        if (this.orderings == null) {
            this.orderings = new ArrayList(orderings.length);
        }
        Collections.addAll(this.orderings, orderings);
        return this;
    }

    public ColumnSelect<T> orderBy(Collection<Ordering> orderings) {
        if (orderings == null) {
            return this;
        }
        if (this.orderings == null) {
            this.orderings = new ArrayList(orderings.size());
        }
        this.orderings.addAll(orderings);
        return this;
    }

    public ColumnSelect<T> prefetch(PrefetchTreeNode prefetch) {
        if (prefetch == null) {
            return this;
        }
        if (this.prefetches == null) {
            this.prefetches = new PrefetchTreeNode();
        }
        this.prefetches.merge(prefetch);
        return this;
    }

    public ColumnSelect<T> prefetch(String path, int semantics) {
        if (path == null) {
            return this;
        }
        if (this.prefetches == null) {
            this.prefetches = new PrefetchTreeNode();
        }
        this.prefetches.addPath(path).setSemantics(semantics);
        return this;
    }

    public ColumnSelect<T> limit(int fetchLimit) {
        if (this.limit != fetchLimit) {
            this.limit = fetchLimit;
            this.replacementQuery = null;
        }
        return this;
    }

    public ColumnSelect<T> offset(int fetchOffset) {
        if (this.offset != fetchOffset) {
            this.offset = fetchOffset;
            this.replacementQuery = null;
        }
        return this;
    }

    public ColumnSelect<T> pageSize(int pageSize) {
        if (this.pageSize != pageSize) {
            this.pageSize = pageSize;
            this.replacementQuery = null;
        }
        return this;
    }

    public ColumnSelect<T> statementFetchSize(int size) {
        if (this.statementFetchSize != size) {
            this.statementFetchSize = size;
            this.replacementQuery = null;
        }
        return this;
    }

    public ColumnSelect<T> cacheStrategy(QueryCacheStrategy strategy) {
        if (this.cacheStrategy != strategy) {
            this.cacheStrategy = strategy;
            this.replacementQuery = null;
        }
        if (this.cacheGroup != null) {
            this.cacheGroup = null;
            this.replacementQuery = null;
        }
        return this;
    }

    public ColumnSelect<T> cacheStrategy(QueryCacheStrategy strategy, String cacheGroup) {
        return this.cacheStrategy(strategy).cacheGroup(cacheGroup);
    }

    public ColumnSelect<T> cacheGroup(String cacheGroup) {
        this.cacheGroup = cacheGroup;
        this.replacementQuery = null;
        return this;
    }

    public ColumnSelect<T> localCache(String cacheGroup) {
        return this.cacheStrategy(QueryCacheStrategy.LOCAL_CACHE, cacheGroup);
    }

    public ColumnSelect<T> localCache() {
        return this.cacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
    }

    public ColumnSelect<T> sharedCache(String cacheGroup) {
        return this.cacheStrategy(QueryCacheStrategy.SHARED_CACHE, cacheGroup);
    }

    public ColumnSelect<T> sharedCache() {
        return this.cacheStrategy(QueryCacheStrategy.SHARED_CACHE);
    }

    public ColumnSelect<Object[]> columns(Property<?> firstProperty, Property<?> ... otherProperties) {
        if (this.columns == null) {
            this.columns = new ArrayList(otherProperties.length + 1);
        }
        this.columns.add(firstProperty);
        Collections.addAll(this.columns, otherProperties);
        this.singleColumn = false;
        return this;
    }

    public ColumnSelect<Object[]> columns(Collection<Property<?>> properties) {
        if (properties == null) {
            throw new NullPointerException("properties is null");
        }
        if (properties.isEmpty()) {
            throw new IllegalArgumentException("properties must contain at least one element");
        }
        if (this.columns == null) {
            this.columns = new ArrayList(properties.size());
        }
        this.columns.addAll(properties);
        this.singleColumn = false;
        return this;
    }

    protected <E> ColumnSelect<E> column(Property<E> property) {
        if (this.columns == null) {
            this.columns = new ArrayList(1);
        } else {
            this.columns.clear();
        }
        this.columns.add(property);
        return this;
    }

    public ColumnSelect<Object[]> count() {
        return this.columns(Property.COUNT, new Property[0]);
    }

    public ColumnSelect<Object[]> count(Property<?> property) {
        return this.columns(property.count(), new Property[0]);
    }

    public ColumnSelect<Object[]> min(Property<?> property) {
        return this.columns(property.min(), new Property[0]);
    }

    public ColumnSelect<Object[]> max(Property<?> property) {
        return this.columns(property.max(), new Property[0]);
    }

    public ColumnSelect<Object[]> avg(Property<?> property) {
        return this.columns(property.avg(), new Property[0]);
    }

    public <E extends Number> ColumnSelect<Object[]> sum(Property<E> property) {
        return this.columns(property.sum(), new Property[0]);
    }

    public ColumnSelect<T> having(Expression expression) {
        this.havingExpressionIsActive = true;
        return this.and(expression);
    }

    public ColumnSelect<T> having(String expressionString, Object ... parameters) {
        this.havingExpressionIsActive = true;
        return this.and(ExpressionFactory.exp(expressionString, parameters));
    }

    public ColumnSelect<T> and(Collection<Expression> expressions) {
        Collection<Expression> all;
        if (expressions == null || expressions.isEmpty()) {
            return this;
        }
        Expression activeExpression = this.getActiveExpression();
        if (activeExpression != null) {
            all = new ArrayList<Expression>(expressions.size() + 1);
            all.add(activeExpression);
            all.addAll(expressions);
        } else {
            all = expressions;
        }
        this.setActiveExpression(ExpressionFactory.and(all));
        return this;
    }

    public ColumnSelect<T> or(Collection<Expression> expressions) {
        Collection<Expression> all;
        if (expressions == null || expressions.isEmpty()) {
            return this;
        }
        Expression activeExpression = this.getActiveExpression();
        if (activeExpression != null) {
            all = new ArrayList<Expression>(expressions.size() + 1);
            all.add(activeExpression);
            all.addAll(expressions);
        } else {
            all = expressions;
        }
        this.setActiveExpression(ExpressionFactory.or(all));
        return this;
    }

    public ColumnSelect<T> distinct() {
        this.suppressDistinct = false;
        this.distinct = true;
        return this;
    }

    public ColumnSelect<T> suppressDistinct() {
        this.suppressDistinct = true;
        this.distinct = false;
        return this;
    }

    private void setActiveExpression(Expression exp) {
        if (this.havingExpressionIsActive) {
            this.having = exp;
        } else {
            this.where = exp;
        }
    }

    private Expression getActiveExpression() {
        if (this.havingExpressionIsActive) {
            return this.having;
        }
        return this.where;
    }

    public Collection<Property<?>> getColumns() {
        return this.columns;
    }

    public Expression getHaving() {
        return this.having;
    }

    @Override
    public T selectFirst(ObjectContext context) {
        return context.selectFirst(this.limit(1));
    }
}

