/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ashwood;

import java.util.Arrays;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ashwood.WeightedAshwoodEntitySorter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-weighted-sort.xml")
public class WeightedAshwoodEntitySorterIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    EntityResolver resolver;

    @Before
    public void setUp() throws Exception {
        this.resolver = this.context.getEntityResolver();
    }

    @Test
    public void testSortDbEntities() {
        List<DbEntity> eSorted = Arrays.asList(this.resolver.getDbEntity("SORT_DEP"), this.resolver.getDbEntity("SORT_ROOT"));
        List<DbEntity> e1 = Arrays.asList(this.resolver.getDbEntity("SORT_ROOT"), this.resolver.getDbEntity("SORT_DEP"));
        List<DbEntity> e2 = Arrays.asList(this.resolver.getDbEntity("SORT_DEP"), this.resolver.getDbEntity("SORT_ROOT"));
        WeightedAshwoodEntitySorter sorter = new WeightedAshwoodEntitySorter();
        sorter.setEntityResolver(this.resolver);
        sorter.sortDbEntities(e1, false);
        Assert.assertEquals(eSorted, e1);
        sorter.sortDbEntities(e2, false);
        Assert.assertEquals(eSorted, e2);
    }
}

