/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.translator.DbAttributeBinding;
import org.apache.cayenne.access.translator.select.JoinStack;
import org.apache.cayenne.access.translator.select.OrderingTranslator;
import org.apache.cayenne.access.translator.select.QualifierTranslator;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.access.translator.select.SelectTranslator;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.exp.TraversalHelper;
import org.apache.cayenne.exp.parser.ASTAggregateFunctionCall;
import org.apache.cayenne.exp.parser.ASTDbPath;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.JoinType;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.PathComponent;
import org.apache.cayenne.query.PrefetchSelectQuery;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.util.EqualsBuilder;
import org.apache.cayenne.util.HashCodeBuilder;

public class DefaultSelectTranslator
extends QueryAssembler
implements SelectTranslator {
    protected static final int[] UNSUPPORTED_DISTINCT_TYPES = new int[]{2004, 2005, 2011, -4, -1, -16};
    JoinStack joinStack;
    List<ColumnDescriptor> resultColumns;
    Map<ObjAttribute, ColumnDescriptor> attributeOverrides;
    Map<ColumnDescriptor, ObjAttribute> defaultAttributesByColumn;
    boolean suppressingDistinct;
    boolean forcingDistinct;
    boolean haveAggregate;
    Map<ColumnDescriptor, List<DbAttributeBinding>> groupByColumns;
    AddJoinListener joinListener;

    protected static boolean isUnsupportedForDistinct(int type) {
        for (int unsupportedDistinctType : UNSUPPORTED_DISTINCT_TYPES) {
            if (unsupportedDistinctType != type) continue;
            return true;
        }
        return false;
    }

    public DefaultSelectTranslator(Query query, DbAdapter adapter, EntityResolver entityResolver) {
        super(query, adapter, entityResolver);
    }

    protected JoinStack getJoinStack() {
        if (this.joinStack == null) {
            this.joinStack = this.createJoinStack();
        }
        return this.joinStack;
    }

    protected JoinStack createJoinStack() {
        return new JoinStack(this.getAdapter(), this);
    }

    @Override
    protected void doTranslate() {
        DataMap dataMap = this.queryMetadata.getDataMap();
        JoinStack joins = this.getJoinStack();
        QuotingStrategy strategy = this.getAdapter().getQuotingStrategy();
        this.forcingDistinct = false;
        this.resultColumns = this.buildResultColumns();
        QualifierTranslator qualifierTranslator = this.adapter.getQualifierTranslator(this);
        StringBuilder whereQualifierBuffer = qualifierTranslator.appendPart(new StringBuilder());
        Expression havingQualifier = ((SelectQuery)this.query).getHavingQualifier();
        StringBuilder havingQualifierBuffer = null;
        if (havingQualifier != null) {
            this.haveAggregate = true;
            QualifierTranslator havingQualifierTranslator = this.adapter.getQualifierTranslator(this);
            havingQualifierTranslator.setQualifier(havingQualifier);
            havingQualifierBuffer = havingQualifierTranslator.appendPart(new StringBuilder());
        }
        if (!this.haveAggregate && this.groupByColumns != null) {
            this.groupByColumns.clear();
        }
        OrderingTranslator orderingTranslator = new OrderingTranslator(this);
        StringBuilder orderingBuffer = orderingTranslator.appendPart(new StringBuilder());
        StringBuilder queryBuf = new StringBuilder();
        queryBuf.append("SELECT ");
        if (this.forcingDistinct || this.getSelectQuery().isDistinct()) {
            this.suppressingDistinct = this.queryMetadata.isSuppressingDistinct();
            if (!this.suppressingDistinct) {
                for (ColumnDescriptor columnDescriptor : this.resultColumns) {
                    if (!DefaultSelectTranslator.isUnsupportedForDistinct(columnDescriptor.getJdbcType())) continue;
                    this.suppressingDistinct = true;
                    break;
                }
            }
            if (!this.suppressingDistinct) {
                queryBuf.append(this.buildDistinctStatement()).append(" ");
            }
        }
        ArrayList<String> selectColumnExpList = new ArrayList<String>();
        for (ColumnDescriptor column : this.resultColumns) {
            String fullName = column.isExpression() ? column.getName() : strategy.quotedIdentifier(dataMap, column.getNamePrefix(), column.getName());
            selectColumnExpList.add(fullName);
        }
        if (this.forcingDistinct || this.getSelectQuery().isDistinct()) {
            List<String> list = orderingTranslator.getOrderByColumnList();
            for (String orderByColumnExp : list) {
                if (selectColumnExpList.contains(orderByColumnExp)) continue;
                selectColumnExpList.add(orderByColumnExp);
            }
        }
        this.appendSelectColumns(queryBuf, selectColumnExpList);
        queryBuf.append(" FROM ");
        joins.appendRootWithQuoteSqlIdentifiers(queryBuf, this.getQueryMetadata().getDbEntity());
        joins.appendJoins(queryBuf);
        joins.appendQualifier(whereQualifierBuffer, whereQualifierBuffer.length() == 0);
        if (whereQualifierBuffer.length() > 0) {
            queryBuf.append(" WHERE ");
            queryBuf.append((CharSequence)whereQualifierBuffer);
        }
        if (this.groupByColumns != null && !this.groupByColumns.isEmpty()) {
            queryBuf.append(" GROUP BY ");
            this.appendGroupByColumns(queryBuf, this.groupByColumns);
        }
        if (havingQualifierBuffer != null && havingQualifierBuffer.length() > 0) {
            queryBuf.append(" HAVING ");
            queryBuf.append((CharSequence)havingQualifierBuffer);
        }
        if (orderingBuffer.length() > 0) {
            queryBuf.append(" ORDER BY ").append((CharSequence)orderingBuffer);
        }
        if (!this.isSuppressingDistinct()) {
            this.appendLimitAndOffsetClauses(queryBuf);
        }
        this.sql = queryBuf.toString();
    }

    protected String buildDistinctStatement() {
        return "DISTINCT";
    }

    protected void appendSelectColumns(StringBuilder buffer, List<String> selectColumnExpList) {
        int columnCount = selectColumnExpList.size();
        buffer.append(selectColumnExpList.get(0));
        for (int i = 1; i < columnCount; ++i) {
            buffer.append(", ");
            buffer.append(selectColumnExpList.get(i));
        }
    }

    protected void appendGroupByColumns(StringBuilder buffer, Map<ColumnDescriptor, List<DbAttributeBinding>> groupByColumns) {
        Iterator<Map.Entry<ColumnDescriptor, List<DbAttributeBinding>>> it = groupByColumns.entrySet().iterator();
        Map.Entry<ColumnDescriptor, List<DbAttributeBinding>> entry = it.next();
        this.appendGroupByColumn(buffer, entry);
        while (it.hasNext()) {
            entry = it.next();
            buffer.append(", ");
            this.appendGroupByColumn(buffer, entry);
        }
    }

    protected void appendGroupByColumn(StringBuilder buffer, Map.Entry<ColumnDescriptor, List<DbAttributeBinding>> entry) {
        String fullName;
        if (entry.getKey().isExpression()) {
            fullName = entry.getKey().getDataRowKey();
        } else {
            QuotingStrategy strategy = this.getAdapter().getQuotingStrategy();
            fullName = strategy.quotedIdentifier(this.queryMetadata.getDataMap(), entry.getKey().getNamePrefix(), entry.getKey().getName());
        }
        buffer.append(fullName);
        if (entry.getKey().getDataRowKey().equals(entry.getKey().getName())) {
            for (DbAttributeBinding binding : entry.getValue()) {
                this.addToParamList(binding.getAttribute(), binding.getValue());
            }
        }
    }

    protected void appendLimitAndOffsetClauses(StringBuilder buffer) {
    }

    @Override
    public String getCurrentAlias() {
        return this.getJoinStack().getCurrentAlias();
    }

    @Override
    public ColumnDescriptor[] getResultColumns() {
        if (this.resultColumns == null || this.resultColumns.isEmpty()) {
            return new ColumnDescriptor[0];
        }
        return this.resultColumns.toArray(new ColumnDescriptor[this.resultColumns.size()]);
    }

    @Override
    public Map<ObjAttribute, ColumnDescriptor> getAttributeOverrides() {
        if (this.attributeOverrides != null) {
            return this.attributeOverrides;
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean isSuppressingDistinct() {
        return this.suppressingDistinct;
    }

    private SelectQuery<?> getSelectQuery() {
        return (SelectQuery)this.getQuery();
    }

    protected List<ColumnDescriptor> buildResultColumns() {
        this.defaultAttributesByColumn = new HashMap<ColumnDescriptor, ObjAttribute>();
        ArrayList<ColumnDescriptor> columns = new ArrayList<ColumnDescriptor>();
        SelectQuery<?> query = this.getSelectQuery();
        if (query.getColumns() != null && !query.getColumns().isEmpty()) {
            this.appendOverriddenColumns(columns, query);
        } else if (query.getRoot() instanceof DbEntity) {
            this.appendDbEntityColumns(columns, query);
        } else if (this.getQueryMetadata().getPageSize() > 0) {
            this.appendIdColumns(columns, this.queryMetadata.getClassDescriptor().getEntity());
        } else {
            this.appendQueryColumns(columns, query, this.queryMetadata.getClassDescriptor(), null);
        }
        return columns;
    }

    <T> List<ColumnDescriptor> appendOverriddenColumns(List<ColumnDescriptor> columns, SelectQuery<T> query) {
        this.groupByColumns = new HashMap<ColumnDescriptor, List<DbAttributeBinding>>();
        QualifierTranslator qualifierTranslator = this.adapter.getQualifierTranslator(this);
        AccumulatingBindingListener bindingListener = new AccumulatingBindingListener();
        final String[] joinTableAliasForProperty = new String[]{null};
        this.joinListener = new AddJoinListener(){

            @Override
            public void joinAdded() {
                joinTableAliasForProperty[0] = DefaultSelectTranslator.this.getCurrentAlias();
            }
        };
        this.setAddBindingListener(bindingListener);
        for (Property<?> property : query.getColumns()) {
            int expressionType = property.getExpression().getType();
            if ((expressionType == 26 || expressionType == 27) && (Collection.class.isAssignableFrom(property.getType()) || Map.class.isAssignableFrom(property.getType()))) {
                throw new CayenneRuntimeException("Can't directly select toMany relationship columns. Either select it with aggregate functions like count() or with flat() function to select full related objects.", new Object[0]);
            }
            boolean objectProperty = expressionType == 47 || expressionType == 26 && Persistent.class.isAssignableFrom(property.getType());
            qualifierTranslator.setQualifier(property.getExpression());
            qualifierTranslator.setForceJoinForRelations(objectProperty);
            StringBuilder builder = qualifierTranslator.appendPart(new StringBuilder());
            if (objectProperty) {
                ArrayList<ColumnDescriptor> classColumns = new ArrayList<ColumnDescriptor>();
                ObjEntity entity = this.entityResolver.getObjEntity(property.getType());
                if (this.getQueryMetadata().getPageSize() > 0) {
                    this.appendIdColumns(classColumns, entity);
                } else {
                    ClassDescriptor classDescriptor = this.entityResolver.getClassDescriptor(entity.getName());
                    this.appendQueryColumns(classColumns, query, classDescriptor, joinTableAliasForProperty[0]);
                }
                for (ColumnDescriptor descriptor : classColumns) {
                    columns.add(descriptor);
                    this.groupByColumns.put(descriptor, Collections.emptyList());
                }
                continue;
            }
            String alias = property.getAlias();
            if (alias != null) {
                builder.append(" AS ").append(alias);
            }
            int type = this.getJdbcTypeForProperty(property);
            ColumnDescriptor descriptor = new ColumnDescriptor(builder.toString(), type, property.getType().getName());
            descriptor.setDataRowKey(alias);
            descriptor.setIsExpression(true);
            columns.add(descriptor);
            if (this.isAggregate(property)) {
                this.haveAggregate = true;
            } else {
                this.groupByColumns.put(descriptor, bindingListener.getBindings());
            }
            bindingListener.reset();
        }
        this.setAddBindingListener(null);
        qualifierTranslator.setForceJoinForRelations(false);
        this.joinListener = null;
        return columns;
    }

    private int getJdbcTypeForProperty(Property<?> property) {
        block4: {
            int expressionType;
            block3: {
                expressionType = property.getExpression().getType();
                if (expressionType != 26) break block3;
                for (PathComponent<ObjAttribute, ObjRelationship> component : this.getQueryMetadata().getObjEntity().resolvePath(property.getExpression(), this.getPathAliases())) {
                    if (component.getAttribute() == null) continue;
                    Iterator<CayenneMapEntry> dbPathIterator = component.getAttribute().getDbPathIterator();
                    while (dbPathIterator.hasNext()) {
                        CayenneMapEntry pathPart = dbPathIterator.next();
                        if (!(pathPart instanceof DbAttribute)) continue;
                        return ((DbAttribute)pathPart).getType();
                    }
                }
                break block4;
            }
            if (expressionType != 27) break block4;
            for (PathComponent<DbAttribute, DbRelationship> component : this.getQueryMetadata().getDbEntity().resolvePath(property.getExpression(), this.getPathAliases())) {
                if (component.getAttribute() == null) continue;
                return component.getAttribute().getType();
            }
        }
        return TypesMapping.getSqlTypeByJava(property.getType());
    }

    private boolean isAggregate(Property<?> property) {
        final boolean[] isAggregate = new boolean[1];
        Expression exp = property.getExpression();
        exp.traverse(new TraversalHelper(){

            @Override
            public void startNode(Expression node, Expression parentNode) {
                if (node instanceof ASTAggregateFunctionCall) {
                    isAggregate[0] = true;
                }
            }
        });
        return isAggregate[0];
    }

    <T> List<ColumnDescriptor> appendDbEntityColumns(List<ColumnDescriptor> columns, SelectQuery<T> query) {
        HashSet<ColumnTracker> attributes = new HashSet<ColumnTracker>();
        DbEntity table = this.getQueryMetadata().getDbEntity();
        for (DbAttribute dba : table.getAttributes()) {
            this.appendColumn(columns, null, dba, attributes, null);
        }
        return columns;
    }

    <T> List<ColumnDescriptor> appendQueryColumns(final List<ColumnDescriptor> columns, SelectQuery<T> query, ClassDescriptor descriptor, final String tableAlias) {
        final HashSet<ColumnTracker> attributes = new HashSet<ColumnTracker>();
        ObjEntity oe = descriptor.getEntity();
        PropertyVisitor visitor = new PropertyVisitor(){

            @Override
            public boolean visitAttribute(AttributeProperty property) {
                ObjAttribute oa = property.getAttribute();
                DefaultSelectTranslator.this.resetJoinStack();
                Iterator<CayenneMapEntry> dbPathIterator = oa.getDbPathIterator();
                while (dbPathIterator.hasNext()) {
                    CayenneMapEntry pathPart = dbPathIterator.next();
                    if (pathPart == null) {
                        throw new CayenneRuntimeException("ObjAttribute has no component: %s", oa.getName());
                    }
                    if (pathPart instanceof DbRelationship) {
                        DbRelationship rel = (DbRelationship)pathPart;
                        DefaultSelectTranslator.this.dbRelationshipAdded(rel, JoinType.LEFT_OUTER, null);
                        continue;
                    }
                    if (!(pathPart instanceof DbAttribute)) continue;
                    DbAttribute dbAttr = (DbAttribute)pathPart;
                    DefaultSelectTranslator.this.appendColumn(columns, oa, dbAttr, attributes, null, tableAlias);
                }
                return true;
            }

            @Override
            public boolean visitToMany(ToManyProperty property) {
                this.visitRelationship(property);
                return true;
            }

            @Override
            public boolean visitToOne(ToOneProperty property) {
                this.visitRelationship(property);
                return true;
            }

            private void visitRelationship(ArcProperty property) {
                DefaultSelectTranslator.this.resetJoinStack();
                ObjRelationship rel = property.getRelationship();
                DbRelationship dbRel = rel.getDbRelationships().get(0);
                List<DbJoin> joins = dbRel.getJoins();
                for (DbJoin join : joins) {
                    DbAttribute src = join.getSource();
                    DefaultSelectTranslator.this.appendColumn(columns, null, src, attributes, null, tableAlias);
                }
            }
        };
        descriptor.visitAllProperties(visitor);
        this.resetJoinStack();
        DbEntity table = oe.getDbEntity();
        for (DbAttribute dba : table.getPrimaryKeys()) {
            this.appendColumn(columns, null, dba, attributes, null, tableAlias);
        }
        if (query instanceof PrefetchSelectQuery) {
            for (String path : ((PrefetchSelectQuery)query).getResultPaths()) {
                DbRelationship relationship;
                ASTDbPath pathExp = (ASTDbPath)oe.translateToDbPath(ExpressionFactory.exp(path, new Object[0]));
                this.resetJoinStack();
                PathComponent<DbAttribute, DbRelationship> lastComponent = null;
                for (PathComponent<DbAttribute, DbRelationship> component : table.resolvePath(pathExp, this.getPathAliases())) {
                    if (component.getRelationship() != null) {
                        this.getJoinStack().pushJoin(component.getRelationship(), component.getJoinType(), null);
                    }
                    lastComponent = component;
                }
                if (lastComponent == null || (relationship = (DbRelationship)lastComponent.getRelationship()) == null) continue;
                String labelPrefix = pathExp.getPath();
                DbEntity dbEntity = relationship.getTargetEntity();
                for (DbAttribute dbAttribute : dbEntity.getPrimaryKeys()) {
                    this.appendColumn(columns, null, dbAttribute, attributes, (String)labelPrefix + '.' + dbAttribute.getName());
                }
            }
        }
        if (query.getPrefetchTree() != null) {
            for (PrefetchTreeNode prefetch : query.getPrefetchTree().getChildren()) {
                prefetch.setEntityName(oe.getName());
            }
            for (PrefetchTreeNode prefetch : query.getPrefetchTree().adjacentJointNodes()) {
                Expression prefetchExp = ExpressionFactory.exp(prefetch.getPath(), new Object[0]);
                ASTDbPath dbPrefetch = (ASTDbPath)oe.translateToDbPath(prefetchExp);
                this.resetJoinStack();
                DbRelationship r = null;
                for (PathComponent pathComponent : table.resolvePath(dbPrefetch, this.getPathAliases())) {
                    r = (DbRelationship)pathComponent.getRelationship();
                    this.dbRelationshipAdded(r, JoinType.LEFT_OUTER, null);
                }
                if (r == null) {
                    throw new CayenneRuntimeException("Invalid joint prefetch '%s' for entity: %s", prefetch, oe.getName());
                }
                ObjRelationship targetRel = (ObjRelationship)prefetchExp.evaluate(oe);
                ObjEntity objEntity = targetRel.getTargetEntity();
                String labelPrefix = dbPrefetch.getPath();
                for (ObjAttribute oa : objEntity.getAttributes()) {
                    Iterator<CayenneMapEntry> dbPathIterator = oa.getDbPathIterator();
                    while (dbPathIterator.hasNext()) {
                        CayenneMapEntry pathPart = dbPathIterator.next();
                        if (pathPart == null) {
                            throw new CayenneRuntimeException("ObjAttribute has no component: %s", oa.getName());
                        }
                        if (pathPart instanceof DbRelationship) {
                            DbRelationship rel = (DbRelationship)pathPart;
                            this.dbRelationshipAdded(rel, JoinType.INNER, null);
                            continue;
                        }
                        if (!(pathPart instanceof DbAttribute)) continue;
                        DbAttribute attribute = (DbAttribute)pathPart;
                        this.appendColumn(columns, oa, attribute, attributes, labelPrefix + '.' + attribute.getName());
                    }
                }
                DbEntity dbEntity = r.getTargetEntity();
                for (DbAttribute attribute : dbEntity.getAttributes()) {
                    this.appendColumn(columns, null, attribute, attributes, labelPrefix + '.' + attribute.getName());
                }
            }
        }
        return columns;
    }

    <T> List<ColumnDescriptor> appendIdColumns(List<ColumnDescriptor> columns, ObjEntity objEntity) {
        HashSet<ColumnTracker> skipSet = new HashSet<ColumnTracker>();
        DbEntity dbEntity = objEntity.getDbEntity();
        for (ObjAttribute attribute : objEntity.getPrimaryKeys()) {
            DbAttribute dbAttribute = dbEntity.getAttribute(attribute.getDbAttributeName());
            this.appendColumn(columns, attribute, dbAttribute, skipSet, null);
        }
        return columns;
    }

    private void appendColumn(List<ColumnDescriptor> columns, ObjAttribute objAttribute, DbAttribute attribute, Set<ColumnTracker> skipSet, String label) {
        this.appendColumn(columns, objAttribute, attribute, skipSet, label, null);
    }

    private void appendColumn(List<ColumnDescriptor> columns, ObjAttribute objAttribute, DbAttribute attribute, Set<ColumnTracker> skipSet, String label, String alias) {
        if (alias == null) {
            alias = this.getCurrentAlias();
        }
        if (skipSet.add(new ColumnTracker(alias, attribute))) {
            ColumnDescriptor column;
            ColumnDescriptor columnDescriptor = column = objAttribute != null ? new ColumnDescriptor(objAttribute, attribute, alias) : new ColumnDescriptor(attribute, alias);
            if (label != null) {
                column.setDataRowKey(label);
            }
            columns.add(column);
            this.defaultAttributesByColumn.put(column, objAttribute);
        } else if (objAttribute != null) {
            for (ColumnDescriptor column : columns) {
                ObjAttribute original;
                if (!attribute.getName().equals(column.getName())) continue;
                if (this.attributeOverrides == null) {
                    this.attributeOverrides = new HashMap<ObjAttribute, ColumnDescriptor>();
                }
                if ((original = this.defaultAttributesByColumn.remove(column)) != null) {
                    this.attributeOverrides.put(original, column);
                }
                this.attributeOverrides.put(objAttribute, column);
                column.setJavaClass(Void.TYPE.getName());
                break;
            }
        }
    }

    @Override
    public void resetJoinStack() {
        this.getJoinStack().resetStack();
    }

    @Override
    public void dbRelationshipAdded(DbRelationship relationship, JoinType joinType, String joinSplitAlias) {
        if (relationship.isToMany()) {
            this.forcingDistinct = true;
        }
        this.getJoinStack().pushJoin(relationship, joinType, joinSplitAlias);
        if (this.joinListener != null) {
            this.joinListener.joinAdded();
        }
    }

    @Override
    public boolean supportsTableAliases() {
        return true;
    }

    @Override
    public String getAliasForExpression(Expression exp) {
        Collection<Property<?>> columns = ((SelectQuery)this.query).getColumns();
        if (columns == null) {
            return null;
        }
        for (Property<?> property : columns) {
            if (!property.getExpression().equals(exp)) continue;
            return property.getAlias();
        }
        return null;
    }

    @Override
    public boolean hasJoins() {
        return this.joinStack != null && this.joinStack.size() > 0;
    }

    static interface AddJoinListener {
        public void joinAdded();
    }

    static final class AccumulatingBindingListener
    implements QueryAssembler.AddBindingListener {
        private List<DbAttributeBinding> bindings = new ArrayList<DbAttributeBinding>();

        AccumulatingBindingListener() {
        }

        @Override
        public void onAdd(DbAttributeBinding binding) {
            this.bindings.add(binding);
        }

        public void reset() {
            this.bindings.clear();
        }

        public List<DbAttributeBinding> getBindings() {
            return new ArrayList<DbAttributeBinding>(this.bindings);
        }
    }

    static final class ColumnTracker {
        private DbAttribute attribute;
        private String alias;

        ColumnTracker(String alias, DbAttribute attribute) {
            this.attribute = attribute;
            this.alias = alias;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ColumnTracker)) {
                return false;
            }
            ColumnTracker other = (ColumnTracker)object;
            return new EqualsBuilder().append(this.alias, other.alias).append(this.attribute, other.attribute).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(31, 5).append(this.alias).append(this.attribute).toHashCode();
        }
    }
}

