/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import com.mockrunner.jdbc.PreparedStatementResultSetHandler;
import com.mockrunner.mock.jdbc.MockConnection;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.MockOperationObserver;
import org.apache.cayenne.access.OptimisticLockException;
import org.apache.cayenne.access.jdbc.BatchAction;
import org.apache.cayenne.access.jdbc.reader.RowReaderFactory;
import org.apache.cayenne.access.translator.batch.DeleteBatchTranslator;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.DeleteBatchQuery;
import org.apache.cayenne.testdo.locking.SimpleLockingTestEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

@UseServerRuntime(value="cayenne-locking.xml")
public class BatchActionLockingIT
extends ServerCase {
    @Inject
    protected ServerRuntime runtime;
    @Inject
    private Injector injector;
    @Inject
    private AdhocObjectFactory objectFactory;

    @Test
    public void testRunAsIndividualQueriesSuccess() throws Exception {
        EntityResolver resolver = this.runtime.getDataDomain().getEntityResolver();
        JdbcAdapter adapter = this.buildAdapter(true);
        DbEntity dbEntity = resolver.getObjEntity(SimpleLockingTestEntity.class).getDbEntity();
        List<DbAttribute> qualifierAttributes = Arrays.asList(dbEntity.getAttribute("LOCKING_TEST_ID"), dbEntity.getAttribute("NAME"));
        Set<String> nullAttributeNames = Collections.singleton("NAME");
        HashMap<String, Object> qualifierSnapshot = new HashMap<String, Object>();
        qualifierSnapshot.put("LOCKING_TEST_ID", new Integer(1));
        DeleteBatchQuery batchQuery = new DeleteBatchQuery(dbEntity, qualifierAttributes, nullAttributeNames, 5);
        batchQuery.setUsingOptimisticLocking(true);
        batchQuery.add(qualifierSnapshot);
        DeleteBatchTranslator batchQueryBuilder = new DeleteBatchTranslator(batchQuery, (DbAdapter)adapter, null);
        MockConnection mockConnection = new MockConnection();
        PreparedStatementResultSetHandler preparedStatementResultSetHandler = mockConnection.getPreparedStatementResultSetHandler();
        preparedStatementResultSetHandler.setExactMatch(false);
        preparedStatementResultSetHandler.setCaseSensitive(false);
        preparedStatementResultSetHandler.prepareUpdateCount("DELETE", 1);
        boolean generatesKeys = false;
        DataNode node = new DataNode();
        node.setAdapter(adapter);
        node.setEntityResolver(resolver);
        node.setRowReaderFactory((RowReaderFactory)Mockito.mock(RowReaderFactory.class));
        BatchAction action = new BatchAction(batchQuery, node, false);
        action.runAsIndividualQueries((Connection)mockConnection, batchQueryBuilder, new MockOperationObserver(), generatesKeys);
        Assert.assertEquals((long)0L, (long)mockConnection.getNumberCommits());
        Assert.assertEquals((long)0L, (long)mockConnection.getNumberRollbacks());
    }

    @Test
    public void testRunAsIndividualQueriesOptimisticLockingFailure() throws Exception {
        EntityResolver resolver = this.runtime.getDataDomain().getEntityResolver();
        JdbcAdapter adapter = this.buildAdapter(true);
        DbEntity dbEntity = resolver.getObjEntity(SimpleLockingTestEntity.class).getDbEntity();
        List<DbAttribute> qualifierAttributes = Arrays.asList(dbEntity.getAttribute("LOCKING_TEST_ID"), dbEntity.getAttribute("NAME"));
        Set<String> nullAttributeNames = Collections.singleton("NAME");
        HashMap<String, Object> qualifierSnapshot = new HashMap<String, Object>();
        qualifierSnapshot.put("LOCKING_TEST_ID", new Integer(1));
        DeleteBatchQuery batchQuery = new DeleteBatchQuery(dbEntity, qualifierAttributes, nullAttributeNames, 5);
        batchQuery.setUsingOptimisticLocking(true);
        batchQuery.add(qualifierSnapshot);
        DeleteBatchTranslator batchQueryBuilder = new DeleteBatchTranslator(batchQuery, (DbAdapter)adapter, null);
        MockConnection mockConnection = new MockConnection();
        PreparedStatementResultSetHandler preparedStatementResultSetHandler = mockConnection.getPreparedStatementResultSetHandler();
        preparedStatementResultSetHandler.setExactMatch(false);
        preparedStatementResultSetHandler.setCaseSensitive(false);
        preparedStatementResultSetHandler.prepareUpdateCount("DELETE", 0);
        boolean generatesKeys = false;
        DataNode node = new DataNode();
        node.setAdapter(adapter);
        node.setEntityResolver(resolver);
        node.setRowReaderFactory((RowReaderFactory)Mockito.mock(RowReaderFactory.class));
        BatchAction action = new BatchAction(batchQuery, node, false);
        try {
            action.runAsIndividualQueries((Connection)mockConnection, batchQueryBuilder, new MockOperationObserver(), generatesKeys);
            Assert.fail((String)"No OptimisticLockingFailureException thrown.");
        }
        catch (OptimisticLockException optimisticLockException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)mockConnection.getNumberCommits());
        Assert.assertEquals((long)0L, (long)mockConnection.getNumberRollbacks());
    }

    JdbcAdapter buildAdapter(boolean supportGeneratedKeys) {
        JdbcAdapter adapter = (JdbcAdapter)this.objectFactory.newInstance(JdbcAdapter.class, JdbcAdapter.class.getName());
        adapter.setSupportsGeneratedKeys(supportGeneratedKeys);
        this.injector.injectMembers((Object)adapter);
        return adapter;
    }
}

