/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.QueryEngine;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.tx.BaseTransaction;

public class MockQueryEngine
implements QueryEngine {
    protected Map results = new HashMap();
    protected EntityResolver entityResolver;
    protected int runCount;

    public MockQueryEngine() {
    }

    public MockQueryEngine(QueryEngine engine) {
        this(engine.getEntityResolver());
    }

    public MockQueryEngine(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public void reset() {
        this.runCount = 0;
        this.results.clear();
    }

    public int getRunCount() {
        return this.runCount;
    }

    public void addExpectedResult(Query query, List result) {
        this.results.put(query, result);
    }

    public void performQueries(Collection queries, OperationObserver resultConsumer, BaseTransaction transaction) {
        this.initWithPresetResults(queries, resultConsumer);
    }

    public void performQueries(Collection queries, OperationObserver resultConsumer) {
        this.initWithPresetResults(queries, resultConsumer);
    }

    private void initWithPresetResults(Collection queries, OperationObserver resultConsumer) {
        ++this.runCount;
        for (Query query : queries) {
            resultConsumer.nextRows(query, (List)this.results.get(query));
        }
    }

    public DataNode lookupDataNode(DataMap dataMap) {
        return null;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public Collection getDataMaps() {
        return this.entityResolver != null ? this.entityResolver.getDataMaps() : Collections.EMPTY_LIST;
    }
}

