/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.NullTestEntity;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextCommitIT
extends ServerCase {
    @Inject
    private DataContext context;

    @Test
    public void testFlushToParent_Commit_New() {
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("Test");
        Assert.assertTrue((boolean)this.context.hasChanges());
        ObjectId beforeId = a.getObjectId();
        GraphDiff diff = this.context.flushToParent(true);
        ObjectId afterId = a.getObjectId();
        Assert.assertNotNull((Object)diff);
        Assert.assertFalse((boolean)this.context.hasChanges());
        Assert.assertNotEquals((Object)beforeId, (Object)afterId);
        GraphChangeHandler diffChecker = (GraphChangeHandler)Mockito.mock(GraphChangeHandler.class);
        diff.apply(diffChecker);
        ((GraphChangeHandler)Mockito.verify((Object)diffChecker)).nodeIdChanged(beforeId, afterId);
        Mockito.verifyZeroInteractions((Object[])new Object[]{diffChecker});
    }

    @Test
    public void testFlushToParent_Commit_Mix() {
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("Test");
        this.context.flushToParent(true);
        Painting p = this.context.newObject(Painting.class);
        p.setPaintingTitle("PT");
        p.setToArtist(a);
        a.setArtistName("Test_");
        ObjectId beforeId = p.getObjectId();
        GraphDiff diff = this.context.flushToParent(true);
        ObjectId afterId = p.getObjectId();
        Assert.assertNotNull((Object)diff);
        Assert.assertFalse((boolean)this.context.hasChanges());
        GraphChangeHandler diffChecker = (GraphChangeHandler)Mockito.mock(GraphChangeHandler.class);
        diff.apply(diffChecker);
        ((GraphChangeHandler)Mockito.verify((Object)diffChecker)).nodeIdChanged(beforeId, afterId);
        Mockito.verifyZeroInteractions((Object[])new Object[]{diffChecker});
    }

    @Test
    public void testFlushToParent_NewNoAttributes() {
        this.context.newObject(NullTestEntity.class);
        Assert.assertTrue((boolean)this.context.hasChanges());
        GraphDiff diff3 = this.context.flushToParent(true);
        Assert.assertNotNull((Object)diff3);
        Assert.assertFalse((boolean)this.context.hasChanges());
    }
}

