/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.numeric_types.BigDecimalEntity;
import org.apache.cayenne.testdo.numeric_types.BigIntegerEntity;
import org.apache.cayenne.testdo.numeric_types.BitTestEntity;
import org.apache.cayenne.testdo.numeric_types.BooleanTestEntity;
import org.apache.cayenne.testdo.numeric_types.DecimalPKTest1;
import org.apache.cayenne.testdo.numeric_types.DecimalPKTestEntity;
import org.apache.cayenne.testdo.numeric_types.LongEntity;
import org.apache.cayenne.testdo.numeric_types.SmallintTestEntity;
import org.apache.cayenne.testdo.numeric_types.TinyintTestEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-numeric-types.xml")
public class NumericTypesIT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    protected DataContext context1;
    @Inject
    protected ServerRuntime runtime;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tSmallintTest;
    protected TableHelper tTinyintTest;

    @Before
    public void setUp() throws Exception {
        this.tSmallintTest = new TableHelper(this.dbHelper, "SMALLINT_TEST");
        this.tSmallintTest.setColumns(new String[]{"ID", "SMALLINT_COL"});
        this.tTinyintTest = new TableHelper(this.dbHelper, "TINYINT_TEST");
        this.tTinyintTest.setColumns(new String[]{"ID", "TINYINT_COL"});
    }

    protected void createShortDataSet() throws Exception {
        this.tSmallintTest.insert(new Object[]{1, 9999});
        this.tSmallintTest.insert(new Object[]{2, 3333});
    }

    protected void createTinyintDataSet() throws Exception {
        this.tTinyintTest.insert(new Object[]{1, 81});
        this.tTinyintTest.insert(new Object[]{2, 50});
    }

    @Test
    public void testLong() throws Exception {
        LongEntity test = this.context.newObject(LongEntity.class);
        Long i = 0x80000009L;
        test.setLongField(i);
        this.context.commitChanges();
        SelectQuery<LongEntity> q = new SelectQuery<LongEntity>(LongEntity.class);
        LongEntity testRead = (LongEntity)this.context.performQuery(q).get(0);
        Assert.assertNotNull((Object)testRead.getLongField());
        Assert.assertEquals((Object)i, (Object)testRead.getLongField());
        test.setLongField(null);
        this.context.commitChanges();
    }

    @Test
    public void testBigInteger() throws Exception {
        BigIntegerEntity test = this.context.newObject(BigIntegerEntity.class);
        BigInteger i = new BigInteger("1234567890");
        test.setBigIntegerField(i);
        this.context.commitChanges();
        SelectQuery<BigIntegerEntity> q = new SelectQuery<BigIntegerEntity>(BigIntegerEntity.class);
        BigIntegerEntity testRead = (BigIntegerEntity)this.context.performQuery(q).get(0);
        Assert.assertNotNull((Object)testRead.getBigIntegerField());
        Assert.assertEquals((Object)i, (Object)testRead.getBigIntegerField());
        test.setBigIntegerField(null);
        this.context.commitChanges();
    }

    @Test
    public void testBigDecimal() throws Exception {
        BigDecimalEntity test = this.context.newObject(BigDecimalEntity.class);
        BigDecimal i = new BigDecimal("1234567890.44");
        test.setBigDecimalField(i);
        this.context.commitChanges();
        SelectQuery<BigDecimalEntity> q = new SelectQuery<BigDecimalEntity>(BigDecimalEntity.class);
        BigDecimalEntity testRead = (BigDecimalEntity)this.context.performQuery(q).get(0);
        Assert.assertNotNull((Object)testRead.getBigDecimalField());
        Assert.assertEquals((Object)i, (Object)testRead.getBigDecimalField());
        test.setBigDecimalField(null);
        this.context.commitChanges();
    }

    @Test
    public void testShortInQualifier() throws Exception {
        this.createShortDataSet();
        Expression qual = ExpressionFactory.matchExp("smallintCol", (Object)new Short("9999"));
        List objects = this.context.performQuery(new SelectQuery<SmallintTestEntity>(SmallintTestEntity.class, qual));
        Assert.assertEquals((long)1L, (long)objects.size());
        SmallintTestEntity object = (SmallintTestEntity)objects.get(0);
        Assert.assertEquals((Object)new Short("9999"), (Object)object.getSmallintCol());
    }

    @Test
    public void testShortInInsert() throws Exception {
        SmallintTestEntity object = (SmallintTestEntity)this.context.newObject("SmallintTestEntity");
        object.setSmallintCol(new Short("1"));
        this.context.commitChanges();
    }

    @Test
    public void testTinyintInQualifier() throws Exception {
        this.createTinyintDataSet();
        Expression qual = ExpressionFactory.matchExp("tinyintCol", (Object)81);
        List objects = this.context.performQuery(new SelectQuery<TinyintTestEntity>(TinyintTestEntity.class, qual));
        Assert.assertEquals((long)1L, (long)objects.size());
        TinyintTestEntity object = (TinyintTestEntity)objects.get(0);
        Assert.assertEquals((Object)new Byte(81), (Object)object.getTinyintCol());
    }

    @Test
    public void testTinyintInInsert() throws Exception {
        TinyintTestEntity object = (TinyintTestEntity)this.context.newObject("TinyintTestEntity");
        object.setTinyintCol((byte)1);
        this.context.commitChanges();
    }

    @Test
    public void testBooleanBit() throws Exception {
        BitTestEntity trueObject = (BitTestEntity)this.context.newObject("BitTestEntity");
        trueObject.setBitColumn(Boolean.TRUE);
        BitTestEntity falseObject = (BitTestEntity)this.context.newObject("BitTestEntity");
        falseObject.setBitColumn(Boolean.FALSE);
        this.context.commitChanges();
        this.context.invalidateObjects(trueObject, falseObject);
        Expression trueQ = ExpressionFactory.matchExp("bitColumn", (Object)Boolean.TRUE);
        List trueResult = this.context1.performQuery(new SelectQuery<BitTestEntity>(BitTestEntity.class, trueQ));
        Assert.assertEquals((long)1L, (long)trueResult.size());
        BitTestEntity trueRefetched = (BitTestEntity)trueResult.get(0);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)trueRefetched.getBitColumn());
        Assert.assertNotSame((Object)trueRefetched, (Object)trueObject);
        Assert.assertSame((Object)Boolean.TRUE, (Object)trueRefetched.getBitColumn());
        Expression falseQ = ExpressionFactory.matchExp("bitColumn", (Object)Boolean.FALSE);
        List falseResult = this.context1.performQuery(new SelectQuery<BitTestEntity>(BitTestEntity.class, falseQ));
        Assert.assertEquals((long)1L, (long)falseResult.size());
        BitTestEntity falseRefetched = (BitTestEntity)falseResult.get(0);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)falseRefetched.getBitColumn());
        Assert.assertNotSame((Object)falseRefetched, (Object)falseObject);
        Assert.assertSame((Object)Boolean.FALSE, (Object)falseRefetched.getBitColumn());
    }

    @Test
    public void testBooleanBoolean() throws Exception {
        BooleanTestEntity trueObject = (BooleanTestEntity)this.context.newObject("BooleanTestEntity");
        trueObject.setBooleanColumn(Boolean.TRUE);
        BooleanTestEntity falseObject = (BooleanTestEntity)this.context.newObject("BooleanTestEntity");
        falseObject.setBooleanColumn(Boolean.FALSE);
        this.context.commitChanges();
        this.context.invalidateObjects(trueObject, falseObject);
        Expression trueQ = ExpressionFactory.matchExp("booleanColumn", (Object)Boolean.TRUE);
        List trueResult = this.context1.performQuery(new SelectQuery<BooleanTestEntity>(BooleanTestEntity.class, trueQ));
        Assert.assertEquals((long)1L, (long)trueResult.size());
        BooleanTestEntity trueRefetched = (BooleanTestEntity)trueResult.get(0);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)trueRefetched.getBooleanColumn());
        Assert.assertNotSame((Object)trueRefetched, (Object)trueObject);
        Assert.assertSame((Object)Boolean.TRUE, (Object)trueRefetched.getBooleanColumn());
        Expression falseQ = ExpressionFactory.matchExp("booleanColumn", (Object)Boolean.FALSE);
        List falseResult = this.context1.performQuery(new SelectQuery<BooleanTestEntity>(BooleanTestEntity.class, falseQ));
        Assert.assertEquals((long)1L, (long)falseResult.size());
        BooleanTestEntity falseRefetched = (BooleanTestEntity)falseResult.get(0);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)falseRefetched.getBooleanColumn());
        Assert.assertNotSame((Object)falseRefetched, (Object)falseObject);
        Assert.assertSame((Object)Boolean.FALSE, (Object)falseRefetched.getBooleanColumn());
    }

    @Test
    public void testDecimalPK() throws Exception {
        DecimalPKTestEntity object = this.context.newObject(DecimalPKTestEntity.class);
        object.setName("o1");
        object.setDecimalPK(new BigDecimal("1.25"));
        this.context.commitChanges();
        ObjectId syntheticId = new ObjectId("DecimalPKTestEntity", "DECIMAL_PK", new BigDecimal("1.25"));
        Assert.assertSame((Object)object, (Object)this.context.getGraphManager().getNode(syntheticId));
        this.context.deleteObjects(object);
        this.context.commitChanges();
    }

    @Test
    public void testDecimalPK1() throws Exception {
        DecimalPKTest1 object = this.context.newObject(DecimalPKTest1.class);
        object.setName("o2");
        object.setDecimalPK(1.25);
        this.context.commitChanges();
        ObjectId syntheticId = new ObjectId("DecimalPKTest1", "DECIMAL_PK", 1.25);
        Assert.assertSame((Object)object, (Object)this.context.getGraphManager().getNode(syntheticId));
    }

    @Test
    public void testBigIntegerColumnSelect() {
        BigIntegerEntity test = this.context.newObject(BigIntegerEntity.class);
        BigInteger i = new BigInteger("1234567890");
        test.setBigIntegerField(i);
        this.context.commitChanges();
        BigInteger readValue = (BigInteger)ObjectSelect.query(BigIntegerEntity.class).column(BigIntegerEntity.BIG_INTEGER_FIELD).selectOne(this.context);
        Assert.assertEquals((Object)i, (Object)readValue);
        Property<BigInteger> calculated = Property.create(ExpressionFactory.exp("bigIntegerField + 1", new Object[0]), BigInteger.class);
        BigInteger readValue2 = (BigInteger)ObjectSelect.query(BigIntegerEntity.class).column(calculated).selectOne(this.context);
        Assert.assertEquals((Object)i.add(BigInteger.ONE), (Object)readValue2);
    }
}

