/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.List;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-generic.xml")
public class GenericMappingIT
extends ServerCase {
    @Inject
    private DataContext context;

    @Test
    public void testInsertSingle() {
        DataObject g1 = (DataObject)this.context.newObject("Generic1");
        g1.writeProperty("name", "G1 Name");
        this.context.commitChanges();
    }

    @Test
    public void testInsertRelated() {
        DataObject g1 = (DataObject)this.context.newObject("Generic1");
        g1.writeProperty("name", "G1 Name");
        DataObject g2 = (DataObject)this.context.newObject("Generic2");
        g2.writeProperty("name", "G2 Name");
        g2.setToOneTarget("toGeneric1", g1, true);
        this.context.commitChanges();
    }

    @Test
    public void testSelect() {
        this.context.performNonSelectingQuery(new SQLTemplate("Generic1", "INSERT INTO GENERIC1 (ID, NAME) VALUES (1, 'AAAA')"));
        this.context.performNonSelectingQuery(new SQLTemplate("Generic1", "INSERT INTO GENERIC1 (ID, NAME) VALUES (2, 'BBBB')"));
        this.context.performNonSelectingQuery(new SQLTemplate("Generic1", "INSERT INTO GENERIC2 (GENERIC1_ID, ID, NAME) VALUES (1, 1, 'CCCCC')"));
        Expression qual = ExpressionFactory.matchExp("name", (Object)"AAAA");
        SelectQuery q = new SelectQuery("Generic1", qual);
        List result = this.context.performQuery(q);
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testUpdateRelated() {
        DataObject g1 = (DataObject)this.context.newObject("Generic1");
        g1.writeProperty("name", "G1 Name");
        DataObject g2 = (DataObject)this.context.newObject("Generic2");
        g2.writeProperty("name", "G2 Name");
        g2.setToOneTarget("toGeneric1", g1, true);
        this.context.commitChanges();
        List r1 = (List)g1.readProperty("generic2s");
        Assert.assertTrue((boolean)r1.contains(g2));
        DataObject g11 = (DataObject)this.context.newObject("Generic1");
        g11.writeProperty("name", "G11 Name");
        g2.setToOneTarget("toGeneric1", g11, true);
        this.context.commitChanges();
        List r11 = (List)g11.readProperty("generic2s");
        Assert.assertTrue((boolean)r11.contains(g2));
        List r1_1 = (List)g1.readProperty("generic2s");
        Assert.assertFalse((boolean)r1_1.contains(g2));
    }
}

