/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.HashSet;
import org.apache.cayenne.util.Invocation;
import org.junit.Assert;
import org.junit.Test;

public class InvocationTest {
    private String _methodName = "myListenerMethod";

    @Test
    public void testEqualsReflexive() throws NoSuchMethodException {
        Invocation inv0 = new Invocation(this, this._methodName);
        Assert.assertEquals((Object)inv0, (Object)inv0);
    }

    @Test
    public void testEqualsSymmetric() throws NoSuchMethodException {
        Invocation inv01 = new Invocation(this, this._methodName);
        Invocation inv02 = new Invocation(this, this._methodName);
        Assert.assertEquals((Object)inv01, (Object)inv02);
        Assert.assertEquals((Object)inv02, (Object)inv01);
    }

    @Test
    public void testEqualsTransitive() throws NoSuchMethodException {
        Invocation inv01 = new Invocation(this, this._methodName);
        Invocation inv02 = new Invocation(this, this._methodName);
        Invocation inv03 = new Invocation(this, this._methodName);
        Assert.assertEquals((Object)inv01, (Object)inv02);
        Assert.assertEquals((Object)inv02, (Object)inv03);
        Assert.assertEquals((Object)inv01, (Object)inv03);
    }

    @Test
    public void testEqualsNull() throws NoSuchMethodException {
        Invocation inv0 = new Invocation(this, this._methodName);
        Assert.assertTrue((!inv0.equals(null) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsDifferentMethods() throws NoSuchMethodException {
        Invocation inv0 = new Invocation(this, this._methodName);
        Invocation inv1 = new Invocation((Object)this, this._methodName, new Class[]{Object.class});
        Assert.assertTrue((!inv0.equals(inv1) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsNoVsOneArg() throws NoSuchMethodException {
        Invocation inv0 = new Invocation(this, this._methodName);
        Invocation inv1 = new Invocation((Object)this, this._methodName, new Class[]{Object.class});
        Assert.assertTrue((!inv0.equals(inv1) ? 1 : 0) != 0);
    }

    @Test
    public void testAddToSet() throws NoSuchMethodException {
        HashSet<Invocation> set = new HashSet<Invocation>();
        Invocation inv0 = new Invocation(this, this._methodName);
        set.add(inv0);
        set.add(inv0);
        Assert.assertEquals((long)1L, (long)set.size());
    }

    @Test
    public void testAddTwo() throws NoSuchMethodException {
        HashSet<Invocation> set = new HashSet<Invocation>();
        Invocation inv01 = new Invocation(this, this._methodName);
        Invocation inv02 = new Invocation(this, this._methodName);
        set.add(inv01);
        set.add(inv02);
        Assert.assertEquals((long)1L, (long)set.size());
    }

    @Test
    public void testEmptyParamTypes() throws NoSuchMethodException {
        try {
            new Invocation((Object)this, this._methodName, new Class[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNullParamTypes0() throws NoSuchMethodException {
        try {
            new Invocation((Object)this, this._methodName, new Class[]{null});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNullParamTypes1() throws NoSuchMethodException {
        try {
            new Invocation((Object)this, this._methodName, new Class[]{String.class, null});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFireNoArgument() throws NoSuchMethodException {
        Invocation inv0 = new Invocation(this, this._methodName);
        Assert.assertTrue((boolean)inv0.fire());
    }

    @Test
    public void testFireOneArgument() throws NoSuchMethodException {
        Invocation inv1 = new Invocation((Object)this, this._methodName, new Class[]{Object.class});
        Assert.assertTrue((boolean)inv1.fire("foo"));
    }

    @Test
    public void testFireWrongArgumentCount0() throws Exception {
        Invocation inv0 = new Invocation(this, this._methodName);
        try {
            inv0.fire("foo");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFireWrongArgumentCount1() throws Exception {
        Invocation inv1 = new Invocation((Object)this, this._methodName, new Class[]{Object.class});
        try {
            inv1.fire();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFireWrongArgumentCount2() throws Exception {
        Invocation inv1 = new Invocation((Object)this, this._methodName, new Class[]{Object.class});
        try {
            inv1.fire(new Object[]{"foo", "bar"});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFireNullArgArray() throws Exception {
        Invocation inv1 = new Invocation((Object)this, this._methodName, new Class[]{Object.class});
        try {
            inv1.fire(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGarbageCollection() throws NoSuchMethodException {
        Invocation inv0 = new Invocation(new String(), "toString");
        System.gc();
        System.gc();
        Assert.assertFalse((boolean)inv0.fire());
    }

    public void myListenerMethod() {
    }

    public void myListenerMethod(Object o) {
    }
}

