/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.RelationshipQuery;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class StatementFetchSizeIT
extends ServerCase {
    @Inject
    private ObjectContext context;

    @Test
    public void test() {
        SelectQuery<Artist> query = new SelectQuery<Artist>(Artist.class);
        query.setStatementFetchSize(10);
        Assert.assertEquals((long)10L, (long)query.getMetaData(this.context.getEntityResolver()).getStatementFetchSize());
        this.context.performQuery(query);
        SQLTemplate template = new SQLTemplate(Artist.class, "SELECT ARTIST_ID FROM ARTIST");
        template.setStatementFetchSize(10);
        Assert.assertEquals((long)10L, (long)template.getMetaData(this.context.getEntityResolver()).getStatementFetchSize());
        this.context.performQuery(template);
        EJBQLQuery ejbql = new EJBQLQuery("select a from Artist a");
        ejbql.setStatementFetchSize(10);
        Assert.assertEquals((long)10L, (long)ejbql.getMetaData(this.context.getEntityResolver()).getStatementFetchSize());
        this.context.performQuery(ejbql);
        ObjectId id = new ObjectId("Artist", "ARTIST_ID", 1);
        RelationshipQuery relationshipQuery = new RelationshipQuery(id, Artist.PAINTING_ARRAY.getName(), true);
        relationshipQuery.setStatementFetchSize(10);
        Assert.assertEquals((long)10L, (long)relationshipQuery.getMetaData(this.context.getEntityResolver()).getStatementFetchSize());
        this.context.performQuery(relationshipQuery);
    }
}

