/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.cache;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.apache.cayenne.cache.EhCacheQueryCache;
import org.apache.cayenne.cache.QueryCacheEntryFactory;
import org.apache.cayenne.query.QueryMetadata;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class EhCacheQueryCache_WithConfigTest {
    protected CacheManager cacheManager;

    @Before
    public void setUp() throws Exception {
        URL config = this.getClass().getResource("test-ehcache.xml");
        Assert.assertNotNull((Object)config);
        this.cacheManager = new CacheManager(config);
    }

    @After
    public void tearDown() throws Exception {
        this.cacheManager.shutdown();
    }

    @Test
    public void testRemoveGroup_WithFactory_WithCacheGroups() {
        EhCacheQueryCache cache = new EhCacheQueryCache(this.cacheManager);
        ArrayList[] lists = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList()};
        QueryCacheEntryFactory factory = (QueryCacheEntryFactory)Mockito.mock(QueryCacheEntryFactory.class);
        Mockito.when((Object)factory.createObject()).thenReturn((Object)lists[0], (Object[])new List[]{lists[1], lists[2]});
        QueryMetadata md = (QueryMetadata)Mockito.mock(QueryMetadata.class);
        Mockito.when((Object)md.getCacheKey()).thenReturn((Object)"k1");
        Mockito.when((Object)md.getCacheGroups()).thenReturn((Object)new String[]{"cg1"});
        Assert.assertEquals((Object)lists[0], (Object)cache.get(md, factory));
        Assert.assertEquals((Object)lists[0], (Object)cache.get(md, factory));
        Cache c1 = cache.cacheManager.getCache("cg1");
        Assert.assertEquals((long)201L, (long)c1.getCacheConfiguration().getTimeToLiveSeconds());
        cache.removeGroup("cg0");
        Assert.assertEquals((Object)lists[0], (Object)cache.get(md, factory));
        Cache c2 = cache.cacheManager.getCache("cg1");
        Assert.assertSame((Object)c1, (Object)c2);
        Assert.assertEquals((long)201L, (long)c2.getCacheConfiguration().getTimeToLiveSeconds());
        cache.removeGroup("cg1");
        Assert.assertEquals((Object)lists[1], (Object)cache.get(md, factory));
        Cache c3 = cache.cacheManager.getCache("cg1");
        Assert.assertSame((Object)c1, (Object)c3);
        Assert.assertEquals((long)201L, (long)c3.getCacheConfiguration().getTimeToLiveSeconds());
    }
}

