/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.map.DefaultEntityResultSegment;
import org.apache.cayenne.map.DefaultScalarResultSegment;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.EntityResult;
import org.apache.cayenne.reflect.ClassDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLResult {
    protected String name;
    protected List<Object> resultDescriptors;

    public SQLResult() {
    }

    public List<Object> getResolvedComponents(EntityResolver resolver) {
        if (this.resultDescriptors == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> resolvedComponents = new ArrayList<Object>(this.resultDescriptors.size());
        int offset = 0;
        for (Object component : this.getComponents()) {
            if (component instanceof String) {
                resolvedComponents.add(new DefaultScalarResultSegment((String)component, offset));
                ++offset;
                continue;
            }
            if (component instanceof EntityResult) {
                EntityResult entityResult = (EntityResult)component;
                Map<String, String> fields = entityResult.getDbFields(resolver);
                String entityName = entityResult.getEntityName();
                if (entityName == null) {
                    entityName = resolver.getObjEntity(entityResult.getEntityClass()).getName();
                }
                ClassDescriptor classDescriptor = resolver.getClassDescriptor(entityName);
                resolvedComponents.add(new DefaultEntityResultSegment(classDescriptor, fields, offset));
                offset += fields.size();
                continue;
            }
            throw new IllegalArgumentException("Unsupported result descriptor component: " + component);
        }
        return resolvedComponents;
    }

    public SQLResult(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Object> getComponents() {
        return this.resultDescriptors != null ? this.resultDescriptors : Collections.emptyList();
    }

    public void addEntityResult(EntityResult entityResult) {
        if (this.resultDescriptors == null) {
            this.resultDescriptors = new ArrayList<Object>(3);
        }
        this.resultDescriptors.add(entityResult);
    }

    public void addColumnResult(String column) {
        if (this.resultDescriptors == null) {
            this.resultDescriptors = new ArrayList<Object>(3);
        }
        this.resultDescriptors.add(column);
    }
}

