/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.SimpleNode;
import org.apache.cayenne.util.ConversionUtil;

public class ASTDivide
extends SimpleNode {
    ASTDivide(int id) {
        super(id);
    }

    public ASTDivide() {
        super(30);
    }

    public ASTDivide(Object[] nodes) {
        super(30);
        int len = nodes.length;
        for (int i = 0; i < len; ++i) {
            this.jjtAddChild(this.wrapChild(nodes[i]), i);
        }
        this.connectChildren();
    }

    public ASTDivide(Collection nodes) {
        super(30);
        int len = nodes.size();
        Iterator it = nodes.iterator();
        for (int i = 0; i < len; ++i) {
            this.jjtAddChild(this.wrapChild(it.next()), i);
        }
        this.connectChildren();
    }

    protected Object evaluateNode(Object o) throws Exception {
        int len = this.jjtGetNumChildren();
        if (len == 0) {
            return null;
        }
        BigDecimal result = null;
        for (int i = 0; i < len; ++i) {
            BigDecimal value = ConversionUtil.toBigDecimal(this.evaluateChild(i, o));
            if (value == null) {
                return null;
            }
            result = i == 0 ? value : result.divide(value, 6);
        }
        return result;
    }

    public Expression shallowCopy() {
        return new ASTDivide(this.id);
    }

    protected String getExpressionOperator(int index) {
        return "/";
    }

    public int getType() {
        return 19;
    }

    public void jjtClose() {
        super.jjtClose();
        this.flattenTree();
    }
}

