/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.mysql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.JdbcPkGenerator;
import org.apache.cayenne.map.DbEntity;

public class MySQLPkGenerator
extends JdbcPkGenerator {
    MySQLPkGenerator(JdbcAdapter adapter) {
        super(adapter);
    }

    protected String dropAutoPkString() {
        return "DROP TABLE IF EXISTS AUTO_PK_SUPPORT";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected long longPkFromDatabase(DataNode node, DbEntity entity) throws Exception {
        SQLException exception = null;
        long pk = -1L;
        Connection con = node.getDataSource().getConnection();
        try {
            if (con.getAutoCommit()) {
                con.setAutoCommit(false);
            }
            Statement st = con.createStatement();
            try {
                pk = this.getLongPrimaryKey(st, entity.getName());
                con.commit();
            }
            catch (SQLException pkEx) {
                try {
                    con.rollback();
                }
                catch (SQLException e) {
                    // empty catch block
                }
                exception = this.processSQLException(pkEx, exception);
            }
            finally {
                block51: {
                    String unlockString = "UNLOCK TABLES";
                    this.adapter.getJdbcEventLogger().logQuery(unlockString, Collections.EMPTY_LIST);
                    st.execute(unlockString);
                    try {
                        st.close();
                    }
                    catch (SQLException stClosingEx) {}
                    break block51;
                    catch (SQLException unlockEx) {
                        try {
                            exception = this.processSQLException(unlockEx, exception);
                        }
                        catch (Throwable throwable) {
                            try {
                                st.close();
                            }
                            catch (SQLException stClosingEx) {}
                            throw throwable;
                        }
                        try {
                            st.close();
                        }
                        catch (SQLException stClosingEx) {}
                    }
                }
            }
        }
        catch (SQLException otherEx) {
            exception = this.processSQLException(otherEx, exception);
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException closingEx) {}
        }
        if (exception != null) {
            throw exception;
        }
        return pk;
    }

    protected SQLException processSQLException(SQLException exception, SQLException parent) {
        if (parent == null) {
            return exception;
        }
        parent.setNextException(exception);
        return parent;
    }

    protected String pkTableCreateString() {
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE TABLE IF NOT EXISTS AUTO_PK_SUPPORT (").append("  TABLE_NAME CHAR(100) NOT NULL,").append("  NEXT_ID BIGINT NOT NULL, UNIQUE (TABLE_NAME)").append(")");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getLongPrimaryKey(Statement statement, String entityName) throws SQLException {
        String lockString = "LOCK TABLES AUTO_PK_SUPPORT WRITE";
        this.adapter.getJdbcEventLogger().logQuery(lockString, Collections.EMPTY_LIST);
        statement.execute(lockString);
        long pk = -1L;
        String selectString = super.pkSelectString(entityName);
        this.adapter.getJdbcEventLogger().logQuery(selectString, Collections.EMPTY_LIST);
        ResultSet rs = statement.executeQuery(selectString);
        try {
            if (!rs.next()) {
                throw new SQLException("No rows for '" + entityName + "'");
            }
            pk = rs.getLong(1);
            if (rs.next()) {
                throw new SQLException("More than one row for '" + entityName + "'");
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception ex) {}
        }
        String updateString = super.pkUpdateString(entityName) + " AND NEXT_ID = " + pk;
        this.adapter.getJdbcEventLogger().logQuery(updateString, Collections.EMPTY_LIST);
        int updated = statement.executeUpdate(updateString);
        if (updated != 1) {
            throw new SQLException("Error updating PK count '" + entityName + "': " + updated);
        }
        return pk;
    }
}

