/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.firebird;

import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.trans.QualifierTranslator;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.access.types.ByteArrayType;
import org.apache.cayenne.access.types.CharType;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dba.firebird.FirebirdMergerFactory;
import org.apache.cayenne.dba.firebird.FirebirdQualifierTranslator;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirebirdAdapter
extends JdbcAdapter {
    public FirebirdAdapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.server.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.server.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.server.type_factories") List<ExtendedTypeFactory> extendedTypeFactories) {
        super(runtimeProperties, defaultExtendedTypes, userExtendedTypes, extendedTypeFactories);
        this.setSupportsBatchUpdates(true);
    }

    @Override
    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new ByteArrayType(true, false));
        map.registerType(new CharType(true, false));
    }

    @Override
    public FirebirdMergerFactory mergerFactory() {
        return new FirebirdMergerFactory();
    }

    @Override
    public void createTableAppendColumn(StringBuffer sqlBuffer, DbAttribute column) {
        String[] types = this.externalTypesForJdbcType(column.getType());
        if (types == null || types.length == 0) {
            String entityName = column.getEntity() != null ? ((DbEntity)column.getEntity()).getFullyQualifiedName() : "<null>";
            throw new CayenneRuntimeException("Undefined type for attribute '" + entityName + "." + column.getName() + "': " + column.getType(), new Object[0]);
        }
        String type = types[0];
        sqlBuffer.append(this.quotingStrategy.quotedName(column));
        sqlBuffer.append(' ').append(type);
        if (TypesMapping.supportsLength(column.getType())) {
            int scale;
            int len = column.getMaxLength();
            int n = scale = TypesMapping.isDecimal(column.getType()) && column.getType() != 6 ? column.getScale() : -1;
            if (scale > len) {
                scale = -1;
            }
            if (len > 0) {
                sqlBuffer.append('(').append(len);
                if (scale >= 0) {
                    sqlBuffer.append(", ").append(scale);
                }
                sqlBuffer.append(')');
            }
        }
        sqlBuffer.append(column.isMandatory() ? " NOT NULL" : "");
    }

    @Override
    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        FirebirdQualifierTranslator translator = new FirebirdQualifierTranslator(queryAssembler);
        return translator;
    }
}

