/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.Entity;

public class DefaultQuotingStrategy
implements QuotingStrategy {
    private String endQuote;
    private String startQuote;

    public DefaultQuotingStrategy(String startQuote, String endQuote) {
        this.startQuote = startQuote;
        this.endQuote = endQuote;
    }

    @Deprecated
    public String quoteString(String name) {
        return this.quotedIdentifier((DataMap)null, name);
    }

    @Deprecated
    public String quoteFullyQualifiedName(DbEntity entity) {
        return this.quotedFullyQualifiedName(entity);
    }

    public String quotedFullyQualifiedName(DbEntity entity) {
        return this.quotedIdentifier(entity.getDataMap(), entity.getCatalog(), entity.getSchema(), entity.getName());
    }

    public String quotedName(DbAttribute attribute) {
        return this.quotedIdentifier(attribute.getEntity().getDataMap(), attribute.getName());
    }

    public String quotedSourceName(DbJoin join) {
        DataMap dataMap = join.getSource().getEntity().getDataMap();
        return this.quotedIdentifier(dataMap, join.getSourceName());
    }

    public String quotedTargetName(DbJoin join) {
        DataMap dataMap = join.getTarget().getEntity().getDataMap();
        return this.quotedIdentifier(dataMap, join.getTargetName());
    }

    public String quotedIdentifier(Entity entity, String ... identifierParts) {
        return this.quotedIdentifier(entity.getDataMap(), identifierParts);
    }

    public String quotedIdentifier(DataMap dataMap, String ... identifierParts) {
        String endQuote;
        String startQuote;
        if (dataMap != null && dataMap.isQuotingSQLIdentifiers()) {
            startQuote = this.startQuote;
            endQuote = this.endQuote;
        } else {
            startQuote = "";
            endQuote = "";
        }
        StringBuilder buffer = new StringBuilder();
        for (String part : identifierParts) {
            if (part == null) continue;
            if (buffer.length() > 0) {
                buffer.append(".");
            }
            buffer.append(startQuote).append(part).append(endQuote);
        }
        return buffer.toString();
    }
}

