/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration;

import java.util.Collection;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.configuration.ObjectContextFactory;
import org.apache.cayenne.di.BeforeScopeEnd;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CayenneRuntime {
    protected static final ThreadLocal<Injector> threadInjector = new ThreadLocal();
    protected Injector injector;
    protected Module[] modules;

    public static void bindThreadInjector(Injector injector) {
        threadInjector.set(injector);
    }

    public static Injector getThreadInjector() {
        return threadInjector.get();
    }

    protected static Module[] mergeModules(Module mainModule, Module ... extraModules) {
        if (extraModules == null || extraModules.length == 0) {
            return new Module[]{mainModule};
        }
        Module[] allModules = new Module[extraModules.length + 1];
        allModules[0] = mainModule;
        System.arraycopy(extraModules, 0, allModules, 1, extraModules.length);
        return allModules;
    }

    protected static Module[] mergeModules(Module mainModule, Collection<Module> extraModules) {
        if (extraModules == null || extraModules.isEmpty()) {
            return new Module[]{mainModule};
        }
        Module[] allModules = new Module[extraModules.size() + 1];
        allModules[0] = mainModule;
        System.arraycopy(extraModules.toArray(), 0, allModules, 1, extraModules.size());
        return allModules;
    }

    public CayenneRuntime(Module ... modules) {
        if (modules == null) {
            modules = new Module[]{};
        }
        this.modules = modules;
        this.injector = DIBootstrap.createInjector(modules);
    }

    public CayenneRuntime(Collection<Module> modules) {
        this.modules = modules == null ? new Module[0] : modules.toArray(new Module[modules.size()]);
        this.injector = DIBootstrap.createInjector(this.modules);
    }

    public Module[] getModules() {
        return this.modules;
    }

    public Injector getInjector() {
        return this.injector;
    }

    @BeforeScopeEnd
    public void shutdown() {
        this.injector.shutdown();
    }

    public DataChannel getChannel() {
        return this.injector.getInstance(DataChannel.class);
    }

    public ObjectContext newContext() {
        return this.injector.getInstance(ObjectContextFactory.class).createContext();
    }

    public ObjectContext newContext(DataChannel parentChannel) {
        return this.injector.getInstance(ObjectContextFactory.class).createContext(parentChannel);
    }

    @Deprecated
    public ObjectContext getContext() {
        return this.newContext();
    }

    @Deprecated
    public ObjectContext getContext(DataChannel parentChannel) {
        return this.newContext(parentChannel);
    }
}

