/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.ResultIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionResultIterator<T>
implements ResultIterator<T> {
    protected Iterator<T> iterator;

    public CollectionResultIterator(Collection<T> c) {
        this.iterator = c.iterator();
    }

    @Override
    public Iterator<T> iterator() {
        this.checkIterator();
        return this.iterator;
    }

    @Override
    public List<T> allRows() {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : this) {
            list.add(t);
        }
        return list;
    }

    @Override
    public boolean hasNextRow() {
        this.checkIterator();
        return this.iterator.hasNext();
    }

    @Override
    public T nextRow() {
        this.checkIterator();
        return this.iterator.next();
    }

    @Override
    public void skipRow() {
        this.checkIterator();
        this.iterator.next();
    }

    @Override
    public void close() {
        this.iterator = null;
    }

    protected void checkIterator() {
        if (this.iterator == null) {
            throw new IllegalStateException("Iterator is closed");
        }
    }
}

