/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Map;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.ObjectMapRetainStrategy;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.di.Inject;
import org.apache.commons.collections.map.ReferenceMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultObjectMapRetainStrategy
implements ObjectMapRetainStrategy {
    protected RuntimeProperties runtimeProperties;

    public DefaultObjectMapRetainStrategy(@Inject RuntimeProperties runtimeProperties) {
        this.runtimeProperties = runtimeProperties;
    }

    @Override
    public Map<Object, Persistent> createObjectMap() {
        String retainStrategy = this.runtimeProperties.get("org.apache.cayenne.context_object_retain_strategy");
        if ("soft".equals(retainStrategy)) {
            return new ReferenceMap(0, 1);
        }
        if ("hard".equals(retainStrategy)) {
            return new ReferenceMap(0, 0);
        }
        return new ReferenceMap(0, 2);
    }
}

