/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.cache;

import java.util.List;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.cache.QueryCacheEntryFactory;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.query.QueryMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryCacheLazyInitializationProxy
implements QueryCache {
    private volatile QueryCache delegate;
    private Provider<QueryCache> provider;

    public QueryCacheLazyInitializationProxy(Provider<QueryCache> provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final QueryCache getDelegate() {
        if (this.delegate == null) {
            QueryCacheLazyInitializationProxy queryCacheLazyInitializationProxy = this;
            synchronized (queryCacheLazyInitializationProxy) {
                if (this.delegate == null) {
                    this.delegate = this.provider.get();
                }
            }
        }
        return this.delegate;
    }

    @Override
    public void clear() {
        if (this.delegate != null) {
            this.delegate.clear();
        }
    }

    @Override
    public List get(QueryMetadata metadata, QueryCacheEntryFactory factory) {
        return this.getDelegate().get(metadata, factory);
    }

    @Override
    public List get(QueryMetadata metadata) {
        return this.getDelegate().get(metadata);
    }

    @Override
    public void put(QueryMetadata metadata, List results) {
        this.getDelegate().put(metadata, results);
    }

    @Override
    public void remove(String key) {
        this.getDelegate().remove(key);
    }

    @Override
    public void removeGroup(String groupKey) {
        this.getDelegate().removeGroup(groupKey);
    }

    @Override
    public int size() {
        return this.getDelegate().size();
    }
}

