/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DeleteDenyException;
import org.apache.cayenne.FaultFailureException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectContextDeleteAction;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.PersistenceState;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.configuration.CayenneRuntime;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.exp.ValueInjector;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.GraphEvent;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.RefreshQuery;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.Property;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.util.ObjectContextGraphAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseContext
implements ObjectContext,
DataChannel {
    public static final String QUERY_CACHE_INJECTION_KEY = "local";
    protected static final ThreadLocal<ObjectContext> threadObjectContext = new ThreadLocal();
    protected transient DataChannel channel;
    protected transient QueryCache queryCache;
    protected transient EntityResolver entityResolver;
    protected ObjectContextGraphAction graphAction = new ObjectContextGraphAction(this);
    protected Map<String, Object> userProperties;

    public static ObjectContext getThreadObjectContext() throws IllegalStateException {
        ObjectContext context = threadObjectContext.get();
        if (context == null) {
            throw new IllegalStateException("Current thread has no bound ObjectContext.");
        }
        return context;
    }

    public static void bindThreadObjectContext(ObjectContext context) {
        threadObjectContext.set(context);
    }

    protected BaseContext() {
    }

    protected boolean attachToRuntimeIfNeeded() {
        if (this.channel != null) {
            return false;
        }
        Injector injector = CayenneRuntime.getThreadInjector();
        if (injector == null) {
            throw new CayenneRuntimeException("Can't attach to Cayenne runtime. Null injector returned from CayenneRuntime.getThreadInjector()", new Object[0]);
        }
        this.attachToRuntime(injector);
        return true;
    }

    protected void attachToRuntime(Injector injector) {
        this.attachToChannel(injector.getInstance(DataChannel.class));
        this.setQueryCache(injector.getInstance(Key.get(QueryCache.class, QUERY_CACHE_INJECTION_KEY)));
    }

    protected void attachToChannel(DataChannel channel) {
        if (channel == null) {
            throw new NullPointerException("Null channel");
        }
        this.setChannel(channel);
        this.setEntityResolver(channel.getEntityResolver());
    }

    @Override
    public abstract void commitChanges();

    @Override
    public abstract void commitChangesToParent();

    @Override
    public abstract Collection<?> deletedObjects();

    @Override
    public DataChannel getChannel() {
        this.attachToRuntimeIfNeeded();
        return this.channel;
    }

    public void setChannel(DataChannel channel) {
        this.channel = channel;
    }

    @Override
    public EntityResolver getEntityResolver() {
        this.attachToRuntimeIfNeeded();
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public abstract GraphManager getGraphManager();

    @Override
    public abstract Persistent localObject(ObjectId var1, Object var2);

    @Override
    public abstract Collection<?> modifiedObjects();

    @Override
    public abstract <T> T newObject(Class<T> var1);

    @Override
    public abstract void registerNewObject(Object var1);

    @Override
    public abstract Collection<?> newObjects();

    @Override
    public abstract QueryResponse performGenericQuery(Query var1);

    @Override
    public abstract List performQuery(Query var1);

    @Override
    public void prepareForAccess(Persistent object, String property, boolean lazyFaulting) {
        if (object.getPersistenceState() == 5) {
            ObjectId oid = object.getObjectId();
            List objects = this.performQuery(new ObjectIdQuery(oid, false, 1));
            if (objects.size() == 0) {
                throw new FaultFailureException("Error resolving fault, no matching row exists in the database for ObjectId: " + oid, new Object[0]);
            }
            if (objects.size() > 1) {
                throw new FaultFailureException("Error resolving fault, more than one row exists in the database for ObjectId: " + oid, new Object[0]);
            }
            if (object.getPersistenceState() != 3) {
                String state = PersistenceState.persistenceStateName(object.getPersistenceState());
                throw new FaultFailureException("Error resolving fault for ObjectId: " + oid + " and state (" + state + "). Possible cause - matching row is missing from the database.", new Object[0]);
            }
        }
        if (lazyFaulting && property != null) {
            ClassDescriptor classDescriptor = this.getEntityResolver().getClassDescriptor(object.getObjectId().getEntityName());
            Property propertyDescriptor = classDescriptor.getProperty(property);
            if (propertyDescriptor == null) {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append(String.format("Property '%s' is not declared for entity '%s'.", property, object.getObjectId().getEntityName()));
                errorMessage.append(" Declared properties are: ");
                final ArrayList properties = new ArrayList();
                classDescriptor.visitProperties(new PropertyVisitor(){

                    public boolean visitAttribute(AttributeProperty property) {
                        properties.add(property.getName());
                        return true;
                    }

                    public boolean visitToOne(ToOneProperty property) {
                        properties.add(property.getName());
                        return true;
                    }

                    public boolean visitToMany(ToManyProperty property) {
                        properties.add(property.getName());
                        return true;
                    }
                });
                boolean first = true;
                for (String declaredProperty : properties) {
                    if (first) {
                        errorMessage.append(String.format("'%s'", declaredProperty));
                        first = false;
                        continue;
                    }
                    errorMessage.append(String.format(", '%s'", declaredProperty));
                }
                errorMessage.append(".");
                throw new CayenneRuntimeException(errorMessage.toString(), new Object[0]);
            }
            propertyDescriptor.readProperty(object);
        }
    }

    @Override
    public void propertyChanged(Persistent object, String property, Object oldValue, Object newValue) {
        this.graphAction.handlePropertyChange(object, property, oldValue, newValue);
    }

    @Override
    public abstract void rollbackChanges();

    @Override
    public abstract void rollbackChangesLocally();

    @Override
    public abstract Collection<?> uncommittedObjects();

    public QueryCache getQueryCache() {
        this.attachToRuntimeIfNeeded();
        return this.queryCache;
    }

    public void setQueryCache(QueryCache queryCache) {
        this.queryCache = queryCache;
    }

    @Override
    public EventManager getEventManager() {
        return this.channel != null ? this.channel.getEventManager() : null;
    }

    @Override
    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType) {
        switch (syncType) {
            case 3: {
                return this.onContextRollback(originatingContext);
            }
            case 1: {
                return this.onContextFlush(originatingContext, changes, false);
            }
            case 2: {
                return this.onContextFlush(originatingContext, changes, true);
            }
        }
        throw new CayenneRuntimeException("Unrecognized SyncMessage type: " + syncType, new Object[0]);
    }

    GraphDiff onContextRollback(ObjectContext originatingContext) {
        this.rollbackChanges();
        return new CompoundDiff();
    }

    protected abstract GraphDiff onContextFlush(ObjectContext var1, GraphDiff var2, boolean var3);

    protected void fireDataChannelCommitted(Object postedBy, GraphDiff changes) {
        EventManager manager = this.getEventManager();
        if (manager != null) {
            GraphEvent e = new GraphEvent((Object)this, postedBy, changes);
            manager.postEvent(e, DataChannel.GRAPH_FLUSHED_SUBJECT);
        }
    }

    protected void fireDataChannelRolledback(Object postedBy, GraphDiff changes) {
        EventManager manager = this.getEventManager();
        if (manager != null) {
            GraphEvent e = new GraphEvent((Object)this, postedBy, changes);
            manager.postEvent(e, DataChannel.GRAPH_ROLLEDBACK_SUBJECT);
        }
    }

    protected void fireDataChannelChanged(Object postedBy, GraphDiff changes) {
        EventManager manager = this.getEventManager();
        if (manager != null) {
            GraphEvent e = new GraphEvent((Object)this, postedBy, changes);
            manager.postEvent(e, DataChannel.GRAPH_CHANGED_SUBJECT);
        }
    }

    @Override
    public void invalidateObjects(Collection objects) {
        this.performGenericQuery(new RefreshQuery(objects));
    }

    protected Map<String, Object> getUserProperties() {
        if (this.userProperties == null) {
            this.userProperties = new HashMap<String, Object>();
        }
        return this.userProperties;
    }

    @Override
    public Object getUserProperty(String key) {
        return this.getUserProperties().get(key);
    }

    @Override
    public void setUserProperty(String key, Object value) {
        this.getUserProperties().put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void injectInitialValue(Object obj) {
        ObjEntity entity;
        GraphManager graphManager;
        Persistent object = (Persistent)obj;
        object.setObjectContext(this);
        object.setPersistenceState(2);
        GraphManager graphManager2 = graphManager = this.getGraphManager();
        synchronized (graphManager2) {
            graphManager.registerNode(object.getObjectId(), object);
            graphManager.nodeCreated(object.getObjectId());
        }
        try {
            entity = this.getEntityResolver().lookupObjEntity(object.getClass());
        }
        catch (CayenneRuntimeException ex) {
            entity = null;
        }
        if (entity != null && entity.getDeclaredQualifier() instanceof ValueInjector) {
            ((ValueInjector)((Object)entity.getDeclaredQualifier())).injectValue(object);
        }
        this.getEntityResolver().getCallbackRegistry().performCallbacks(LifecycleEvent.POST_ADD, object);
    }

    @Override
    public void deleteObject(Object object) {
        new ObjectContextDeleteAction(this).performDelete((Persistent)object);
    }

    @Override
    public void deleteObjects(Collection<?> objects) throws DeleteDenyException {
        if (objects.isEmpty()) {
            return;
        }
        ObjectContextDeleteAction ocda = new ObjectContextDeleteAction(this);
        for (Persistent object : new ArrayList(objects)) {
            ocda.performDelete(object);
        }
    }
}

