/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.cayenne.exp.ExpressionException;

public final class ConversionUtil {
    public static int toInt(Object object, int defaultValue) {
        if (object == null) {
            return defaultValue;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException ex) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static boolean toBoolean(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() != 0;
        }
        return object != null;
    }

    public static BigDecimal toBigDecimal(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof BigInteger) {
            return new BigDecimal((BigInteger)object);
        }
        if (object instanceof Number) {
            return new BigDecimal(((Number)object).doubleValue());
        }
        throw new ExpressionException("Can't convert to BigDecimal: " + object, new Object[0]);
    }

    public static Comparable toComparable(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Comparable) {
            return (Comparable)object;
        }
        if (object instanceof StringBuffer) {
            return object.toString();
        }
        if (object instanceof char[]) {
            return new String((char[])object);
        }
        throw new ClassCastException("Invalid Comparable class:" + object.getClass().getName());
    }

    public static String toString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof StringBuffer) {
            return object.toString();
        }
        if (object instanceof char[]) {
            return new String((char[])object);
        }
        throw new ClassCastException("Invalid class for String conversion:" + object.getClass().getName());
    }

    public static Object toUpperCase(Object object) {
        if (object instanceof String || object instanceof StringBuffer) {
            return object.toString().toUpperCase();
        }
        if (object instanceof char[]) {
            return new String((char[])object).toUpperCase();
        }
        return object;
    }

    private ConversionUtil() {
    }
}

